DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.15631605696904E-11   0.00000000000000E+00   2.32934690998765E-14   1.57119550047242E-22
      1.15632410943475E-08   1.15632643878167E-08  -7.94489341009272E-19  -2.48476022240008E-01  -2.48476022240019E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07050859599882E-11   0.00000000000000E+00   1.07050859599882E-11
      3.70608115864740E-18  -2.48476022247972E-01  -2.44829628804074E-01   0.00000000000000E+00  -1.83871617158108E-14
     -9.83008693154353E-23  -1.15739510866149E-08  -1.15739694737767E-08  -2.91159181763812E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.11043042626016E-11   0.00000000000000E+00   3.63542523837702E-14   1.51846244875358E-22
      1.11043320261641E-08   1.11043683804167E-08  -7.98263410123917E-19  -2.46740124895124E-01  -2.46740124895135E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12985081252394E-11   0.00000000000000E+00   1.12985081252394E-11
      3.71370765163193E-18  -2.46740124911844E-01  -2.43238121081783E-01   0.00000000000000E+00  -2.43605130525653E-14
     -9.82420313724203E-23  -1.11156425280288E-08  -1.11156668885419E-08  -2.91544424150801E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.06571122371382E-11   0.00000000000000E+00   9.36578018672472E-14   1.48183813394969E-22
      1.06570650544637E-08   1.06571587122657E-08  -8.02239875842987E-19  -2.44821708421277E-01  -2.44821708421288E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10187084652415E-11   0.00000000000000E+00   1.10187084652415E-11
      3.72374844972088E-18  -2.44821708447268E-01  -2.41460702170702E-01   0.00000000000000E+00  -7.80739735715877E-14
     -9.81576022724723E-23  -1.06680993467573E-08  -1.06681774207310E-08  -2.92150857387790E-18
      2.39379687500000E-09
      0.00000000000000E+00  -1.05237536787128E-11   0.00000000000000E+00  -2.15317639544860E-14   1.47249192445079E-22
      1.05238080636897E-08   1.05237865319259E-08  -8.03472067085924E-19  -2.44217084596507E-01  -2.44217084596518E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08367811000724E-11   0.00000000000000E+00   1.08367811000724E-11
      3.72708126788327E-18  -2.44217084400327E-01  -2.40898117530951E-01   0.00000000000000E+00   3.81467703616109E-14
     -9.81290077805784E-23  -1.05346614597962E-08  -1.05346233130259E-08  -2.92360920079734E-18
      2.80898515625000E-09
      0.00000000000000E+00  -1.03666991780880E-11   0.00000000000000E+00  -1.65286973563398E-14   1.46389102477534E-22
      1.03667304696588E-08   1.03667139409616E-08  -8.04967745861398E-19  -2.43469163048261E-01  -2.43469163048271E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05054530487260E-11   0.00000000000000E+00   1.05054530487260E-11
      3.73144300887832E-18  -2.43469162858934E-01  -2.40199787085741E-01   0.00000000000000E+00   3.36557865917130E-14
     -9.80905980258723E-23  -1.03772530497968E-08  -1.03772193940103E-08  -2.92647526301692E-18
      3.36948933593750E-09
      0.00000000000000E+00  -1.01869590273728E-11   0.00000000000000E+00  -1.13687117508164E-14   1.45723687339768E-22
      1.01870161298299E-08   1.01870047611183E-08  -8.06738956326672E-19  -2.42565264377326E-01  -2.42565264377336E-01
      0.00000000000000E+00   0.00000000000000E+00   9.96001797235243E-12   0.00000000000000E+00   9.96001797235243E-12
      3.73702564058159E-18  -2.42565264197302E-01  -2.39352678640856E-01   0.00000000000000E+00   2.85692612779392E-14
     -9.80401862013983E-23  -1.01969933483518E-08  -1.01969647790906E-08  -2.93028668425491E-18
      4.12616997851563E-09
      0.00000000000000E+00  -9.98802332658133E-12   0.00000000000000E+00  -4.67335494096203E-15   1.45376958238823E-22
      9.98800740178997E-09   9.98800272843518E-09  -8.08777130203838E-19  -2.41503618322554E-01  -2.41503618322563E-01
      0.00000000000000E+00   0.00000000000000E+00   9.15765492639615E-12   0.00000000000000E+00   9.15765492639615E-12
      3.74395506079580E-18  -2.41503618152896E-01  -2.38353982439472E-01   0.00000000000000E+00   2.13118092292440E-14
     -9.79760495240253E-23  -9.99718169517069E-09  -9.99716038336156E-09  -2.93517793059196E-18
      5.14768884599610E-09
      0.00000000000000E+00  -9.77549460468311E-12   0.00000000000000E+00   3.82896941981443E-15   1.45440084203501E-22
      9.77547748313009E-09   9.77548131209965E-09  -8.11044408106125E-19  -2.40299793962305E-01  -2.40299793962313E-01
      0.00000000000000E+00   0.00000000000000E+00   8.08560805556603E-12   0.00000000000000E+00   8.08560805556603E-12
      3.75221466197961E-18  -2.40299793803533E-01  -2.37217452757783E-01   0.00000000000000E+00   1.14857279917770E-14
     -9.78978722600001E-23  -9.78357840588313E-09  -9.78356692015523E-09  -2.94117025387349E-18
      6.52673931709473E-09
      0.00000000000000E+00  -9.55763888802686E-12   0.00000000000000E+00   1.42076947677731E-14   1.45932802198738E-22
      9.55764318491897E-09   9.55765739261388E-09  -8.13465121087904E-19  -2.38993052731921E-01  -2.38993052731928E-01
      0.00000000000000E+00   0.00000000000000E+00   6.77948244063848E-12   0.00000000000000E+00   6.77948244063848E-12
      3.76156391043318E-18  -2.38993052584913E-01  -2.35979751134216E-01   0.00000000000000E+00  -9.70711863397590E-16
     -9.78077183160305E-23  -9.56443590434255E-09  -9.56443687505451E-09  -2.94809878934527E-18
      8.38845745307788E-09
      0.00000000000000E+00  -9.34492647665422E-12   0.00000000000000E+00   2.61580795731028E-14   1.46781369176387E-22
      9.34495038445713E-09   9.34497654253685E-09  -8.15920855958299E-19  -2.37649927241536E-01  -2.37649927241541E-01
      0.00000000000000E+00   0.00000000000000E+00   5.33099916219526E-12   0.00000000000000E+00   5.33099916219526E-12
      3.77148872825635E-18  -2.37649927110045E-01  -2.34704090337012E-01   0.00000000000000E+00  -1.55701318636262E-14
     -9.77106875852224E-23  -9.35029197156708E-09  -9.35030754169903E-09  -2.95556787229805E-18
      1.03884574530779E-08
      0.00000000000000E+00  -9.17905488125743E-12   0.00000000000000E+00   1.52991265662126E-14   1.47648341818495E-22
      9.17907871478246E-09   9.17909401390918E-09  -8.17895629469794E-19  -2.36560566618054E-01  -2.36560566618058E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10763911301391E-12   0.00000000000000E+00   4.10763911301391E-12
      3.77970400648238E-18  -2.36560566511068E-01  -2.33667372656301E-01   0.00000000000000E+00  -7.04078145325295E-15
     -9.76297631281045E-23  -9.18319461224064E-09  -9.18320165302219E-09  -2.96180837701259E-18
      1.23884574530779E-08
      0.00000000000000E+00  -9.05653400182259E-12   0.00000000000000E+00   6.59164259993147E-15   1.48390386328008E-22
      9.05646963045258E-09   9.05647622209533E-09  -8.19387921290068E-19  -2.35732973902523E-01  -2.35732973902526E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15885052968966E-12   0.00000000000000E+00   3.15885052968966E-12
      3.78602170754176E-18  -2.35732973831399E-01  -2.32878706629669E-01   0.00000000000000E+00  -1.93900850123011E-16
     -9.75673244961960E-23  -9.05963487872408E-09  -9.05963507262503E-09  -2.96663378625169E-18
      1.43884574530779E-08
      0.00000000000000E+00  -8.96468926461506E-12   0.00000000000000E+00   2.78817998648596E-15   1.48995605706177E-22
      8.96468362299876E-09   8.96468641117889E-09  -8.20522670756433E-19  -2.35101579558787E-01  -2.35101579558790E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42746878871550E-12   0.00000000000000E+00   2.42746878871550E-12
      3.79087664511919E-18  -2.35101579541135E-01  -2.32276459761258E-01   0.00000000000000E+00   2.14228615665689E-15
     -9.75193038114478E-23  -8.96711602225368E-09  -8.96711387996762E-09  -2.97035397436275E-18
      1.63884574530779E-08
      0.00000000000000E+00  -8.89534648802338E-12   0.00000000000000E+00   3.60478762078303E-14   1.49476768064182E-22
      8.89536579371169E-09   8.89540184158805E-09  -8.21389087787042E-19  -2.34618481528343E-01  -2.34618481528345E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86521056714606E-12   0.00000000000000E+00   1.86521056714606E-12
      3.79460706625348E-18  -2.34618481583726E-01  -2.31815377365901E-01   0.00000000000000E+00  -3.24414048651037E-14
     -9.74823890787371E-23  -8.89723461075023E-09  -8.89726705215520E-09  -2.97321797846644E-18
      1.83884574530779E-08
      0.00000000000000E+00  -8.84271945360347E-12   0.00000000000000E+00   3.01063877965883E-15   1.49854669365266E-22
      8.84273563132798E-09   8.84273864196691E-09  -8.22052590590046E-19  -2.34248051732464E-01  -2.34248051732465E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43350904208166E-12   0.00000000000000E+00   1.43350904208166E-12
      3.79747408433764E-18  -2.34248051883365E-01  -2.31461664735157E-01   0.00000000000000E+00  -1.16965667492289E-16
     -9.74541313700002E-23  -8.84417203404323E-09  -8.84417215100899E-09  -2.97542149374760E-18
      2.03884574530779E-08
      0.00000000000000E+00  -8.80258330344378E-12   0.00000000000000E+00   2.48807216799713E-14   1.50148391383808E-22
      8.80257402974612E-09   8.80259891046795E-09  -8.22561599407088E-19  -2.33963632763411E-01  -2.33963632763412E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10206452420859E-12   0.00000000000000E+00   1.10206452420859E-12
      3.79967821338606E-18  -2.33963633032899E-01  -2.31190003129925E-01   0.00000000000000E+00  -2.27881447308490E-14
     -9.74323901022552E-23  -8.80367818684733E-09  -8.80370097499216E-09  -2.97711661397897E-18
      2.23884574530779E-08
      0.00000000000000E+00  -8.77181531647926E-12   0.00000000000000E+00   6.49336706514156E-16   1.50376292205482E-22
      8.77186727525379E-09   8.77186792459065E-09  -8.22952680764918E-19  -2.33744999597272E-01  -2.33744999597273E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47590510363545E-13   0.00000000000000E+00   8.47590510363545E-13
      3.80137339440679E-18  -2.33745000004296E-01  -2.30981124402320E-01   0.00000000000000E+00   1.05832854732406E-15
     -9.74157593183478E-23  -8.77271657342946E-09  -8.77271551510101E-09  -2.97842071364187E-18
      2.43884574530779E-08
      0.00000000000000E+00  -8.74839490849134E-12   0.00000000000000E+00   7.95279694977149E-15   1.50552158265990E-22
      8.74831819606394E-09   8.74832614886104E-09  -8.23253391730291E-19  -2.33576827619614E-01  -2.33576827619615E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52094496946778E-13   0.00000000000000E+00   6.52094496946778E-13
      3.80267758340068E-18  -2.33576828177823E-01  -2.30820433258541E-01   0.00000000000000E+00  -6.68528122636884E-15
     -9.74029551002521E-23  -8.74897155807666E-09  -8.74897824335799E-09  -2.97942419167039E-18
      2.63884574530779E-08
      0.00000000000000E+00  -8.73020965052425E-12   0.00000000000000E+00   3.10836957749535E-17   1.50687966833118E-22
      8.73024477740671E-09   8.73024480849056E-09  -8.23484792516103E-19  -2.33447390973392E-01  -2.33447390973392E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01858011633819E-13   0.00000000000000E+00   5.01858011633819E-13
      3.80368129942395E-18  -2.33447391686146E-01  -2.30696738105560E-01   0.00000000000000E+00   9.76810440633185E-16
     -9.73931392438681E-23  -8.73074764331254E-09  -8.73074666650220E-09  -2.98019650690785E-18
      2.83884574530779E-08
      0.00000000000000E+00  -8.71634109520591E-12   0.00000000000000E+00   2.57244442503064E-15   1.50792582810437E-22
      8.71635146209015E-09   8.71635403453472E-09  -8.23662927621831E-19  -2.33347733887168E-01  -2.33347733887169E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86337718815354E-13   0.00000000000000E+00   3.86337718815354E-13
      3.80445397486158E-18  -2.33347734743348E-01  -2.30601494621587E-01   0.00000000000000E+00  -1.81294376461514E-15
     -9.73855834185340E-23  -8.71673855930968E-09  -8.71674037225354E-09  -2.98079104723975E-18
      3.03884574530779E-08
      0.00000000000000E+00  -8.70568710568984E-12   0.00000000000000E+00  -9.93421589186124E-17   1.50873237783627E-22
      8.70566753597456E-09   8.70566743663255E-09  -8.23800113030005E-19  -2.33270979620731E-01  -2.33270979620732E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97481595954603E-13   0.00000000000000E+00   2.97481595954603E-13
      3.80504893805349E-18  -2.33270980589941E-01  -2.30528134417992E-01   0.00000000000000E+00   6.94961204398846E-16
     -9.73797811533745E-23  -8.70596561318961E-09  -8.70596491822851E-09  -2.98124882502349E-18
      3.23884574530779E-08
      0.00000000000000E+00  -8.69742107934116E-12   0.00000000000000E+00   8.08943604208450E-16   1.50935347475109E-22
      8.69744439863717E-09   8.69744520758092E-09  -8.23905783097544E-19  -2.33211854067219E-01  -2.33211854067220E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29105666981422E-13   0.00000000000000E+00   2.29105666981422E-13
      3.80550714938745E-18  -2.33211855094555E-01  -2.30471621149917E-01   0.00000000000000E+00  -3.56071028751616E-16
     -9.73753141273353E-23  -8.69767395717679E-09  -8.69767431324791E-09  -2.98160136628991E-18
      3.43884574530779E-08
      0.00000000000000E+00  -8.69108379247384E-12   0.00000000000000E+00  -9.94192709757898E-17   1.50983208187510E-22
      8.69111413990187E-09   8.69111404048275E-09  -8.23987195109688E-19  -2.33166300105697E-01  -2.33166300105697E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76475473490106E-13   0.00000000000000E+00   1.76475473490106E-13
      3.80586010033443E-18  -2.33166301107479E-01  -2.30428078082615E-01   0.00000000000000E+00   4.51879219121376E-16
     -9.73718796009674E-23  -8.69129096783536E-09  -8.69129051595624E-09  -2.98187290522474E-18
      3.63884574530779E-08
      0.00000000000000E+00  -8.68621602140184E-12   0.00000000000000E+00   2.33348142589908E-16   1.51020068214666E-22
      8.68623866277403E-09   8.68623889612232E-09  -8.24049924159253E-19  -2.33131199162495E-01  -2.33131199162495E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35952907798607E-13   0.00000000000000E+00   1.35952907798607E-13
      3.80613200615003E-18  -2.33131200023237E-01  -2.30394525776080E-01   0.00000000000000E+00   3.60836017663398E-17
     -9.73692347593548E-23  -8.68637488511363E-09  -8.68637484903013E-09  -2.98208208199078E-18
      3.83884574530779E-08
      0.00000000000000E+00  -8.68245038717633E-12   0.00000000000000E+00   3.31086160766091E-16   1.51048476932279E-22
      8.68248320736323E-09   8.68248353844955E-09  -8.24098262745856E-19  -2.33104150201483E-01  -2.33104150201483E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04746750149439E-13   0.00000000000000E+00   1.04746750149439E-13
      3.80634149965033E-18  -2.33104150774308E-01  -2.30368669509152E-01   0.00000000000000E+00  -1.26588626392102E-16
     -9.73671995357788E-23  -8.68258815861097E-09  -8.68258828519970E-09  -2.98224323690447E-18
      4.03884574530779E-08
      0.00000000000000E+00  -8.67960320032290E-12   0.00000000000000E+00   5.24288066281101E-17   1.51070348704848E-22
      8.67959001770275E-09   8.67959007013170E-09  -8.24135514914113E-19  -2.33083304688007E-01  -2.33083304688008E-01
      0.00000000000000E+00   0.00000000000000E+00   8.07098881837829E-14   0.00000000000000E+00   8.07098881837829E-14
      3.80650291942670E-18  -2.33083304791503E-01  -2.30348742594201E-01   0.00000000000000E+00   1.06942442442540E-16
     -9.73656318076327E-23  -8.67967088696224E-09  -8.67967078001989E-09  -2.98236740451258E-18
      4.23884574530779E-08
      0.00000000000000E+00  -8.67739892662992E-12   0.00000000000000E+00   9.39603777944368E-17   1.51087208809236E-22
      8.67736066726169E-09   8.67736076122222E-09  -8.24164224503363E-19  -2.33067239363928E-01  -2.33067239363928E-01
      0.00000000000000E+00   0.00000000000000E+00   6.21932397405983E-14   0.00000000000000E+00   6.21932397405983E-14
      3.80662730590618E-18  -2.33067238791464E-01  -2.30333384781020E-01   0.00000000000000E+00   2.83499979989789E-17
     -9.73644247462609E-23  -8.67742298281186E-09  -8.67742295446196E-09  -2.98246308140282E-18
      4.43884574530779E-08
      0.00000000000000E+00  -8.67556203188577E-12   0.00000000000000E+00   8.67132376453847E-16   1.51100210531050E-22
      8.67564256355992E-09   8.67564343069245E-09  -8.24186350172619E-19  -2.33054858076337E-01  -2.33054858076337E-01
      0.00000000000000E+00   0.00000000000000E+00   4.79273361349731E-14   0.00000000000000E+00   4.79273361349731E-14
      3.80672316057845E-18  -2.33054856610477E-01  -2.30321548380358E-01   0.00000000000000E+00  -7.81448333120631E-16
     -9.73634948077898E-23  -8.67569057658015E-09  -8.67569135802858E-09  -2.98253681040583E-18
      4.63884574530779E-08
      0.00000000000000E+00  -8.67427620556486E-12   0.00000000000000E+00   1.93961476835264E-17   1.51110207061403E-22
      8.67431901789871E-09   8.67431903729501E-09  -8.24203404084660E-19  -2.33045314980538E-01  -2.33045314980538E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69346306096026E-14   0.00000000000000E+00   3.69346306096026E-14
      3.80679702983967E-18  -2.33045312402558E-01  -2.30312424617233E-01   0.00000000000000E+00   5.18931591094103E-17
     -9.73627783978513E-23  -8.67435602381868E-09  -8.67435597192562E-09  -2.98259362575500E-18
      4.83884574530779E-08
      0.00000000000000E+00  -8.67326591345558E-12   0.00000000000000E+00   2.95463535989505E-16   1.51117922840562E-22
      8.67329863518568E-09   8.67329893064936E-09  -8.24216547883319E-19  -2.33037959947286E-01  -2.33037959947286E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84642774174219E-14   0.00000000000000E+00   2.84642774174219E-14
      3.80685395839450E-18  -2.33037956064073E-01  -2.30305392416788E-01   0.00000000000000E+00  -2.42260664324863E-16
     -9.73622264121921E-23  -8.67332715266602E-09  -8.67332739492678E-09  -2.98263741051118E-18
      5.03884574530779E-08
      0.00000000000000E+00  -8.67253115555792E-12   0.00000000000000E+00  -1.12999413110903E-18   1.51123861527944E-22
      8.67251240738584E-09   8.67251240625600E-09  -8.24226678757566E-19  -2.33032290911618E-01  -2.33032290911618E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19370133110801E-14   0.00000000000000E+00   2.19370133110801E-14
      3.80689783242112E-18  -2.33032285589394E-01  -2.30299971698559E-01   0.00000000000000E+00   4.39802209785473E-17
     -9.73618010641338E-23  -8.67253438724943E-09  -8.67253434326931E-09  -2.98267115366356E-18
      5.23884574530779E-08
      0.00000000000000E+00  -8.67188824239747E-12   0.00000000000000E+00   9.80506654676783E-17   1.51128442648390E-22
      8.67190631155358E-09   8.67190640960440E-09  -8.24234487135726E-19  -2.33027921513639E-01  -2.33027921513639E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69069759751023E-14   0.00000000000000E+00   1.69069759751023E-14
      3.80693164637307E-18  -2.33027914712746E-01  -2.30295793355987E-01   0.00000000000000E+00  -6.56341549767336E-17
     -9.73614732746919E-23  -8.67192325094612E-09  -8.67192331658037E-09  -2.98269715923734E-18
      5.43884574530779E-08
      0.00000000000000E+00  -8.67142901871143E-12   0.00000000000000E+00  -5.13074995824672E-18   1.51131970423647E-22
      8.67143921532996E-09   8.67143921019936E-09  -8.24240505858115E-19  -2.33024553593710E-01  -2.33024553593710E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30307415087739E-14   0.00000000000000E+00   1.30307415087739E-14
      3.80695770785609E-18  -2.33024545411093E-01  -2.30292572433548E-01   0.00000000000000E+00   3.07616719177355E-17
     -9.73612206518170E-23  -8.67145227170245E-09  -8.67145224094087E-09  -2.98271720199798E-18
      5.63884574530779E-08
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   3.09473963184204E-17   1.51134690423944E-22
      8.67107911718481E-09   8.67107914813236E-09  -8.24245145291663E-19  -2.33021957522792E-01  -2.33021957522792E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00438244509304E-14   0.00000000000000E+00   1.00438244509304E-14
      3.80697779550499E-18  -2.33021948240382E-01  -2.30290089652158E-01   0.00000000000000E+00  -1.14014759660180E-17
     -9.73610259633446E-23  -8.67108918055523E-09  -8.67108919195681E-09  -2.98273265021333E-18
      5.83884574530779E-08
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00  -4.62423435204999E-18   1.51136785198686E-22
      8.67080152701939E-09   8.67080152239531E-09  -8.24248722022456E-19  -2.33019956151971E-01  -2.33019956151971E-01
      0.00000000000000E+00   0.00000000000000E+00   7.74243611792038E-15   0.00000000000000E+00   7.74243611792038E-15
      3.80699328037723E-18  -2.33019946283516E-01  -2.30288175874720E-01   0.00000000000000E+00   1.99112296704228E-17
     -9.73608759374913E-23  -8.67080928474256E-09  -8.67080926483142E-09  -2.98274455835477E-18
      6.03884574530779E-08
      0.00000000000000E+00  -8.67060241607656E-12   0.00000000000000E+00   8.74316380328820E-18   1.51138399371901E-22
      8.67058746014208E-09   8.67058746888539E-09  -8.24251479998935E-19  -2.33018412976150E-01  -2.33018412976150E-01
      0.00000000000000E+00   0.00000000000000E+00   5.96957642304888E-15   0.00000000000000E+00   5.96957642304888E-15
      3.80700521953007E-18  -2.33018403310267E-01  -2.30286700901424E-01   0.00000000000000E+00   2.96077636119834E-18
     -9.73607603632592E-23  -8.67059344142250E-09  -8.67059343846183E-09  -2.98275373953114E-18
      6.23884574530779E-08
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00  -3.30448135487958E-18   1.51139642070225E-22
      8.67042234436826E-09   8.67042234106393E-09  -8.24253607379001E-19  -2.33017222707431E-01  -2.33017222707431E-01
      0.00000000000000E+00   0.00000000000000E+00   4.60422934084021E-15   0.00000000000000E+00   4.60422934084021E-15
      3.80701442798876E-18  -2.33017214337744E-01  -2.30285564378533E-01   0.00000000000000E+00   1.23912843128855E-17
     -9.73606713775616E-23  -8.67042695768444E-09  -8.67042694529325E-09  -2.98276082060976E-18
      6.43884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.77901085843155E-18   1.51140598829800E-22
      8.67029490981797E-09   8.67029491159713E-09  -8.24255249175195E-19  -2.33016304197487E-01  -2.33016304197487E-01
      0.00000000000000E+00   0.00000000000000E+00   3.55310924789149E-15   0.00000000000000E+00   3.55310924789149E-15
      3.80702153420725E-18  -2.33016298536556E-01  -2.30284689056554E-01   0.00000000000000E+00   5.18079305711174E-18
     -9.73606029327167E-23  -8.67029846988707E-09  -8.67029846470637E-09  -2.98276628503206E-18
      6.63884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00  -2.16393652986447E-18   1.51141334822110E-22
      8.67019649466991E-09   8.67019649250613E-09  -8.24256517176251E-19  -2.33015594884587E-01  -2.33015594884587E-01
      0.00000000000000E+00   0.00000000000000E+00   2.74424253239219E-15   0.00000000000000E+00   2.74424253239219E-15
      3.80702702269232E-18  -2.33015593647837E-01  -2.30284015428215E-01   0.00000000000000E+00   7.53834734784463E-18
     -9.73605503713466E-23  -8.67019924428691E-09  -8.67019923674866E-09  -2.98277050551607E-18
      6.83884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.57170407972866E-19   1.51141900878866E-22
      8.67012041604367E-09   8.67012041588665E-09  -8.24257497468144E-19  -2.33015046583898E-01  -2.33015046583898E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12205629422667E-15   0.00000000000000E+00   2.12205629422667E-15
      3.80703126680491E-18  -2.33015051735734E-01  -2.30283497680591E-01   0.00000000000000E+00   4.25114872089234E-18
     -9.73605101087890E-23  -8.67012254219399E-09  -8.67012253794294E-09  -2.98277376933676E-18
      7.03884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.37137440230011E-18   1.51142336040916E-22
      8.67006154285245E-09   8.67006154148122E-09  -8.24258256279486E-19  -2.33014622215250E-01  -2.33014622215250E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64356716552113E-15   0.00000000000000E+00   1.64356716552113E-15
      3.80703455393924E-18  -2.33014635867283E-01  -2.30283100510806E-01   0.00000000000000E+00   4.49956644574102E-18
     -9.73604793781552E-23  -8.67006318954786E-09  -8.67006318504839E-09  -2.98277629765975E-18
      7.23884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -5.22876588634569E-19   1.51142670765670E-22
      8.67001593381736E-09   8.67001593329464E-09  -8.24258844436880E-19  -2.33014293309585E-01  -2.33014293309585E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27546030194708E-15   0.00000000000000E+00   1.27546030194708E-15
      3.80703710485984E-18  -2.33014317561514E-01  -2.30282796690072E-01   0.00000000000000E+00   2.89168019783103E-18
     -9.73604560390271E-23  -8.67001721164652E-09  -8.67001720875494E-09  -2.98277826042296E-18
      7.43884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -8.48071689262680E-19   1.51142928664732E-22
      8.66998057966677E-09   8.66998057881885E-09  -8.24259300803436E-19  -2.33014038084030E-01  -2.33014038084030E-01
      0.00000000000000E+00   0.00000000000000E+00   9.91823808657501E-16   0.00000000000000E+00   9.91823808657501E-16
      3.80703908850746E-18  -2.33014074799054E-01  -2.30282565155254E-01   0.00000000000000E+00   2.62731115520650E-18
     -9.73604384228455E-23  -8.66998157326987E-09  -8.66998157064266E-09  -2.98277978770402E-18
      7.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.70353555476483E-19   1.51143128267015E-22
      8.66995319242969E-09   8.66995319195949E-09  -8.24259654913072E-19  -2.33013839968467E-01  -2.33013839968467E-01
      0.00000000000000E+00   0.00000000000000E+00   7.72425114554221E-16   0.00000000000000E+00   7.72425114554221E-16
      3.80704063335769E-18  -2.33013890480072E-01  -2.30282389533712E-01   0.00000000000000E+00   1.79454153838484E-18
     -9.73604252163265E-23  -8.66995396617904E-09  -8.66995396438460E-09  -2.98278097844461E-18
      7.83884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -5.15769638293251E-19   1.51143284105478E-22
      8.66993204998206E-09   8.66993204946645E-09  -8.24259929007368E-19  -2.33013686466924E-01  -2.33013686466924E-01
      0.00000000000000E+00   0.00000000000000E+00   6.01389375594062E-16   0.00000000000000E+00   6.01389375594062E-16
      3.80704183613644E-18  -2.33013751220327E-01  -2.30282256988756E-01   0.00000000000000E+00   1.49903249486952E-18
     -9.73604153671460E-23  -8.66993265235476E-09  -8.66993265085582E-09  -2.98278190712907E-18
      8.03884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.26716712229751E-19   1.51143407685527E-22
      8.66991587066216E-09   8.66991587033560E-09  -8.24260139613872E-19  -2.33013568277076E-01  -2.33013568277076E-01
      0.00000000000000E+00   0.00000000000000E+00   4.66205468277668E-16   0.00000000000000E+00   4.66205468277668E-16
      3.80704276854737E-18  -2.33013646414195E-01  -2.30282157322490E-01   0.00000000000000E+00   1.05540041428675E-18
     -9.73604080131019E-23  -8.66991633759637E-09  -8.66991633654106E-09  -2.98278262893350E-18
      8.23884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.97637836669545E-19   1.51143508110280E-22
      8.66990371688894E-09   8.66990371659146E-09  -8.24260298789398E-19  -2.33013478598359E-01  -2.33013478598359E-01
      0.00000000000000E+00   0.00000000000000E+00   3.56987265744612E-16   0.00000000000000E+00   3.56987265744612E-16
      3.80704348252191E-18  -2.33013567506718E-01  -2.30282082278451E-01   0.00000000000000E+00   8.53918554996389E-19
     -9.73604024259359E-23  -8.66990407443254E-09  -8.66990407357872E-09  -2.98278318373251E-18
      8.43884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.87842220678540E-19   1.51143592574848E-22
      8.66989491557334E-09   8.66989491538565E-09  -8.24260415122022E-19  -2.33013412577025E-01  -2.33013412577025E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65947233343445E-16   0.00000000000000E+00   2.65947233343445E-16
      3.80704401441637E-18  -2.33013507434636E-01  -2.30282025007889E-01   0.00000000000000E+00   6.35470360575707E-19
     -9.73603979713141E-23  -8.66989518196825E-09  -8.66989518133288E-09  -2.98278359929435E-18
      8.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.75925368279150E-19   1.51143666662915E-22
      8.66988899247139E-09   8.66988899229562E-09  -8.24260494568576E-19  -2.33013366844861E-01  -2.33013366844862E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87038357758537E-16   0.00000000000000E+00   1.87038357758537E-16
      3.80704438849309E-18  -2.33013460207484E-01  -2.30281979671649E-01   0.00000000000000E+00   5.72484418796242E-19
     -9.73603940825985E-23  -8.66988917990636E-09  -8.66988917933397E-09  -2.98278389392451E-18
      8.83884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.14154272215723E-19   1.51143734560877E-22
      8.66988561492669E-09   8.66988561461268E-09  -8.24260541175056E-19  -2.33013339124637E-01  -2.33013339124637E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15710518011130E-16   0.00000000000000E+00   1.15710518011130E-16
      3.80704461991412E-18  -2.33013420608135E-01  -2.30281941158837E-01   0.00000000000000E+00   7.31895180389312E-19
     -9.73603902393241E-23  -8.66988573105501E-09  -8.66988573032321E-09  -2.98278407873907E-18
      8.93884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.44810722496573E-18   1.51147549578309E-22
      8.66988453705092E-09   8.66988453360296E-09  -8.24260556879810E-19  -2.33013329450397E-01  -2.33013329450397E-01
      0.00000000000000E+00   0.00000000000000E+00   8.17997686131823E-17   0.00000000000000E+00   8.17997686131823E-17
      3.80704470171389E-18  -2.33013402094485E-01  -2.30281922995428E-01   0.00000000000000E+00   3.91539195319755E-18
     -9.74044965766922E-23  -8.66988461931802E-09  -8.66988461540273E-09  -2.98278414483408E-18
      8.95572074530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.05442928957465E-19   1.51143797350850E-22
      8.66988434384342E-09   8.66988434373813E-09  -8.24260559260225E-19  -2.33013327952016E-01  -2.33013327952016E-01
      0.00000000000000E+00   0.00000000000000E+00   7.65477380975306E-17   0.00000000000000E+00   7.65477380975306E-17
      3.80704471463132E-18  -2.33013399008934E-01  -2.30281919972702E-01   0.00000000000000E+00  -3.64921599679607E-19
     -9.73604354848230E-23  -8.66988441992084E-09  -8.66988442028586E-09  -2.98278415537110E-18
      8.97850199530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.16577753151181E-20   1.51143808423122E-22
      8.66988414947107E-09   8.66988414942957E-09  -8.24260562099548E-19  -2.33013326146390E-01  -2.33013326146390E-01
      0.00000000000000E+00   0.00000000000000E+00   6.82027358581329E-17   0.00000000000000E+00   6.82027358581329E-17
      3.80704473016876E-18  -2.33013394898327E-01  -2.30281915925664E-01   0.00000000000000E+00   4.98817934043719E-19
     -9.73604186748249E-23  -8.66988421813103E-09  -8.66988421763231E-09  -2.98278416806921E-18
      9.00925668280779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.40588616074038E-20   1.51143793265755E-22
      8.66988394209742E-09   8.66988394206351E-09  -8.24260565219891E-19  -2.33013324099460E-01  -2.33013324099460E-01
      0.00000000000000E+00   0.00000000000000E+00   5.79291795363911E-17   0.00000000000000E+00   5.79291795363911E-17
      3.80704474798470E-18  -2.33013389432078E-01  -2.30281910527980E-01   0.00000000000000E+00   4.98582011091061E-19
     -9.73603866202600E-23  -8.66988400049117E-09  -8.66988399999268E-09  -2.98278418276481E-18
      9.05077551093279E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.13171933037588E-20   1.51143803982290E-22
      8.66988375998159E-09   8.66988375996042E-09  -8.24260568155732E-19  -2.33013322035406E-01  -2.33013322035406E-01
      0.00000000000000E+00   0.00000000000000E+00   4.42255802888327E-17   0.00000000000000E+00   4.42255802888327E-17
      3.80704476634664E-18  -2.33013382163227E-01  -2.30281903320813E-01   0.00000000000000E+00   4.99686642590329E-19
     -9.73603864662892E-23  -8.66988380468560E-09  -8.66988380418601E-09  -2.98278419819091E-18
      9.10682592890154E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.70197861062701E-20   1.51143820984970E-22
      8.66988368818258E-09   8.66988368814571E-09  -8.24260569838969E-19  -2.33013320497468E-01  -2.33013320497468E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59581118309643E-17   0.00000000000000E+00   2.59581118309643E-17
      3.80704478089627E-18  -2.33013372454355E-01  -2.30281893640306E-01   0.00000000000000E+00   5.44568698258444E-19
     -9.73603847748963E-23  -8.66988371464829E-09  -8.66988371410382E-09  -2.98278421105730E-18
      9.18249399315936E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.87294357890970E-16   1.51143500187980E-22
      8.66986122790082E-09   8.66986074060662E-09  -8.24260788881905E-19  -2.33013217497582E-01  -2.33013217497582E-01
      0.00000000000000E+00   0.00000000000000E+00   7.58343729742889E-16   0.00000000000000E+00   7.58343729742889E-16
      3.80704535472029E-18  -2.33013375661524E-01  -2.30281903687820E-01   0.00000000000000E+00   5.52202369452323E-16
     -9.73604005274957E-23  -8.66986205115262E-09  -8.66986149895035E-09  -2.98278456583839E-18
      9.23356993653338E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.74629130922710E-15   1.51143967007168E-22
      8.66989007904524E-09   8.66989382533670E-09  -8.24260510928663E-19  -2.33013341486320E-01  -2.33013341486320E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08143676554042E-15   0.00000000000000E+00  -1.08143676554042E-15
      3.80704480236626E-18  -2.33013364181459E-01  -2.30281883716857E-01   0.00000000000000E+00  -3.92830919755720E-15
     -9.73601237100151E-23  -8.66988881559064E-09  -8.66989274389993E-09  -2.98278429143760E-18
      9.30252246008831E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   2.18336633954696E-19   1.51144041285359E-22
      8.66989079352704E-09   8.66989079374553E-09  -8.24260501301613E-19  -2.33013347662278E-01  -2.33013347662278E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37401169698453E-16   0.00000000000000E+00  -1.37401169698453E-16
      3.80704470762469E-18  -2.33013347640431E-01  -2.30281866639225E-01   0.00000000000000E+00   3.88076797381983E-19
     -9.73603782683659E-23  -8.66989065673234E-09  -8.66989065634436E-09  -2.98278420632307E-18
      9.39560836688747E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.75208937731567E-20   1.51144025259387E-22
      8.66989151999523E-09   8.66989152003290E-09  -8.24260485938995E-19  -2.33013357308482E-01  -2.33013357308482E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29318102859794E-16   0.00000000000000E+00  -1.29318102859794E-16
      3.80704458724776E-18  -2.33013324853074E-01  -2.30281843620432E-01   0.00000000000000E+00   7.22794772541036E-19
     -9.73603754373728E-23  -8.66989139143749E-09  -8.66989139071480E-09  -2.98278410130876E-18
      9.52127434106633E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   7.39389849071433E-20   1.51144025081888E-22
      8.66989338067881E-09   8.66989338075290E-09  -8.24260456628608E-19  -2.33013374239456E-01  -2.33013374239456E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44373808050220E-16   0.00000000000000E+00  -1.44373808050220E-16
      3.80704440581900E-18  -2.33013292209698E-01  -2.30281810395545E-01   0.00000000000000E+00   8.00885269870926E-19
     -9.73603708709492E-23  -8.66989323717989E-09  -8.66989323637910E-09  -2.98278394919040E-18
      9.69092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   9.20553072671616E-19   1.51144044935316E-22
      8.66989724271747E-09   8.66989724363818E-09  -8.24260400865469E-19  -2.33013405003395E-01  -2.33013405003395E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78063488793403E-16   0.00000000000000E+00  -1.78063488793403E-16
      3.80704410373596E-18  -2.33013242551952E-01  -2.30281759531606E-01   0.00000000000000E+00   1.50213424159594E-19
     -9.73603635454002E-23  -8.66989706572479E-09  -8.66989706557467E-09  -2.98278370287049E-18
      9.89092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.53754097309566E-19   1.51145453584995E-22
      8.66990321017853E-09   8.66990321033244E-09  -8.24260316166779E-19  -2.33013451281575E-01  -2.33013451281575E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.22035384833252E-16   0.00000000000000E+00  -2.22035384833252E-16
      3.80704365966519E-18  -2.33013173648762E-01  -2.30281688762126E-01   0.00000000000000E+00   1.11029913671231E-18
     -9.73607162388294E-23  -8.66990298940726E-09  -8.66990298829706E-09  -2.98278334349841E-18
      9.94092340620780E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   1.17543847530089E-15   1.51143937742591E-22
      8.66989525258727E-09   8.66989642802589E-09  -8.24260367418199E-19  -2.33013429022377E-01  -2.33013429022377E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50290400001551E-16   0.00000000000000E+00   1.50290400001551E-16
      3.80704373481039E-18  -2.33013160272299E-01  -2.30281677780192E-01   0.00000000000000E+00  -1.24017960886487E-15
     -9.73603431992317E-23  -8.66989533813658E-09  -8.66989657831629E-09  -2.98278336739220E-18
      1.00084234062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   5.10612252816535E-19   1.51144058822248E-22
      8.66990201996037E-09   8.66990202047113E-09  -8.24260320644443E-19  -2.33013452424014E-01  -2.33013452424014E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52673498046150E-16   0.00000000000000E+00  -2.52673498046150E-16
      3.80704356425578E-18  -2.33013138082556E-01  -2.30281653580425E-01   0.00000000000000E+00   1.09962408031954E-18
     -9.73603497501241E-23  -8.66990176889715E-09  -8.66990176779763E-09  -2.98278324361134E-18
      1.00995484062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.61395316104979E-19   1.51144088447060E-22
      8.66990677947306E-09   8.66990677973461E-09  -8.24260259925987E-19  -2.33013483468834E-01  -2.33013483468834E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79325195364390E-16   0.00000000000000E+00  -2.79325195364390E-16
      3.80704330972070E-18  -2.33013104153725E-01  -2.30281618160526E-01   0.00000000000000E+00   1.33326461557536E-18
     -9.73603429532135E-23  -8.66990650174257E-09  -8.66990650040941E-09  -2.98278304979471E-18
      1.02225671562078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.29607898739447E-19   1.51144131046442E-22
      8.66991243503054E-09   8.66991243526030E-09  -8.24260182774698E-19  -2.33013524587872E-01  -2.33013524587872E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.02342494394349E-16   0.00000000000000E+00  -3.02342494394349E-16
      3.80704293778274E-18  -2.33013052118016E-01  -2.30281564350225E-01   0.00000000000000E+00   1.42239411245754E-18
     -9.73603352753248E-23  -8.66991213434010E-09  -8.66991213291781E-09  -2.98278275500804E-18
      1.03886424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   1.97002980910054E-19   1.51144154341693E-22
      8.66991897481698E-09   8.66991897501414E-09  -8.24260087153703E-19  -2.33013577526074E-01  -2.33013577526074E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.14534959514037E-16   0.00000000000000E+00  -3.14534959514037E-16
      3.80704241541782E-18  -2.33012972451620E-01  -2.30281482627225E-01   0.00000000000000E+00   1.52742554789292E-18
     -9.73603237401886E-23  -8.66991866200650E-09  -8.66991866047917E-09  -2.98278232826412E-18
      1.05886424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   1.43384460553191E-19   1.51144142676024E-22
      8.66992470734425E-09   8.66992470748778E-09  -8.24259993403024E-19  -2.33013631876563E-01  -2.33013631876563E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99153105310798E-16   0.00000000000000E+00  -2.99153105310798E-16
      3.80704181711161E-18  -2.33012867240196E-01  -2.30281375604832E-01   0.00000000000000E+00   1.58276136788193E-18
     -9.73603094695485E-23  -8.66992440991734E-09  -8.66992440833467E-09  -2.98278182370859E-18
      1.07886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   6.40538131907615E-19   1.51144087670362E-22
      8.66992712880559E-09   8.66992712944628E-09  -8.24259936860026E-19  -2.33013668140911E-01  -2.33013668140911E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45168995565891E-16   0.00000000000000E+00  -2.45168995565891E-16
      3.80704132677362E-18  -2.33012759311681E-01  -2.30281266896366E-01   0.00000000000000E+00   9.28550677880722E-19
     -9.73602962963717E-23  -8.66992688520573E-09  -8.66992688427727E-09  -2.98278138991359E-18
      1.08886424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   9.76977064419005E-21   1.51144048547216E-22
      8.66992734004255E-09   8.66992734005248E-09  -8.24259920186163E-19  -2.33013680511551E-01  -2.33013680511551E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07381996545313E-16   0.00000000000000E+00  -2.07381996545313E-16
      3.80704111939162E-18  -2.33012705646845E-01  -2.30281213153053E-01   0.00000000000000E+00   1.44179831809866E-18
     -9.73602901154788E-23  -8.66992713411218E-09  -8.66992713267048E-09  -2.98278119920546E-18
      1.10236424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -7.32001254275004E-20   1.51143971685882E-22
      8.66992529793541E-09   8.66992529786236E-09  -8.24259925524387E-19  -2.33013683113797E-01  -2.33013683113797E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33274090103441E-16   0.00000000000000E+00  -1.33274090103441E-16
      3.80704093947160E-18  -2.33012636784108E-01  -2.30281144910327E-01   0.00000000000000E+00   1.26447570070454E-18
     -9.73602831722674E-23  -8.66992516585264E-09  -8.66992516458827E-09  -2.98278101394722E-18
      1.12058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -2.25324708389636E-19   1.51143816905585E-22
      8.66991691205417E-09   8.66991691182900E-09  -8.24260002277373E-19  -2.33013650790694E-01  -2.33013650790694E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63233036294202E-17   0.00000000000000E+00   1.63233036294202E-17
      3.80704096922082E-18  -2.33012560145680E-01  -2.30281070866790E-01   0.00000000000000E+00   8.33813895937688E-19
     -9.73602779539183E-23  -8.66991692898602E-09  -8.66991692815230E-09  -2.98278096694345E-18
      1.14058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.33984843565146E-19   1.51143577906328E-22
      8.66989902307563E-09   8.66989902264180E-09  -8.24260196856151E-19  -2.33013557623683E-01  -2.33013557623683E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47924574477161E-16   0.00000000000000E+00   2.47924574477161E-16
      3.80704146506997E-18  -2.33012512084991E-01  -2.30281028369205E-01   0.00000000000000E+00   8.10532506888542E-20
     -9.73602798578258E-23  -8.66989927064732E-09  -8.66989927056637E-09  -2.98278126821382E-18
      1.16058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.89542438236906E-19   1.51143265963826E-22
      8.66987065677141E-09   8.66987065608202E-09  -8.24260527890391E-19  -2.33013392218574E-01  -2.33013392218574E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50763303022512E-16   0.00000000000000E+00   5.50763303022512E-16
      3.80704256659658E-18  -2.33012519597495E-01  -2.30281044723370E-01   0.00000000000000E+00  -9.87377791797049E-19
     -9.73602923268697E-23  -8.66987120585784E-09  -8.66987120684531E-09  -2.98278203870619E-18
      1.18058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -9.80089784306016E-19   1.51142883359863E-22
      8.66983038141685E-09   8.66983038043692E-09  -8.24261017980950E-19  -2.33013141584623E-01  -2.33013141584623E-01
      0.00000000000000E+00   0.00000000000000E+00   9.22684409869857E-16   0.00000000000000E+00   9.22684409869857E-16
      3.80704441196540E-18  -2.33012604614893E-01  -2.30281142312750E-01   0.00000000000000E+00  -2.39140649114920E-18
     -9.73603184189490E-23  -8.66983130072982E-09  -8.66983130312132E-09  -2.98278339398445E-18
      1.20058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -1.11745912399647E-18   1.51142440767464E-22
      8.66977742487899E-09   8.66977742376169E-09  -8.24261682386179E-19  -2.33012796295823E-01  -2.33012796295823E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35336922435702E-15   0.00000000000000E+00   1.35336922435702E-15
      3.80704711870385E-18  -2.33012790153390E-01  -2.30281344400075E-01   0.00000000000000E+00  -4.29702750531394E-18
     -9.73603610437021E-23  -8.66977877283378E-09  -8.66977877713090E-09  -2.98278543631767E-18
      1.22058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -1.57343235252139E-18   1.51141959596927E-22
      8.66971202860720E-09   8.66971202703392E-09  -8.24262524384450E-19  -2.33012352954553E-01  -2.33012352954553E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82205901645054E-15   0.00000000000000E+00   1.82205901645054E-15
      3.80705076282188E-18  -2.33013098340305E-01  -2.30281673043144E-01   0.00000000000000E+00  -6.16516420290747E-18
     -9.73604225943021E-23  -8.66971384292767E-09  -8.66971384909294E-09  -2.98278823843743E-18
      1.24058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00  -1.53865292003532E-18   1.51141474205785E-22
      8.66963584109706E-09   8.66963583955856E-09  -8.24263529970556E-19  -2.33011817043854E-01  -2.33011817043854E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29541235202362E-15   0.00000000000000E+00   2.29541235202362E-15
      3.80705535364658E-18  -2.33013547717307E-01  -2.30282146274762E-01   0.00000000000000E+00  -8.69892733523472E-18
     -9.73605044833946E-23  -8.66963812627190E-09  -8.66963813497092E-09  -2.98279182367603E-18
      1.26058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00  -2.05344411817607E-18   1.51141033642265E-22
      8.66955232878236E-09   8.66955232672907E-09  -8.24264662165991E-19  -2.33011206030897E-01  -2.33011206030897E-01
      0.00000000000000E+00   0.00000000000000E+00   2.72577856339875E-15   0.00000000000000E+00   2.72577856339875E-15
      3.80706080520371E-18  -2.33014149802766E-01  -2.30282774536180E-01   0.00000000000000E+00  -1.06088845766921E-17
     -9.73606065851175E-23  -8.66955504189865E-09  -8.66955505250763E-09  -2.98279614303772E-18
      1.28058924687078E-07
      0.00000000000000E+00  -8.66950027923007E-12   0.00000000000000E+00  -1.98425468294377E-18   1.51140702633344E-22
      8.66946716544131E-09   8.66946716345721E-09  -8.24265855363708E-19  -2.33010552507740E-01  -2.33010552507740E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05025159822822E-15   0.00000000000000E+00   3.05025159822822E-15
      3.80706690570691E-18  -2.33014904965237E-01  -2.30283556428195E-01   0.00000000000000E+00  -1.28156127751325E-17
     -9.73607266131149E-23  -8.66947020089309E-09  -8.66947021370880E-09  -2.98280105034320E-18
      1.30058924687078E-07
      0.00000000000000E+00  -8.66940843449286E-12   0.00000000000000E+00  -1.96276740565088E-18   1.51140561287934E-22
      8.66938855506813E-09   8.66938855310551E-09  -8.24267010321828E-19  -2.33009907052877E-01  -2.33009907052877E-01
      0.00000000000000E+00   0.00000000000000E+00   3.19090887735398E-15   0.00000000000000E+00   3.19090887735398E-15
      3.80707328752466E-18  -2.33015797752839E-01  -2.30284473938730E-01   0.00000000000000E+00  -1.42938749058676E-17
     -9.73608594583101E-23  -8.66939172972042E-09  -8.66939174401439E-09  -2.98280627720283E-18
      1.32058924687078E-07
      0.00000000000000E+00  -8.66931658975566E-12   0.00000000000000E+00  -1.46020396612620E-18   1.51140703132301E-22
      8.66932742250370E-09   8.66932742104365E-09  -8.24267990589040E-19  -2.33009340403259E-01  -2.33009340403259E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05672848802375E-15   0.00000000000000E+00   3.05672848802375E-15
      3.80707940098164E-18  -2.33016791937636E-01  -2.30285487426536E-01   0.00000000000000E+00  -1.51805611472421E-17
     -9.73609965561343E-23  -8.66933046259148E-09  -8.66933047777214E-09  -2.98281141039260E-18
      1.34058924687078E-07
      0.00000000000000E+00  -8.66922474501845E-12   0.00000000000000E+00  -5.58446088683025E-19   1.51141230882024E-22
      8.66929740016713E-09   8.66929739960883E-09  -8.24268621340921E-19  -2.33008944418088E-01  -2.33008944418088E-01
      0.00000000000000E+00   0.00000000000000E+00   2.54766848857309E-15   0.00000000000000E+00   2.54766848857309E-15
      3.80708449631862E-18  -2.33017825681141E-01  -2.30286530789600E-01   0.00000000000000E+00  -1.48730602680634E-17
     -9.73611253435689E-23  -8.66929993240416E-09  -8.66929994727731E-09  -2.98281587497769E-18
      1.36058924687078E-07
      0.00000000000000E+00  -8.66931658975566E-12   0.00000000000000E+00   2.47841268145746E-18   1.51142249533962E-22
      8.66931452642825E-09   8.66931452890682E-09  -8.24268691725901E-19  -2.33008831243621E-01  -2.33008831243621E-01
      0.00000000000000E+00   0.00000000000000E+00   1.56135941291430E-15   0.00000000000000E+00   1.56135941291430E-15
      3.80708761903744E-18  -2.33018807366369E-01  -2.30287507390122E-01   0.00000000000000E+00  -1.45916755110859E-17
     -9.73612289162936E-23  -8.66931607567446E-09  -8.66931609026623E-09  -2.98281892731154E-18
      1.38058924687078E-07
      0.00000000000000E+00  -8.66940843449286E-12   0.00000000000000E+00   3.10574827231670E-18   1.51143856316238E-22
      8.66939656902560E-09   8.66939657213150E-09  -8.24267961983525E-19  -2.33009129995745E-01  -2.33009129995745E-01
      0.00000000000000E+00   0.00000000000000E+00   2.86598856868920E-18   0.00000000000000E+00   2.86598856868920E-18
      3.80708762476942E-18  -2.33019612814182E-01  -2.30288287480934E-01   0.00000000000000E+00  -9.26687618098761E-18
     -9.73612859926797E-23  -8.66939656573051E-09  -8.66939657499748E-09  -2.98281966278589E-18
      1.40058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00   1.34560283734136E-17   1.51146127366120E-22
      8.66956188046794E-09   8.66956189392412E-09  -8.24266176467696E-19  -2.33009980324345E-01  -2.33009980324346E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.20235553712771E-15   0.00000000000000E+00  -2.20235553712771E-15
      3.80708322005834E-18  -2.33020084755068E-01  -2.30288708033824E-01   0.00000000000000E+00  -1.06014813510149E-17
     -9.73612713200067E-23  -8.66955968096700E-09  -8.66955969156858E-09  -2.98281704359065E-18
      1.42058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   9.51208791408427E-18   1.51149100848845E-22
      8.66982773858521E-09   8.66982774809744E-09  -8.24263083844120E-19  -2.33011522157647E-01  -2.33011522157647E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.09218313540552E-15   0.00000000000000E+00  -5.09218313540552E-15
      3.80707303569207E-18  -2.33020035510164E-01  -2.30288575938265E-01   0.00000000000000E+00   5.88522607426759E-18
     -9.73611566706082E-23  -8.66982266179944E-09  -8.66982265591431E-09  -2.98280995184795E-18
      1.44058924687078E-07
      0.00000000000000E+00  -8.67014319239053E-12   0.00000000000000E+00   3.23888252067792E-17   1.51152757585776E-22
      8.67020806393503E-09   8.67020809632401E-09  -8.24258465043226E-19  -2.33013881238745E-01  -2.33013881238745E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.64863889308508E-15   0.00000000000000E+00  -8.64863889308508E-15
      3.80705573841429E-18  -2.33019254025156E-01  -2.30287675748387E-01   0.00000000000000E+00  -1.18544882700441E-18
     -9.73609125474879E-23  -8.67019944649957E-09  -8.67019944768512E-09  -2.98279727337106E-18
      1.46058924687078E-07
      0.00000000000000E+00  -8.67069426081377E-12   0.00000000000000E+00   1.73233304503309E-17   1.51156998572695E-22
      8.67071062909339E-09   8.67071064641688E-09  -8.24252169656037E-19  -2.33017150050818E-01  -2.33017150050818E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27767646240200E-14   0.00000000000000E+00  -1.27767646240200E-14
      3.80703018488504E-18  -2.33017518147695E-01  -2.30285782833050E-01   0.00000000000000E+00   3.35685753057179E-17
     -9.73605107524272E-23  -8.67069790322072E-09  -8.67069786965224E-09  -2.98277801522900E-18
      1.48058924687078E-07
      0.00000000000000E+00  -8.67133717397422E-12   0.00000000000000E+00   5.01701095411213E-17   1.51161623376073E-22
      8.67133360734138E-09   8.67133365751164E-09  -8.24244159986776E-19  -2.33021364417631E-01  -2.33021364417631E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72822274539472E-14   0.00000000000000E+00  -1.72822274539472E-14
      3.80699562043013E-18  -2.33014613343529E-01  -2.30282683172177E-01   0.00000000000000E+00   2.21930892705543E-17
     -9.73599278535511E-23  -8.67131639747717E-09  -8.67131637528418E-09  -2.98275146044335E-18
      1.50058924687078E-07
      0.00000000000000E+00  -8.67207193187188E-12   0.00000000000000E+00   2.25338424840372E-17   1.51166307327825E-22
      8.67206190220180E-09   8.67206192473580E-09  -8.24234561844206E-19  -2.33026476220258E-01  -2.33026476220258E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.18511322886058E-14   0.00000000000000E+00  -2.18511322886058E-14
      3.80695191816555E-18  -2.33010358125195E-01  -2.30278199935709E-01   0.00000000000000E+00   7.43045374635568E-17
     -9.73591496285430E-23  -8.67204014790795E-09  -8.67204007360351E-09  -2.98271735632135E-18
      1.52058924687078E-07
      0.00000000000000E+00  -8.67280668976954E-12   0.00000000000000E+00   4.67262306407025E-17   1.51170586212284E-22
      8.67286306529232E-09   8.67286311201870E-09  -8.24223719135951E-19  -2.33032323635201E-01  -2.33032323635201E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60320835371759E-14   0.00000000000000E+00  -2.60320835371759E-14
      3.80689985399848E-18  -2.33004636907842E-01  -2.30272227619613E-01   0.00000000000000E+00   7.24183224838933E-17
     -9.73581763520515E-23  -8.67283715235338E-09  -8.67283707993515E-09  -2.98267613486253E-18
      1.54058924687078E-07
      0.00000000000000E+00  -8.67372513714162E-12   0.00000000000000E+00   2.11789058762990E-17   1.51173844268861E-22
      8.67368364647363E-09   8.67368366765269E-09  -8.24212248377692E-19  -2.33038600896347E-01  -2.33038600896347E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92278059050394E-14   0.00000000000000E+00  -2.92278059050394E-14
      3.80684139838667E-18  -2.32997439261235E-01  -2.30264772445547E-01   0.00000000000000E+00   1.19920896920810E-16
     -9.73570288002406E-23  -8.67365455976759E-09  -8.67365443984679E-09  -2.98262915000898E-18
      1.56058924687078E-07
      0.00000000000000E+00  -8.67445989503928E-12   0.00000000000000E+00   2.01600387713325E-17   1.51175318526311E-22
      8.67444591770034E-09   8.67444593786053E-09  -8.24201087405674E-19  -2.33044830508931E-01  -2.33044830508931E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06953295595768E-14   0.00000000000000E+00  -3.06953295595768E-14
      3.80678000772755E-18  -2.32988904792461E-01  -2.30255998275417E-01   0.00000000000000E+00   1.34428397317019E-16
     -9.73557545667662E-23  -8.67441537695927E-09  -8.67441524253097E-09  -2.98257892032187E-18
      1.58058924687078E-07
      0.00000000000000E+00  -8.67501096346252E-12   0.00000000000000E+00   1.89723056980655E-17   1.51174114946128E-22
      8.67504601385275E-09   8.67504603282521E-09  -8.24191530730112E-19  -2.33050341876366E-01  -2.33050341876366E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95645393663720E-14   0.00000000000000E+00  -2.95645393663720E-14
      3.80672087864882E-18  -2.32979370750139E-01  -2.30246274807596E-01   0.00000000000000E+00   1.41148344401833E-16
     -9.73544342474464E-23  -8.67501660943409E-09  -8.67501646828585E-09  -2.98252934791871E-18
      1.60058924687078E-07
      0.00000000000000E+00  -8.67537834241135E-12   0.00000000000000E+00   6.08469454147593E-17   1.51169249358845E-22
      8.67535392312492E-09   8.67535398397202E-09  -8.24185241977609E-19  -2.33054261390184E-01  -2.33054261390184E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48758004293883E-14   0.00000000000000E+00  -2.48758004293883E-14
      3.80667112704796E-18  -2.32969418800561E-01  -2.30236224367623E-01   0.00000000000000E+00   8.85287254842454E-17
     -9.73531866715790E-23  -8.67532919670022E-09  -8.67532910817159E-09  -2.98248588507035E-18
      1.62058924687078E-07
      0.00000000000000E+00  -8.67528649767415E-12   0.00000000000000E+00   4.27284357380636E-17   1.51159711128860E-22
      8.67521622389808E-09   8.67521626662667E-09  -8.24184234474808E-19  -2.33055518889687E-01  -2.33055518889687E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.56418798035249E-14   0.00000000000000E+00  -1.56418798035249E-14
      3.80663984328835E-18  -2.32959915633467E-01  -2.30226761671499E-01   0.00000000000000E+00   7.58776113594989E-17
     -9.73521724274524E-23  -8.67520070062438E-09  -8.67520062474687E-09  -2.98245560881354E-18
      1.64058924687078E-07
      0.00000000000000E+00  -8.67445989503928E-12   0.00000000000000E+00   4.14036848320171E-16   1.51144559818205E-22
      8.67446236001631E-09   8.67446277405331E-09  -8.24190803714240E-19  -2.33052878962783E-01  -2.33052878962782E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.42923504248005E-16   0.00000000000000E+00  -9.42923504248005E-16
      3.80663795744134E-18  -2.32952040763022E-01  -2.30219119679196E-01   0.00000000000000E+00  -3.52589243067944E-16
     -9.73515942968713E-23  -8.67446147854048E-09  -8.67446183112982E-09  -2.98244715372710E-18
      1.66058924687078E-07
      0.00000000000000E+00  -8.67289853450675E-12   0.00000000000000E+00   1.30764868661095E-16   1.51123045499832E-22
      8.67291583432621E-09   8.67291596509123E-09  -8.24207409450169E-19  -2.33044999260863E-01  -2.33044999260863E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99545374319452E-14   0.00000000000000E+00   1.99545374319452E-14
      3.80667786651621E-18  -2.32947292197025E-01  -2.30214851775429E-01   0.00000000000000E+00  -1.56019085675292E-16
     -9.73516937258286E-23  -8.67293576360949E-09  -8.67293591962867E-09  -2.98247045706604E-18
      1.68058924687078E-07
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00   1.34686363337554E-15   1.51094781655427E-22
      8.67040897648785E-09   8.67041032335164E-09  -8.24236479725951E-19  -2.33030529546473E-01  -2.33030529546473E-01
      0.00000000000000E+00   0.00000000000000E+00   4.74382104568949E-14   0.00000000000000E+00   4.74382104568949E-14
      3.80677274293712E-18  -2.32947463561038E-01  -2.30215804289463E-01   0.00000000000000E+00  -1.50415782957301E-15
     -9.73527414322914E-23  -8.67045625740417E-09  -8.67045776156210E-09  -2.98253626321117E-18
      1.70058924687078E-07
      0.00000000000000E+00  -8.66683678185106E-12   0.00000000000000E+00   2.72281746661302E-16   1.51059900943255E-22
      8.66680690678087E-09   8.66680717906277E-09  -8.24280154537885E-19  -2.33008244879733E-01  -2.33008244879733E-01
      0.00000000000000E+00   0.00000000000000E+00   8.13670829733228E-14   0.00000000000000E+00   8.13670829733228E-14
      3.80693547710307E-18  -2.32954575424468E-01  -2.30224040332814E-01   0.00000000000000E+00  -5.77021312276586E-16
     -9.73550213855864E-23  -8.66688796912433E-09  -8.66688854614574E-09  -2.98265532256518E-18
      1.72058924687078E-07
      0.00000000000000E+00  -8.66206085551626E-12   0.00000000000000E+00  -1.19131365214428E-16   1.51019303987594E-22
      8.66203099514680E-09   8.66203087601559E-09  -8.24339931002911E-19  -2.32977230841321E-01  -2.32977230841321E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20871264925240E-13   0.00000000000000E+00   1.20871264925240E-13
      3.80717721963292E-18  -2.32970762700199E-01  -2.30241719863349E-01   0.00000000000000E+00  -3.63030893019543E-16
     -9.73588064878848E-23  -8.66215138424952E-09  -8.66215174728051E-09  -2.98283728863000E-18
      1.74058924687078E-07
      0.00000000000000E+00  -8.65609094759777E-12   0.00000000000000E+00   3.22607258102682E-16   1.50974860952184E-22
      8.65609421516729E-09   8.65609453777470E-09  -8.24416245713810E-19  -2.32937105060434E-01  -2.32937105060434E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64135620620803E-13   0.00000000000000E+00   1.64135620620803E-13
      3.80750549087416E-18  -2.32998095923460E-01  -2.30270909903395E-01   0.00000000000000E+00  -1.03223395812161E-15
     -9.73643254410897E-23  -8.65625764116128E-09  -8.65625867339533E-09  -2.98308924516035E-18
      1.76058924687078E-07
      0.00000000000000E+00  -8.64911074757000E-12   0.00000000000000E+00  -1.73640939130580E-16   1.50929600253851E-22
      8.64913656438767E-09   8.64913639074688E-09  -8.24507987604187E-19  -2.32888279281827E-01  -2.32888279281828E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08189884397332E-13   0.00000000000000E+00   2.08189884397332E-13
      3.80792187064295E-18  -2.33038337616318E-01  -2.30313329804337E-01   0.00000000000000E+00  -7.51337267209643E-16
     -9.73717202848377E-23  -8.64934382929390E-09  -8.64934458063127E-09  -2.98341388303877E-18
      1.78058924687078E-07
      0.00000000000000E+00  -8.64148763438178E-12   0.00000000000000E+00   7.23573848654237E-17   1.50887919509797E-22
      8.64146120310087E-09   8.64146127545841E-09  -8.24611968340521E-19  -2.32832247115194E-01  -2.32832247115195E-01
      0.00000000000000E+00   0.00000000000000E+00   2.48759723180745E-13   0.00000000000000E+00   2.48759723180745E-13
      3.80841939008931E-18  -2.33092633375916E-01  -2.30370030995119E-01   0.00000000000000E+00  -1.24517255787244E-15
     -9.73809959647618E-23  -8.64170879000894E-09  -8.64171003518159E-09  -2.98380742174880E-18
      1.80058924687078E-07
      0.00000000000000E+00  -8.63358898698193E-12   0.00000000000000E+00  -1.96924292375472E-16   1.50855654426159E-22
      8.63357237389760E-09   8.63357217697346E-09  -8.24722391851968E-19  -2.32771877761107E-01  -2.32771877761107E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80149477166628E-13   0.00000000000000E+00   2.80149477166628E-13
      3.80897968904365E-18  -2.33161135739486E-01  -2.30441008942825E-01   0.00000000000000E+00  -1.15748914249871E-15
     -9.73919624934355E-23  -8.63385116896139E-09  -8.63385232645063E-09  -2.98425729719168E-18
      1.82058924687078E-07
      0.00000000000000E+00  -8.62624140800533E-12   0.00000000000000E+00  -1.83922737565303E-16   1.50840111171229E-22
      8.62620391430193E-09   8.62620373037934E-09  -8.24830377969759E-19  -2.32711687020565E-01  -2.32711687020566E-01
      0.00000000000000E+00   0.00000000000000E+00   2.95272829546849E-13   0.00000000000000E+00   2.95272829546849E-13
      3.80957023470274E-18  -2.33242579816433E-01  -2.30524769785082E-01   0.00000000000000E+00  -1.31364976182814E-15
     -9.74041747319913E-23  -8.62649768955903E-09  -8.62649900320889E-09  -2.98473985673298E-18
      1.84058924687078E-07
      0.00000000000000E+00  -8.62036334482405E-12   0.00000000000000E+00  -1.46553814750860E-16   1.50849883777747E-22
      8.62033866776361E-09   8.62033852120995E-09  -8.24923613430770E-19  -2.32658047287332E-01  -2.32658047287332E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85803963166518E-13   0.00000000000000E+00   2.85803963166518E-13
      3.81014184262907E-18  -2.33333829512881E-01  -2.30617870397052E-01   0.00000000000000E+00  -1.39850203410215E-15
     -9.74168730691615E-23  -8.62062292667099E-09  -8.62062432517312E-09  -2.98521822919831E-18
      1.86058924687078E-07
      0.00000000000000E+00  -8.61724062375899E-12   0.00000000000000E+00  -7.84712422271383E-17   1.50894496780069E-22
      8.61720889648023E-09   8.61720881800914E-09  -8.24986222667295E-19  -2.32619288053644E-01  -2.32619288053644E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42546997609852E-13   0.00000000000000E+00   2.42546997609852E-13
      3.81062693662430E-18  -2.33429431220203E-01  -2.30714471829404E-01   0.00000000000000E+00  -1.37211720480213E-15
     -9.74289332223359E-23  -8.61744999288945E-09  -8.61745136500675E-09  -2.98564071395700E-18
      1.88058924687078E-07
      0.00000000000000E+00  -8.61825091586827E-12   0.00000000000000E+00   2.59501897245389E-17   1.50983775073947E-22
      8.61827233099357E-09   8.61827235694391E-09  -8.24998964397104E-19  -2.32605629985760E-01  -2.32605629985760E-01
      0.00000000000000E+00   0.00000000000000E+00   1.56039013976398E-13   0.00000000000000E+00   1.56039013976398E-13
      3.81093901465225E-18  -2.33521221887555E-01  -2.30805954738249E-01   0.00000000000000E+00  -1.19109007033957E-15
     -9.74388330868292E-23  -8.61842720486772E-09  -8.61842839595789E-09  -2.98594005025514E-18
      1.90058924687078E-07
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00   1.70943344881803E-16   1.51126906397181E-22
      8.62515587897617E-09   8.62515604991966E-09  -8.24939869111672E-19  -2.32628890378521E-01  -2.32628890378521E-01
      0.00000000000000E+00   0.00000000000000E+00   1.74297725756034E-14   0.00000000000000E+00   1.74297725756034E-14
      3.81097387419740E-18  -2.33598052749923E-01  -2.30880660570627E-01   0.00000000000000E+00  -8.10397889983299E-16
     -9.74446472377671E-23  -8.62517266929426E-09  -8.62517347969224E-09  -2.98603400508573E-18
      1.92058924687078E-07
      0.00000000000000E+00  -8.63955889490042E-12   0.00000000000000E+00   3.58273738944421E-16   1.51331165515795E-22
      8.63955967581823E-09   8.63956003409212E-09  -8.24785430382112E-19  -2.32701897404514E-01  -2.32701897404514E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80344597732985E-13   0.00000000000000E+00  -1.80344597732985E-13
      3.81061318500193E-18  -2.33645702986766E-01  -2.30923835083027E-01   0.00000000000000E+00  -1.87456205006489E-16
     -9.74440805964636E-23  -8.63937950203809E-09  -8.63937968949439E-09  -2.98582775461982E-18
      1.94058924687078E-07
      0.00000000000000E+00  -8.66307114762555E-12   0.00000000000000E+00   5.86429023487150E-16   1.51600301027268E-22
      8.66311457702001E-09   8.66311516344918E-09  -8.24512446840421E-19  -2.32837557500430E-01  -2.32837557500430E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.41099064989851E-13   0.00000000000000E+00  -4.41099064989851E-13
      3.80973098687195E-18  -2.33647069525823E-01  -2.30917862582701E-01   0.00000000000000E+00   7.11891229340774E-16
     -9.74345533877077E-23  -8.66267477627533E-09  -8.66267406438420E-09  -2.98521854003153E-18
      1.96058924687078E-07
      0.00000000000000E+00  -8.69723738986675E-12   0.00000000000000E+00   8.48196611380542E-16   1.51932632745753E-22
      8.69718732382550E-09   8.69718817202226E-09  -8.24100577797116E-19  -2.33047536315482E-01  -2.33047536315481E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.63684431378227E-13   0.00000000000000E+00  -7.63684431378227E-13
      3.80820361800920E-18  -2.33582728776127E-01  -2.30842888504692E-01   0.00000000000000E+00   1.90754042661290E-15
     -9.74133492268401E-23  -8.69642639513122E-09  -8.69642448759089E-09  -2.98410304021208E-18
      1.98058924687078E-07
      0.00000000000000E+00  -8.74260869004726E-12   0.00000000000000E+00   1.13213243433576E-15   1.52318970719474E-22
      8.74262962733074E-09   8.74263075946333E-09  -8.23535622226033E-19  -2.33340539981047E-01  -2.33340539981045E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14009297751806E-12   0.00000000000000E+00  -1.14009297751806E-12
      3.80592343205416E-18  -2.33431971618745E-01  -2.30677932859337E-01   0.00000000000000E+00   3.39413007977450E-15
     -9.73778368478799E-23  -8.74149406061579E-09  -8.74149066648581E-09  -2.98238780982813E-18
      2.00058924687078E-07
      0.00000000000000E+00  -8.79946058237872E-12   0.00000000000000E+00   1.41539043967482E-15   1.52740540939682E-22
      8.79947080896105E-09   8.79947222435164E-09  -8.22813459706196E-19  -2.33720219753210E-01  -2.33720219753209E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55350054186265E-12   0.00000000000000E+00  -1.55350054186265E-12
      3.80281643097044E-18  -2.33174411922791E-01  -2.30402594968388E-01   0.00000000000000E+00   5.13810241293875E-15
     -9.73257734773116E-23  -8.79792386191210E-09  -8.79791872380978E-09  -2.98000297126424E-18
      2.02058924687078E-07
      0.00000000000000E+00  -8.86650724054022E-12   0.00000000000000E+00   1.67213354352597E-15   1.53167176833142E-22
      8.86655918553884E-09   8.86656085767253E-09  -8.21944507900609E-19  -2.34182767258999E-01  -2.34182767258997E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.97640375474320E-12   0.00000000000000E+00  -1.97640375474320E-12
      3.79886362346095E-18  -2.32792257126341E-01  -2.29999436444980E-01   0.00000000000000E+00   7.05932609099023E-15
     -9.72556939644198E-23  -8.86459151324377E-09  -8.86458445391778E-09  -2.97691911556034E-18
      2.04058924687078E-07
      0.00000000000000E+00  -8.94117701188994E-12   0.00000000000000E+00   1.85925952406656E-15   1.53556091015872E-22
      8.94116624553297E-09   8.94116810479265E-09  -8.20958462662689E-19  -2.34714315877810E-01  -2.34714315877808E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36905383681445E-12   0.00000000000000E+00  -2.36905383681445E-12
      3.79412551578732E-18  -2.32273300810915E-01  -2.29457097984146E-01   0.00000000000000E+00   9.03658902897684E-15
     -9.71673841870111E-23  -8.93880808754477E-09  -8.93879905095584E-09  -2.97316705312464E-18
      2.06058924687078E-07
      0.00000000000000E+00  -9.01860212535588E-12   0.00000000000000E+00   1.93047760956069E-15   1.53851556656143E-22
      9.01858108338779E-09   9.01858301386555E-09  -8.19909002861999E-19  -2.35288311762422E-01  -2.35288311762420E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67842895297666E-12   0.00000000000000E+00  -2.67842895297666E-12
      3.78876865788137E-18  -2.31614643136090E-01  -2.28774147253233E-01   0.00000000000000E+00   1.08874146897176E-14
     -9.70624292440402E-23  -9.01591547232717E-09  -9.01590458491258E-09  -2.96885965501937E-18
      2.08058924687078E-07
      0.00000000000000E+00  -9.09180238091028E-12   0.00000000000000E+00   1.82519424498907E-15   1.53985779231910E-22
      9.09174179311246E-09   9.09174361830686E-09  -8.18878068124612E-19  -2.35863062501794E-01  -2.35863062501791E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83803155935527E-12   0.00000000000000E+00  -2.83803155935527E-12
      3.78309259476266E-18  -2.30827054655307E-01  -2.27963558779653E-01   0.00000000000000E+00   1.23766175425499E-14
     -9.69448154882742E-23  -9.08891796336495E-09  -9.08890558674750E-09  -2.96421452663805E-18
      2.10058924687078E-07
      0.00000000000000E+00  -9.15095039167193E-12   0.00000000000000E+00   1.47909180774949E-15   1.53881115693588E-22
      9.15097586012737E-09   9.15097733921934E-09  -8.17979249669592E-19  -2.36379713483305E-01  -2.36379713483302E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.76885346903869E-12   0.00000000000000E+00  -2.76885346903869E-12
      3.77755488782458E-18  -2.29939761190311E-01  -2.27057580924702E-01   0.00000000000000E+00   1.32086476067540E-14
     -9.68215489296009E-23  -9.14822169439780E-09  -9.14820848575029E-09  -2.95957563815499E-18
      2.12058924687078E-07
      0.00000000000000E+00  -9.18392265232943E-12   0.00000000000000E+00   8.26459334398824E-16   1.53453606952587E-22
      9.18395172572279E-09   9.18395255218228E-09  -8.17359754319784E-19  -2.36760949565654E-01  -2.36760949565652E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38193881441790E-12   0.00000000000000E+00  -2.38193881441790E-12
      3.77279101019574E-18  -2.29005233650387E-01  -2.26112541773108E-01   0.00000000000000E+00   1.30340379954127E-14
     -9.67032295437972E-23  -9.18158364740576E-09  -9.18157061336787E-09  -2.95543125587596E-18
      2.14058924687078E-07
      0.00000000000000E+00  -9.17602400492958E-12   0.00000000000000E+00  -1.94844066430019E-16   1.52617571690389E-22
      9.17597381821434E-09   9.17597362337042E-09  -8.17200277482692E-19  -2.36910788321299E-01  -2.36910788321298E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58310478057986E-12   0.00000000000000E+00  -1.58310478057986E-12
      3.76962480063458E-18  -2.28103318065303E-01  -2.25212887701915E-01   0.00000000000000E+00   1.14608865686044E-14
     -9.66044906713925E-23  -9.17440197947632E-09  -9.17439051858984E-09  -2.95242452315189E-18
      2.16058924687078E-07
      0.00000000000000E+00  -9.11072239677503E-12   0.00000000000000E+00  -1.75716533853607E-15   1.51290851188709E-22
      9.11077338969733E-09   9.11077163253215E-09  -8.17711916189600E-19  -2.36715940619857E-01  -2.36715940619857E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80544455740463E-13   0.00000000000000E+00  -2.80544455740463E-13
      3.76906371172310E-18  -2.27343758349290E-01  -2.24473459376465E-01   0.00000000000000E+00   8.19200188880544E-15
     -9.65441762818643E-23  -9.11049928007820E-09  -9.11049108807641E-09  -2.95135179553350E-18
      2.18058924687078E-07
      0.00000000000000E+00  -8.97194499885446E-12   0.00000000000000E+00  -3.47720039123874E-15   1.49400357049729E-22
      8.97194022788468E-09   8.97193675068444E-09  -8.19128940139692E-19  -2.36049382284466E-01  -2.36049382284467E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60382448023202E-12   0.00000000000000E+00   1.60382448023202E-12
      3.77227136068357E-18  -2.26865901381826E-01  -2.24038749324195E-01   0.00000000000000E+00   2.39496779749880E-15
     -9.65450897532691E-23  -8.97354297013237E-09  -8.97354057516467E-09  -2.95314242054387E-18
      2.20058924687078E-07
      0.00000000000000E+00  -8.74508849795187E-12   0.00000000000000E+00  -5.64653685366385E-15   1.46888018287825E-22
      8.74508037798031E-09   8.74507473144361E-09  -8.21695851528257E-19  -2.34776996087938E-01  -2.34776996087943E-01
      0.00000000000000E+00   0.00000000000000E+00   4.11845532208021E-12   0.00000000000000E+00   4.11845532208021E-12
      3.78050827132773E-18  -2.26834233099213E-01  -2.24077763211503E-01   0.00000000000000E+00  -6.02717929816975E-15
     -9.66331138428852E-23  -8.74918715958630E-09  -8.74919318676569E-09  -2.95881241979947E-18
      2.22058924687078E-07
      0.00000000000000E+00  -8.42060104139768E-12   0.00000000000000E+00  -8.21444855501518E-15   1.43718390543202E-22
      8.42064468870142E-09   8.42063647425301E-09  -8.25646744652186E-19  -2.32768381298456E-01  -2.32768381298463E-01
      0.00000000000000E+00   0.00000000000000E+00   7.26136467432384E-12   0.00000000000000E+00   7.26136467432384E-12
      3.79503100067638E-18  -2.27428529517498E-01  -2.24773286243264E-01   0.00000000000000E+00  -1.73912614066948E-14
     -9.68354817657397E-23  -8.42788044766583E-09  -8.42789783892733E-09  -2.96938425602419E-18
      2.24058924687078E-07
      0.00000000000000E+00  -7.99710495813377E-12   0.00000000000000E+00  -1.05572017803866E-14   1.39890901763147E-22
      7.99713830833260E-09   7.99712775113096E-09  -8.31174727953085E-19  -2.29913075780302E-01  -2.29913075780313E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09552573813608E-11   0.00000000000000E+00   1.09552573813608E-11
      3.81694151543910E-18  -2.28827995806928E-01  -2.26305018873340E-01   0.00000000000000E+00  -3.23762301847081E-14
     -9.71779972154752E-23  -8.00805063228204E-09  -8.00808300851232E-09  -2.98576678748601E-18
      2.26058924687078E-07
      0.00000000000000E+00  -7.48406025609253E-12   0.00000000000000E+00  -1.30768020244260E-14   1.35461590411327E-22
      7.48411965322979E-09   7.48410657642790E-09  -8.38389244064849E-19  -2.26143365823975E-01  -2.26143365823990E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50213827795255E-11   0.00000000000000E+00   1.50213827795255E-11
      3.84698428099815E-18  -2.31189929898741E-01  -2.28827303784852E-01   0.00000000000000E+00  -5.03154769487225E-14
     -9.76810936230307E-23  -7.49907764373037E-09  -7.49912795920742E-09  -3.00859503693330E-18
      2.28058924687078E-07
      0.00000000000000E+00  -6.90415258536420E-12   0.00000000000000E+00  -1.44881554977581E-14   1.30579654206187E-22
      6.90413042155834E-09   6.90411593340297E-09  -8.47259829612753E-19  -2.21464338553248E-01  -2.21464338553267E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91574841147621E-11   0.00000000000000E+00   1.91574841147621E-11
      3.88529924922767E-18  -2.34625103392665E-01  -2.32443905690733E-01   0.00000000000000E+00  -7.17142939218914E-14
     -9.83548506659231E-23  -6.92320170322372E-09  -6.92327341751774E-09  -3.03803941961492E-18
      2.30058924687077E-07
      0.00000000000000E+00  -6.29265032503649E-12   0.00000000000000E+00  -1.52965224952971E-14   1.25540778754377E-22
      6.29266576337167E-09   6.29265046684930E-09  -8.57546748488413E-19  -2.15990532783152E-01  -2.15990532783175E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29273027240984E-11   0.00000000000000E+00   2.29273027240984E-11
      3.93115385467587E-18  -2.39173732663424E-01  -2.37183995181796E-01   0.00000000000000E+00  -9.45760808099959E-14
     -9.91934872948755E-23  -6.31548319349248E-09  -6.31557776957339E-09  -3.07360710618745E-18
      2.32058924687077E-07
      0.00000000000000E+00  -5.69565953318756E-12   0.00000000000000E+00  -1.49609749638284E-14   1.20850923503648E-22
      5.69570852952863E-09   5.69569356855379E-09  -8.68723145008726E-19  -2.09985984945125E-01  -2.09985984945150E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57697738068065E-11   0.00000000000000E+00   2.57697738068065E-11
      3.98269340228948E-18  -2.44786743897600E-01  -2.42984187800211E-01   0.00000000000000E+00  -1.16973296478858E-13
     -1.00170333927979E-22  -5.72134636906402E-09  -5.72146334236060E-09  -3.11397025728075E-18
      2.34058924687077E-07
      0.00000000000000E+00  -5.16534802055130E-12   0.00000000000000E+00  -1.33223836755681E-14   1.17282126494656E-22
      5.16533942414070E-09   5.16532610175715E-09  -8.79902177450617E-19  -2.03899994220621E-01  -2.03899994220648E-01
      0.00000000000000E+00   0.00000000000000E+00   2.70340398160681E-11   0.00000000000000E+00   2.70340398160681E-11
      4.03676148192162E-18  -2.51315921636020E-01  -2.49680064683475E-01   0.00000000000000E+00  -1.35460542622977E-13
     -1.01234596394932E-22  -5.19222468103049E-09  -5.19236014157321E-09  -3.15685930447100E-18
      2.36058924687077E-07
      0.00000000000000E+00  -4.75526126891970E-12   0.00000000000000E+00  -1.03312846904948E-14   1.15890437819994E-22
      4.75523268872479E-09   4.75522235744021E-09  -8.89798410613848E-19  -1.98384188061206E-01  -1.98384188061232E-01
      0.00000000000000E+00   0.00000000000000E+00   2.60429501287421E-11   0.00000000000000E+00   2.60429501287421E-11
      4.08884738217910E-18  -2.58512919484531E-01  -2.57006582454472E-01   0.00000000000000E+00  -1.45487154750889E-13
     -1.02311140196331E-22  -4.78111982041410E-09  -4.78126530756896E-09  -3.19904897156525E-18
      2.38058924687077E-07
      0.00000000000000E+00  -4.51876107061032E-12   0.00000000000000E+00  -5.98553666855954E-15   1.17957172081020E-22
      4.51877205767689E-09   4.51876607214034E-09  -8.96774088897059E-19  -1.94268715151484E-01  -1.94268715151506E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21859216567877E-11   0.00000000000000E+00   2.21859216567877E-11
      4.13321922549268E-18  -2.66031794949221E-01  -2.64601172390875E-01   0.00000000000000E+00  -1.42139380710295E-13
     -1.03304223130484E-22  -4.54080985441631E-09  -4.54095199379712E-09  -3.23644513659562E-18
      2.40058924687077E-07
      0.00000000000000E+00  -4.51205640479417E-12   0.00000000000000E+00  -2.12598237913406E-16   1.24797568435198E-22
      4.51210602613720E-09   4.51210581353909E-09  -8.99033821990448E-19  -1.92472209550668E-01  -1.92472209550683E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50404079685263E-11   0.00000000000000E+00   1.50404079685263E-11
      4.16330004142973E-18  -2.73425361323856E-01  -2.71999091401839E-01   0.00000000000000E+00  -1.21614158034109E-13
     -1.04106055452077E-22  -4.52702460734948E-09  -4.52714622150761E-09  -3.26426621943928E-18
      2.42058924687077E-07
      0.00000000000000E+00  -4.80201024015833E-12   0.00000000000000E+00   7.24108116115107E-15   1.37354070750392E-22
      4.80201304838758E-09   4.80202028946888E-09  -8.95003507469833E-19  -1.93832615822090E-01  -1.93832615822094E-01
      0.00000000000000E+00   0.00000000000000E+00   4.51635845616847E-12   0.00000000000000E+00   4.51635845616847E-12
      4.17233275834207E-18  -2.80126115089702E-01  -2.78611825806577E-01   0.00000000000000E+00  -8.30442910764620E-14
     -1.04610449648215E-22  -4.80645360363388E-09  -4.80653664792506E-09  -3.27732925087224E-18
      2.44058924687077E-07
      0.00000000000000E+00  -5.47367080335697E-12   0.00000000000000E+00   1.68097978974849E-14   1.55520983381540E-22
      5.47363903925290E-09   5.47365584905095E-09  -8.83829576527839E-19  -1.98883077240696E-01  -1.98883077240687E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.99398209918913E-12   0.00000000000000E+00  -8.99398209918913E-12
      4.15434479414369E-18  -2.85412190912883E-01  -2.83690561180282E-01   0.00000000000000E+00  -2.96431758913302E-14
     -1.04728794342488E-22  -5.46463222377577E-09  -5.46466186695176E-09  -3.27051521761585E-18
      2.46058924687077E-07
      0.00000000000000E+00  -6.62714885794630E-12   0.00000000000000E+00   2.88338307892345E-14   1.77415492538586E-22
      6.62709992552093E-09   6.62712875935190E-09  -8.65782790159108E-19  -2.07650922269659E-01  -2.07650922269635E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44969762766437E-11   0.00000000000000E+00  -2.44969762766437E-11
      4.10535084159040E-18  -2.88380082629738E-01  -2.86299935866589E-01   0.00000000000000E+00   3.21286912929756E-14
     -1.04400422033920E-22  -6.60266391176644E-09  -6.60263178307525E-09  -3.23956805143130E-18
      2.48058924687077E-07
      0.00000000000000E+00  -8.35208486744086E-12   0.00000000000000E+00   4.30307752594815E-14   1.99313763853693E-22
      8.35202578288285E-09   8.35206881365831E-09  -8.42265682453374E-19  -2.19597067870516E-01  -2.19597067870475E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04108564126041E-11   0.00000000000000E+00  -4.04108564126041E-11
      4.02452912876519E-18  -2.87967032347956E-01  -2.85348453784250E-01   0.00000000000000E+00   9.56207403334985E-14
     -1.03587212327278E-22  -8.31175357798594E-09  -8.31165795724571E-09  -3.18226344631182E-18
      2.50058924687077E-07
      0.00000000000000E+00  -1.06882476030515E-11   0.00000000000000E+00   5.81664522149470E-14   2.16916153199759E-22
      1.06882584421941E-08   1.06883166086465E-08  -8.15291570865246E-19  -2.33781535664903E-01  -2.33781535664848E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49208022346122E-11   0.00000000000000E+00  -5.49208022346122E-11
      3.91468752429597E-18  -2.83049882256597E-01  -2.79699830025656E-01   0.00000000000000E+00   1.57140879111765E-13
     -1.02250058221103E-22  -1.06335529472909E-08  -1.06333958064119E-08  -3.09939595343072E-18
      2.52058924687077E-07
      0.00000000000000E+00  -1.36055119909742E-11   0.00000000000000E+00   7.25414841410254E-14   2.27264349310754E-22
      1.36054103615746E-08   1.36054829030590E-08  -7.86729544874157E-19  -2.49192974807086E-01  -2.49192974807019E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67090078651287E-11   0.00000000000000E+00  -6.67090078651287E-11
      3.78126950856571E-18  -2.72582877069336E-01  -2.68317463267572E-01   0.00000000000000E+00   2.15527753162940E-13
     -1.00322005639919E-22  -1.35389894229470E-08  -1.35387738951939E-08  -2.99453996369155E-18
      2.54058924687077E-07
      0.00000000000000E+00  -1.70165336861245E-11   0.00000000000000E+00   8.47140179013656E-14   2.29554955992956E-22
      1.70164102887099E-08   1.70164950027280E-08  -7.57819851242297E-19  -2.65041287245229E-01  -2.65041287245153E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.56021113579115E-11   0.00000000000000E+00  -7.56021113579115E-11
      3.63006528584989E-18  -2.55707236922952E-01  -2.50369945589147E-01   0.00000000000000E+00   2.67753258139150E-13
     -9.77042215371890E-23  -1.69411606446282E-08  -1.69408928913701E-08  -2.87224543460759E-18
      2.56058924687077E-07
      0.00000000000000E+00  -2.07905257827190E-11   0.00000000000000E+00   9.36830177733001E-14   2.23976512127147E-22
      2.07904532234855E-08   2.07905469065035E-08  -7.29147115907251E-19  -2.80870097061297E-01  -2.80870097061215E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.26458533021488E-11   0.00000000000000E+00  -8.26458533021488E-11
      3.46477357924559E-18  -2.31833420797402E-01  -2.25309271515143E-01   0.00000000000000E+00   3.04927858434171E-13
     -9.43162793518954E-23  -2.07082059810597E-08  -2.07079010532014E-08  -2.73562646333834E-18
      2.58058924687077E-07
      0.00000000000000E+00  -2.47257972378499E-11   0.00000000000000E+00   9.76764223180451E-14   2.09244545427363E-22
      2.47256558249142E-08   2.47257535013367E-08  -7.00906330817412E-19  -2.96492037935581E-01  -2.96492037935491E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94816836401899E-11   0.00000000000000E+00  -8.94816836401899E-11
      3.28581021196521E-18  -2.00774448239166E-01  -1.93012582090129E-01   0.00000000000000E+00   3.15248840028240E-13
     -9.02475896777666E-23  -2.46365870665365E-08  -2.46362718176965E-08  -2.58490388114780E-18
      2.60058924687077E-07
      0.00000000000000E+00  -2.85337718872112E-11   0.00000000000000E+00   9.45498630223762E-14   1.82228453840148E-22
      2.85336614051420E-08   2.85337559550052E-08  -6.73174253419156E-19  -3.11839549586363E-01  -3.11839549586266E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68178133732005E-11   0.00000000000000E+00  -9.68178133732005E-11
      3.09217458521881E-18  -1.62906173616064E-01  -1.53946809318511E-01   0.00000000000000E+00   2.97720604714328E-13
     -8.59882248497398E-23  -2.84372358622367E-08  -2.84369381416320E-08  -2.41900033179965E-18
      2.62058924687077E-07
      0.00000000000000E+00  -3.18022505502154E-11   0.00000000000000E+00   8.12240935159273E-14   1.42707831105110E-22
      3.18021602339954E-08   3.18022414580890E-08  -6.45954236474666E-19  -3.26888318228713E-01  -3.26888318228610E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03626927399583E-10   0.00000000000000E+00  -1.03626927399583E-10
      2.88492073041964E-18  -1.19400517164120E-01  -1.09413459492691E-01   0.00000000000000E+00   2.70413183122393E-13
     -8.12560395113985E-23  -3.16988849438725E-08  -3.16986145306894E-08  -2.23896649394498E-18
      2.64058924687077E-07
      0.00000000000000E+00  -3.28897840834897E-11   0.00000000000000E+00   2.72751109450109E-14   9.09622155243948E-23
      3.28897395726418E-08   3.28897668477528E-08  -6.19113135280734E-19  -3.41634149615530E-01  -3.41634149615422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08260025162488E-10   0.00000000000000E+00  -1.08260025162488E-10
      2.66840068009467E-18  -7.46154986757548E-02  -6.42872027875536E-02   0.00000000000000E+00   2.59186496736694E-13
     -6.64703173341631E-23  -3.27817660090870E-08  -3.27815068225903E-08  -2.04928754481393E-18
      2.66058924687077E-07
      0.00000000000000E+00  -2.79472513954039E-11   0.00000000000000E+00  -1.21854571924651E-13   4.39924411650454E-23
      2.79473161917902E-08   2.79471943372184E-08  -5.90401070366509E-19  -3.56105224295551E-01  -3.56105224295453E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.78372082390891E-11   0.00000000000000E+00  -9.78372082390891E-11
      2.47272626361649E-18  -4.03260573036039E-02  -3.15516738849823E-02   0.00000000000000E+00   3.04489870771824E-13
     -3.68548009312442E-23  -2.78496616188500E-08  -2.78493571289793E-08  -1.88232519324998E-18
      2.68058924687077E-07
      0.00000000000000E+00  -2.01616648670591E-11   0.00000000000000E+00  -1.91956217306375E-13   2.01597347309545E-23
      2.01618515293346E-08   2.01616595731173E-08  -5.58209146651761E-19  -3.70326350868337E-01  -3.70326350868262E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.48840359870170E-11   0.00000000000000E+00  -7.48840359870170E-11
      2.32295819164245E-18  -2.18595096591318E-02  -1.55308374582503E-02   0.00000000000000E+00   2.90026552453369E-13
     -1.80562189317250E-23  -2.00870655636828E-08  -2.00867755371303E-08  -1.76474904499069E-18
      2.70058924687077E-07
      0.00000000000000E+00  -1.50732827362877E-11   0.00000000000000E+00  -1.25226251696956E-13   1.07621453519265E-23
      1.50734387086915E-08   1.50733134824398E-08  -5.24484392249614E-19  -3.84280400161358E-01  -3.84280400161298E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98645716610739E-11   0.00000000000000E+00  -5.98645716610739E-11
      2.20322904832031E-18  -1.36540552639578E-02  -8.92381259255324E-03   0.00000000000000E+00   1.83629543833068E-13
     -1.06389027154984E-23  -1.50136325403225E-08  -1.50134489107787E-08  -1.67874465607069E-18
      2.72058924687077E-07
      0.00000000000000E+00  -1.27355586401445E-11   0.00000000000000E+00  -5.73089330751727E-14   7.04896248631377E-24
      1.27356624286333E-08   1.27356051197003E-08  -4.90716176827639E-19  -3.97942460883641E-01  -3.97942460883587E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37640652181553E-11   0.00000000000000E+00  -5.37640652181553E-11
      2.09570091788400E-18  -1.01542428276617E-02  -6.15860908345419E-03   0.00000000000000E+00   9.93945894827751E-14
     -7.53165370552598E-24  -1.26819404490716E-08  -1.26818410544821E-08  -1.60498474105636E-18
      2.74058924687077E-07
      0.00000000000000E+00  -1.18028753338021E-11   0.00000000000000E+00  -2.26947526823032E-14   5.34164425442455E-24
      1.18029021596403E-08   1.18028794648876E-08  -4.57529875226921E-19  -4.11280965106542E-01  -4.11280965106490E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.18590121483019E-11   0.00000000000000E+00  -5.18590121483019E-11
      1.99198289358739E-18  -8.53356419918018E-03  -4.83119872717639E-03   0.00000000000000E+00   5.71414290096081E-14
     -5.97115523263002E-24  -1.17510775941683E-08  -1.17510204527393E-08  -1.53445301836047E-18
      2.76058924687077E-07
      0.00000000000000E+00  -1.14362311428696E-11   0.00000000000000E+00  -8.75899632562752E-15   4.38809480331571E-24
      1.14362831407078E-08   1.14362743817115E-08  -4.25311142562417E-19  -4.24234170513108E-01  -4.24234170513056E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.13247217788081E-11   0.00000000000000E+00  -5.13247217788081E-11
      1.88933345002978E-18  -7.65399926031252E-03  -4.06696844852462E-03   0.00000000000000E+00   3.85511201805754E-14
     -5.02741278725335E-24  -1.13849882110529E-08  -1.13849496599327E-08  -1.46402230746736E-18
      2.78058924687077E-07
      0.00000000000000E+00  -1.12766049896029E-11   0.00000000000000E+00  -3.68255866398703E-15   3.77332326463848E-24
      1.12766407975390E-08   1.12766371149803E-08  -3.94487098058161E-19  -4.36683307135788E-01  -4.36683307135737E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.07965611357260E-11   0.00000000000000E+00  -5.07965611357260E-11
      1.78774032775832E-18  -7.09830484833631E-03  -3.56140215343553E-03   0.00000000000000E+00   2.98372058178268E-14
     -4.37458169290601E-24  -1.12258703910504E-08  -1.12258405538446E-08  -1.39325322970016E-18
      2.80058924687077E-07
      0.00000000000000E+00  -1.11923833655836E-11   0.00000000000000E+00  -1.85511305563996E-15   3.34498849965232E-24
      1.11923846611837E-08   1.11923828060706E-08  -3.65609771104295E-19  -4.48434949023554E-01  -4.48434949023505E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.94774168017830E-11   0.00000000000000E+00  -4.94774168017830E-11
      1.68878549415476E-18  -6.71243777877821E-03  -3.20166354784716E-03   0.00000000000000E+00   2.46955139615258E-14
     -3.89286600943423E-24  -1.11429300847828E-08  -1.11429053892688E-08  -1.32317572305046E-18
      2.82058924687077E-07
      0.00000000000000E+00  -1.11377357469451E-11   0.00000000000000E+00  -1.14271330443346E-15   3.03632284187795E-24
      1.11377309019453E-08   1.11377297592320E-08  -3.39384671114174E-19  -4.59208434834928E-01  -4.59208434834882E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.67281412013337E-11   0.00000000000000E+00  -4.67281412013337E-11
      1.59532921175209E-18  -6.43320827529504E-03  -2.93878580227514E-03   0.00000000000000E+00   2.06900106092614E-14
     -3.53155696462154E-24  -1.10910223080413E-08  -1.10910016180307E-08  -1.25594454063792E-18
      2.84058924687077E-07
      0.00000000000000E+00  -1.10957627020413E-11   0.00000000000000E+00  -8.72133820516576E-16   2.81291497995077E-24
      1.10957746927265E-08   1.10957738205926E-08  -3.16697244460803E-19  -4.68622825212271E-01  -4.68622825212229E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.19189162113360E-11   0.00000000000000E+00  -4.19189162113360E-11
      1.51149137932942E-18  -6.23022522686727E-03  -2.74750530251028E-03   0.00000000000000E+00   1.69489412570745E-14
     -3.26490851169639E-24  -1.10538718533226E-08  -1.10538549043813E-08  -1.19479413486862E-18
      2.86058924687077E-07
      0.00000000000000E+00  -1.10589329624211E-11   0.00000000000000E+00  -7.82280363877973E-16   2.65558571865161E-24
      1.10589673103225E-08   1.10589665280421E-08  -2.98635857095539E-19  -4.76188331093258E-01  -4.76188331093223E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.44185028252821E-11   0.00000000000000E+00  -3.44185028252821E-11
      1.44265437367885E-18  -6.08708685779475E-03  -2.61359969196764E-03   0.00000000000000E+00   1.30322464422317E-14
     -3.07885874057776E-24  -1.10245610574633E-08  -1.10245480252169E-08  -1.14401851658332E-18
      2.88058924687077E-07
      0.00000000000000E+00  -1.10229298254357E-11   0.00000000000000E+00  -8.06534922304814E-16   2.55405097292657E-24
      1.10229147803527E-08   1.10229139738178E-08  -2.86483583015557E-19  -4.81316504034364E-01  -4.81316504034341E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.37015767498635E-11   0.00000000000000E+00  -2.37015767498635E-11
      1.39525122017913E-18  -5.99509949071004E-03  -2.52959418817999E-03   0.00000000000000E+00   8.70081489808428E-15
     -2.96718011073073E-24  -1.09992210978828E-08  -1.09992123970679E-08  -1.10876763716357E-18
      2.90058924687077E-07
      0.00000000000000E+00  -1.09843550358086E-11   0.00000000000000E+00  -9.18020245915659E-16   2.50445271850767E-24
      1.09843819714078E-08   1.09843810533875E-08  -2.81686282946541E-19  -4.83348678621051E-01  -4.83348678621041E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48670037417731E-12   0.00000000000000E+00  -9.48670037417731E-12
      1.37627781943077E-18  -5.95138902141531E-03  -2.49354533437032E-03   0.00000000000000E+00   3.74981432290396E-15
     -2.93131805929571E-24  -1.09748981028277E-08  -1.09748943530133E-08  -1.09459153648423E-18
      2.92058924687077E-07
      0.00000000000000E+00  -1.09401777172118E-11   0.00000000000000E+00  -1.11714108339655E-15   2.50903814524239E-24
      1.09402088274239E-08   1.09402077102829E-08  -2.85841345740463E-19  -4.81584593315655E-01  -4.81584593315663E-01
      0.00000000000000E+00   0.00000000000000E+00   8.19373132155159E-12   0.00000000000000E+00   8.19373132155159E-12
      1.39266528207388E-18  -5.95933830420523E-03  -2.50984188803814E-03   0.00000000000000E+00  -2.05403205646270E-15
     -2.98338171631143E-24  -1.09483993875724E-08  -1.09484014416044E-08  -1.10682393633341E-18
      2.94058924687077E-07
      0.00000000000000E+00  -1.08858974775221E-11   0.00000000000000E+00  -1.44123629658848E-15   2.57785927765294E-24
      1.08859637486653E-08   1.08859623074290E-08  -3.00731907291705E-19  -4.75298726752572E-01  -4.75298726752601E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89721450597676E-11   0.00000000000000E+00   2.89721450597676E-11
      1.45060957219341E-18  -6.03162118057343E-03  -2.59266986350953E-03   0.00000000000000E+00  -9.05037373094279E-15
     -3.15463649652889E-24  -1.09149254021150E-08  -1.09149344524887E-08  -1.14987766490170E-18
      2.96058924687077E-07
      0.00000000000000E+00  -1.08133401351282E-11   0.00000000000000E+00  -2.68852455572013E-14   2.73324194154027E-24
      1.08133094661852E-08   1.08132825809397E-08  -3.28392858569996E-19  -4.63744600678723E-01  -4.63744600678775E-01
      0.00000000000000E+00   0.00000000000000E+00   5.21024603489869E-11   0.00000000000000E+00   5.21024603489869E-11
      1.55481449289139E-18  -6.19839417263303E-03  -2.77504784096095E-03   0.00000000000000E+00   7.09302245057986E-15
     -3.51784896380964E-24  -1.08653921343111E-08  -1.08653850412887E-08  -1.22642163432139E-18
      2.98058924687077E-07
      0.00000000000000E+00  -1.07033101399535E-11   0.00000000000000E+00  -3.13050416518908E-15   3.01821948472664E-24
      1.07032566318249E-08   1.07032535013208E-08  -3.71140847948075E-19  -4.46156735161863E-01  -4.46156735161939E-01
      0.00000000000000E+00   0.00000000000000E+00   7.63581366035423E-11   0.00000000000000E+00   7.63581366035423E-11
      1.70753076609847E-18  -6.52870710629645E-03  -3.13239535166008E-03   0.00000000000000E+00  -2.91526125127672E-14
     -4.25132955612881E-24  -1.07795824853118E-08  -1.07796116379243E-08  -1.33638991815040E-18
      3.00058924687077E-07
      0.00000000000000E+00  -1.05060276444318E-11   0.00000000000000E+00  -1.12689832104537E-14   3.50472216102189E-24
      1.05060530061180E-08   1.05060417371348E-08  -4.31388317427963E-19  -4.21762006363175E-01  -4.21762006363275E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00003649770635E-10   0.00000000000000E+00   1.00003649770635E-10
      1.90753806563974E-18  -7.19084019734699E-03  -3.84921541329845E-03   0.00000000000000E+00  -3.89958856862309E-14
     -5.84579428542799E-24  -1.06060063910198E-08  -1.06060453869055E-08  -1.47614974821178E-18
      3.02058924687077E-07
      0.00000000000000E+00  -1.00766534979866E-11   0.00000000000000E+00  -1.72289160891077E-14   4.24553715940222E-24
      1.00766688531822E-08   1.00766516242661E-08  -5.10814560009194E-19  -3.89810467135100E-01  -3.89810467135221E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21460877698182E-10   0.00000000000000E+00   1.21460877698182E-10
      2.15045982103611E-18  -8.63619569692761E-03  -5.42310291549585E-03   0.00000000000000E+00  -6.09813760121950E-14
     -9.82278126985458E-24  -1.01980515205883E-08  -1.01981125019643E-08  -1.63964526102691E-18
      3.04058924687077E-07
      0.00000000000000E+00  -8.99481433841913E-12   0.00000000000000E+00  -2.77898717127485E-14   4.78094288568067E-24
      8.99481819255426E-09   8.99479040268256E-09  -6.08288304542044E-19  -3.49651289066000E-01  -3.49651289066142E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42222413302948E-10   0.00000000000000E+00   1.42222413302948E-10
      2.43490464764200E-18  -1.21254814515153E-02  -9.24671612311087E-03   0.00000000000000E+00  -9.70817287690463E-14
     -2.07885398243661E-23  -9.13691573425672E-09  -9.13701281598551E-09  -1.82661634309996E-18
      3.06058924687077E-07
      0.00000000000000E+00  -6.49397398899539E-12   0.00000000000000E+00  -6.32713829920334E-14   1.81485567636156E-24
      6.49397676810466E-09   6.49391349672167E-09  -7.18098367724781E-19  -3.00951743070750E-01  -3.00951743070920E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70010756078984E-10   0.00000000000000E+00   1.70010756078984E-10
      2.77492615979997E-18  -2.03767499078939E-02  -1.82771805784064E-02   0.00000000000000E+00  -1.40620235354844E-13
     -4.58212665661581E-23  -6.66378363256526E-09  -6.66392425280066E-09  -2.05682779207519E-18
      3.08058924687077E-07
      0.00000000000000E+00  -3.07128801221969E-12   0.00000000000000E+00  -8.65967612871256E-14  -1.13060274116556E-23
      3.07136080568910E-09   3.07127420892780E-09  -8.35332350615627E-19  -2.44232477184463E-01  -2.44232477184666E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02283416486811E-10   0.00000000000000E+00   2.02283416486811E-10
      3.17949299277359E-18  -3.50867546781119E-02  -3.40553776629115E-02   0.00000000000000E+00  -2.34995714183402E-13
     -7.36436700146599E-23  -3.27332262970036E-09  -3.27355762541462E-09  -2.34416064215797E-18
      3.10058924687077E-07
      0.00000000000000E+00  -9.11926395733533E-13   0.00000000000000E+00  -5.62018905724915E-14  -2.94387091339762E-23
      9.11998219271749E-10   9.11942017381147E-10  -9.60673030493399E-19  -1.81521347191780E-01  -1.81521347191998E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18691388158853E-10   0.00000000000000E+00   2.18691388158853E-10
      3.61687576909130E-18  -5.36890091296231E-02  -5.33327910564170E-02   0.00000000000000E+00  -4.13612023436254E-13
     -8.62102438783518E-23  -1.13021979351648E-09  -1.13063340554000E-09  -2.65620273859790E-18
      3.12058924687077E-07
      0.00000000000000E+00  -1.56503432201626E-13   0.00000000000000E+00  -2.20152743448822E-14  -4.09811343703510E-23
      1.56460788269758E-10   1.56438772995372E-10  -1.09259593405663E-18  -1.16364157121322E-01  -1.16364157121535E-01
      0.00000000000000E+00   0.00000000000000E+00   2.13236150539579E-10   0.00000000000000E+00   2.13236150539579E-10
      4.04334807017045E-18  -7.34060864245642E-02  -7.32896172184327E-02   0.00000000000000E+00  -6.34077229753175E-13
     -9.27781109443421E-23  -3.69040846305104E-10  -3.69674923534950E-10  -2.95075213611383E-18
      3.14058924687077E-07
      0.00000000000000E+00   9.46000793237526E-15   0.00000000000000E+00  -7.98499887546889E-15  -4.48863737829994E-23
     -9.40904361306698E-12  -9.41702861198733E-12  -1.20757928709981E-18  -6.01897737839962E-02  -6.01897737841747E-02
      0.00000000000000E+00   0.00000000000000E+00   1.78526039042040E-10   0.00000000000000E+00   1.78526039042040E-10
      4.40040014825454E-18  -9.31208321286371E-02  -9.30675529006522E-02   0.00000000000000E+00  -7.57491432183790E-13
     -9.92741065247780E-23  -1.68351518997770E-10  -1.69109010430053E-10  -3.19282086115472E-18
      3.16058924687077E-07
      0.00000000000000E+00   1.25827289974312E-14   0.00000000000000E+00  -2.25022657223147E-15  -4.57527059770148E-23
     -1.26065208765171E-11  -1.26087711031350E-11  -1.27392556963205E-18  -2.86526246018695E-02  -2.86526246019874E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17838587566034E-10   0.00000000000000E+00   1.17838587566034E-10
      4.63607732338660E-18  -1.12565165405443E-01  -1.12532012004057E-01   0.00000000000000E+00  -5.86287937268754E-13
     -1.03553819171317E-22  -1.04643528525528E-10  -1.05229816462900E-10  -3.36215175375455E-18
      3.18058924687077E-07
      0.00000000000000E+00  -5.23515002082902E-15   0.00000000000000E+00  -1.45304875459585E-16  -4.56537560339975E-23
      5.22365856126699E-12   5.22351325634588E-12  -1.30353479628731E-18  -1.54782194713696E-02  -1.54782194714425E-02
      0.00000000000000E+00   0.00000000000000E+00   7.28643803628081E-11   0.00000000000000E+00   7.28643803628081E-11
      4.78180608411222E-18  -1.31670945932938E-01  -1.31646343990471E-01   0.00000000000000E+00  -3.88199601007489E-13
     -1.06067324231754E-22  -7.76996940180393E-11  -7.80878936191529E-11  -3.47827128782491E-18
      3.20058924687077E-07
      0.00000000000000E+00  -1.91037053391656E-14   0.00000000000000E+00   3.97342529850303E-16  -4.48393503633571E-23
      1.91285600499024E-11   1.91289573923874E-11  -1.31533349607948E-18  -1.04733303843033E-02  -1.04733303843520E-02
      0.00000000000000E+00   0.00000000000000E+00   4.87399190406914E-11   0.00000000000000E+00   4.87399190406914E-11
      4.87928592219360E-18  -1.50410203441134E-01  -1.50388821206492E-01   0.00000000000000E+00  -3.00258031549553E-13
     -1.07888262662702E-22  -6.75686184014218E-11  -6.78688764330792E-11  -3.56395242611412E-18
      3.22058924687077E-07
      0.00000000000000E+00  -2.89310922203709E-14   0.00000000000000E+00   4.38535668101528E-16  -4.30764990643699E-23
      2.88921739835061E-11   2.88926125191311E-11  -1.31946218762600E-18  -8.47373392430384E-03  -8.47373392433995E-03
      0.00000000000000E+00   0.00000000000000E+00   3.61182715681999E-11   0.00000000000000E+00   3.61182715681999E-11
      4.95152246533000E-18  -1.68774941727852E-01  -1.68754460032380E-01   0.00000000000000E+00  -2.78144101699163E-13
     -1.09504730624330E-22  -6.47327399855223E-11  -6.50108840873310E-11  -3.63206027770400E-18
      3.24058924687077E-07
      0.00000000000000E+00  -3.60949817225580E-14   0.00000000000000E+00   2.39781984410510E-15  -3.99792210375513E-23
      3.61585508455594E-11   3.61609486653635E-11  -1.32031841355801E-18  -7.52511645288190E-03  -7.52511645291085E-03
      0.00000000000000E+00   0.00000000000000E+00   2.89502060478416E-11   0.00000000000000E+00   2.89502060478416E-11
      5.00942287742569E-18  -1.86766892494094E-01  -1.86746379957913E-01   0.00000000000000E+00  -2.81296383273668E-13
     -1.11073056465717E-22  -6.48298583298205E-11  -6.51111547132052E-11  -3.68910446386767E-18
      3.26058924687077E-07
      0.00000000000000E+00  -4.19730449038397E-14   0.00000000000000E+00   2.87660741629586E-16  -3.51297247981471E-23
      4.19695485827212E-11   4.19698362434277E-11  -1.31974593947553E-18  -6.96914391325515E-03  -6.96914391327962E-03
      0.00000000000000E+00   0.00000000000000E+00   2.44656496806485E-11   0.00000000000000E+00   2.44656496806485E-11
      5.05835417678698E-18  -2.04391904666547E-01  -2.04370974369966E-01   0.00000000000000E+00  -2.85635800323629E-13
     -1.12631226931572E-22  -6.61498501236394E-11  -6.64354859240756E-11  -3.73860823731145E-18
      3.28058924687077E-07
      0.00000000000000E+00  -4.69326607130462E-14   0.00000000000000E+00   2.31853263300585E-16  -2.81453202641942E-23
      4.69125680376961E-11   4.69127998909312E-11  -1.31854607077503E-18  -6.58847522422832E-03  -6.58847522424977E-03
      0.00000000000000E+00   0.00000000000000E+00   2.14515812509991E-11   0.00000000000000E+00   2.14515812509991E-11
      5.10125733928898E-18  -2.21657288977536E-01  -2.21635751102254E-01   0.00000000000000E+00  -2.91656229105846E-13
     -1.14181124972951E-22  -6.80727249127104E-11  -6.83643811419304E-11  -3.78271126851396E-18
      3.30058924687077E-07
      0.00000000000000E+00  -5.13412080990075E-14   0.00000000000000E+00   1.94971236066918E-16  -1.87928477041848E-23
      5.13326136610201E-11   5.13328086322374E-11  -1.31708584882075E-18  -6.30492970292263E-03  -6.30492970294196E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93302632153219E-11   0.00000000000000E+00   1.93302632153219E-11
      5.13991786571963E-18  -2.38570592752189E-01  -2.38548330805897E-01   0.00000000000000E+00  -2.96189877640775E-13
     -1.15719279033633E-22  -7.03668819698029E-11  -7.06630718475594E-11  -3.82283201689887E-18
      3.32058924687077E-07
      0.00000000000000E+00  -5.54742212733462E-14   0.00000000000000E+00   1.71568301704337E-16  -7.11214864521819E-24
      5.54341603325628E-11   5.54343319008574E-11  -1.31553862869998E-18  -6.08450751610147E-03  -6.08450751611926E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77868199158290E-11   0.00000000000000E+00   1.77868199158290E-11
      5.17549150555128E-18  -2.55139112670019E-01  -2.55116044944857E-01   0.00000000000000E+00  -2.99398228521701E-13
     -1.17242261438475E-22  -7.29217535880478E-11  -7.32211518166868E-11  -3.85995287685130E-18
      3.34058924687077E-07
      0.00000000000000E+00  -5.93317002360623E-14   0.00000000000000E+00   1.56618008852930E-16   6.40236242176996E-24
      5.93379144745090E-11   5.93380710925242E-11  -1.31398544557102E-18  -5.90885075781252E-03  -5.90885075782915E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66291725771373E-11   0.00000000000000E+00   1.66291725771373E-11
      5.20874985070556E-18  -2.71369958143120E-01  -2.71346025418605E-01   0.00000000000000E+00  -3.01734050598366E-13
     -1.18748551409143E-22  -7.56655096189440E-11  -7.59672436696611E-11  -3.89476440513454E-18
      3.36058924687077E-07
      0.00000000000000E+00  -6.30973344615709E-14   0.00000000000000E+00   1.47026237540090E-16   2.04900780387311E-23
      6.31168419117296E-11   6.31169889379876E-11  -1.31246177279487E-18  -5.76641066140383E-03  -5.76641066141957E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57323591227461E-11   0.00000000000000E+00   1.57323591227461E-11
      5.24021456895105E-18  -2.87270429064515E-01  -2.87245588501847E-01   0.00000000000000E+00  -3.03654372178986E-13
     -1.20238332555448E-22  -7.85456936884349E-11  -7.88493480607341E-11  -3.92775279615619E-18
      3.38058924687077E-07
      0.00000000000000E+00  -6.68629686870795E-14   0.00000000000000E+00   1.40731302804040E-16   3.43359991136577E-23
      6.68175736620420E-11   6.68177143933791E-11  -1.31098061311650E-18  -5.64938932686831E-03  -5.64938932688332E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50118808941635E-11   0.00000000000000E+00   1.50118808941635E-11
      5.27023833073938E-18  -3.02847521186234E-01  -3.02821741876641E-01   0.00000000000000E+00  -3.05527172218190E-13
     -1.21713120055017E-22  -8.15240681152024E-11  -8.18295952875424E-11  -3.95925771762287E-18
      3.40058924687077E-07
      0.00000000000000E+00  -7.04449134381730E-14   0.00000000000000E+00   1.36539515409956E-16   4.73276262988434E-23
      7.04707685390221E-11   7.04709050785849E-11  -1.30954427495071E-18  -5.55250962187070E-03  -5.55250962188511E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44074420477242E-11   0.00000000000000E+00   1.44074420477242E-11
      5.29905321483482E-18  -3.18104978283469E-01  -3.18078238655293E-01   0.00000000000000E+00  -3.07558915910901E-13
     -1.23175098866421E-22  -8.45707882102752E-11  -8.48783471263093E-11  -3.98950893988412E-18
      3.42058924687077E-07
      0.00000000000000E+00  -7.41187029264741E-14   0.00000000000000E+00   1.33647395685607E-16   5.90259262971585E-23
      7.40954474231905E-11   7.40955810706453E-11  -1.30815072727867E-18  -5.47221383095335E-03  -5.47221383096723E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38747609389574E-11   0.00000000000000E+00   1.38747609389574E-11
      5.32680273671274E-18  -3.33040558796543E-01  -3.33012845236547E-01   0.00000000000000E+00  -3.09801634617600E-13
     -1.24626227828929E-22  -8.76605403748601E-11  -8.79703420096023E-11  -4.01865200943407E-18
      3.44058924687077E-07
      0.00000000000000E+00  -7.77006476775676E-14   0.00000000000000E+00   1.31447655304418E-16   6.92084280223525E-23
      7.77041842909181E-11   7.77043157386426E-11  -1.30679615861175E-18  -5.40606617029966E-03  -5.40606617031305E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33900371138720E-11   0.00000000000000E+00   1.33900371138720E-11
      5.35358281094048E-18  -3.47655981379242E-01  -3.47627283811239E-01   0.00000000000000E+00  -3.12496566410617E-13
     -1.26069323162562E-22  -9.07818562859784E-11  -9.10943528525150E-11  -4.04678665232874E-18
      3.46058924687077E-07
      0.00000000000000E+00  -8.12825924286612E-14   0.00000000000000E+00   1.30293500345448E-16   7.78546047961570E-23
      8.13106396666475E-11   8.13107699602257E-11  -1.30547472181892E-18  -5.35249298712660E-03  -5.35249298713956E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29541293483221E-11   0.00000000000000E+00   1.29541293483221E-11
      5.37949106963713E-18  -3.61977457534401E-01  -3.61947761308291E-01   0.00000000000000E+00  -3.16413974524591E-13
     -1.27510405114087E-22  -9.39484853338952E-11  -9.42648993085473E-11  -4.07401634781820E-18
      3.48058924687077E-07
      0.00000000000000E+00  -8.49563819169622E-14   0.00000000000000E+00   1.29914278131399E-16   8.50922775874793E-23
      8.49343630027403E-11   8.49344929171035E-11  -1.30417752033794E-18  -5.31071434210635E-03  -5.31071434211894E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25853989348700E-11   0.00000000000000E+00   1.25853989348700E-11
      5.40466186750686E-18  -3.76070957707846E-01  -3.76040236230699E-01   0.00000000000000E+00  -3.22803763480892E-13
     -1.28960593590189E-22  -9.71970880883645E-11  -9.75198918519744E-11  -4.10048434716893E-18
      3.50058924687077E-07
      0.00000000000000E+00  -8.85383266680558E-14   0.00000000000000E+00   1.29807110301609E-16   9.11101330144125E-23
      8.85788847668959E-11   8.85790145740973E-11  -1.30289980142829E-18  -5.28068715438527E-03  -5.28068715439750E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22250337760354E-11   0.00000000000000E+00   1.22250337760354E-11
      5.42911193505894E-18  -3.89935850623855E-01  -3.89904094721193E-01   0.00000000000000E+00  -3.29775957531696E-13
     -1.30421814968208E-22  -1.00474272392470E-10  -1.00804048350132E-10  -4.12621213363064E-18
      3.52058924687077E-07
      0.00000000000000E+00  -9.22121161563569E-14   0.00000000000000E+00   1.29697197724300E-16   9.61139357895694E-23
      9.22398542642185E-11   9.22399839615123E-11  -1.30163846044798E-18  -5.26316983851333E-03  -5.26316983852518E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18447180170844E-11   0.00000000000000E+00   1.18447180170844E-11
      5.45280137109311E-18  -4.03544274430025E-01  -4.03511485219595E-01   0.00000000000000E+00  -3.36523284607816E-13
     -1.31892177172023E-22  -1.03748178693857E-10  -1.04084701978597E-10  -4.15116291064513E-18
      3.54058924687077E-07
      0.00000000000000E+00  -9.58859056446579E-14   0.00000000000000E+00   1.29832488235866E-16   1.00303924295940E-22
      9.59191489925853E-11   9.59192788251739E-11  -1.30038826286861E-18  -5.25991200197305E-03  -5.25991200198450E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14516670766244E-11   0.00000000000000E+00   1.14516670766244E-11
      5.47570470524636E-18  -4.16885632292646E-01  -4.16851808027612E-01   0.00000000000000E+00  -3.43535525054049E-13
     -1.33371763627945E-22  -1.07027410376611E-10  -1.07370945901798E-10  -4.17531644237775E-18
      3.56058924687077E-07
      0.00000000000000E+00  -9.96515398701665E-14   0.00000000000000E+00   1.30516177950301E-16   1.03858582889093E-22
      9.96252413372673E-11   9.96253718535491E-11  -1.29914061992778E-18  -5.27414224469332E-03  -5.27414224470437E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10497493882077E-11   0.00000000000000E+00   1.10497493882077E-11
      5.49780420402277E-18  -4.29959711302220E-01  -4.29924846348376E-01   0.00000000000000E+00  -3.51013177704653E-13
     -1.34861218103080E-22  -1.10324108063917E-10  -1.10675121241757E-10  -4.19866358409499E-18
      3.58058924687077E-07
      0.00000000000000E+00  -1.03417174095675E-13   0.00000000000000E+00   1.32239935473192E-16   1.06931527475601E-22
      1.03377239978841E-10   1.03377372218883E-10  -1.29788107496266E-18  -5.31175022870383E-03  -5.31175022871446E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06369784780620E-11   0.00000000000000E+00   1.06369784780620E-11
      5.51907816097890E-18  -4.42770031451123E-01  -4.42734114781050E-01   0.00000000000000E+00  -3.58872620665443E-13
     -1.36360474076906E-22  -1.13655478076143E-10  -1.14014350696944E-10  -4.22119708601623E-18
      3.60058924687077E-07
      0.00000000000000E+00  -1.07182808321184E-13   0.00000000000000E+00   1.36020829768540E-16   1.09659705378171E-22
      1.07216154420393E-10   1.07216290441332E-10  -1.29658321855521E-18  -5.38402364391655E-03  -5.38402364392675E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02049659704244E-11   0.00000000000000E+00   1.02049659704244E-11
      5.53948809291974E-18  -4.55321227573800E-01  -4.55284237884550E-01   0.00000000000000E+00  -3.66819644402707E-13
     -1.37867904872242E-22  -1.17054436767217E-10  -1.17421256411757E-10  -4.24290487436453E-18
      3.62058924687077E-07
      0.00000000000000E+00  -1.11223976758315E-13   0.00000000000000E+00   1.44186622738897E-16   1.12185379219160E-22
      1.11233199797295E-10   1.11233343984030E-10  -1.29519386607525E-18  -5.51431143066654E-03  -5.51431143067627E-03
      0.00000000000000E+00   0.00000000000000E+00   9.73263776088733E-12   0.00000000000000E+00   9.73263776088733E-12
      5.55895336844152E-18  -4.67618122393063E-01  -4.67580016286832E-01   0.00000000000000E+00  -3.74242437424784E-13
     -1.39379164407199E-22  -1.20591739307354E-10  -1.20965981744918E-10  -4.26375950236627E-18
      3.64058924687077E-07
      0.00000000000000E+00  -1.15632524144276E-13   0.00000000000000E+00   1.63869901900757E-16   1.14710761802404E-22
      1.15648492282829E-10   1.15648656152845E-10  -1.29359314371881E-18  -5.75607237729355E-03  -5.75607237730271E-03
      0.00000000000000E+00   0.00000000000000E+00   9.16542959798852E-12   0.00000000000000E+00   9.16542959798852E-12
      5.57728422763750E-18  -4.79665271176259E-01  -4.79625953104566E-01   0.00000000000000E+00  -3.79755335855393E-13
     -1.40884405855244E-22  -1.24434330414837E-10  -1.24814085750833E-10  -4.28369108391869E-18
      3.66058924687077E-07
      0.00000000000000E+00  -1.21051363639520E-13   0.00000000000000E+00   2.09377709109702E-16   1.17664246256921E-22
      1.21067231448503E-10   1.21067440826329E-10  -1.29146992449240E-18  -6.24946822987627E-03  -6.24946822988462E-03
      0.00000000000000E+00   0.00000000000000E+00   8.34419456047322E-12   0.00000000000000E+00   8.34419456047322E-12
      5.59397261675844E-18  -4.91466331188427E-01  -4.91425565090438E-01   0.00000000000000E+00  -3.79551006524054E-13
     -1.42359638921678E-22  -1.29032084380136E-10  -1.29411635386803E-10  -4.30250269226604E-18
      3.68058924687077E-07
      0.00000000000000E+00  -1.29501079462613E-13   0.00000000000000E+00   3.63509722027081E-16   1.22312330182988E-22
      1.29463472357395E-10   1.29463835867239E-10  -1.28787202942049E-18  -7.42588394094284E-03  -7.42588394094957E-03
      0.00000000000000E+00   0.00000000000000E+00   6.73227078666101E-12   0.00000000000000E+00   6.73227078666101E-12
      5.60743715833176E-18  -5.03022117612289E-01  -5.02979214628813E-01   0.00000000000000E+00  -3.61160519153317E-13
     -1.43735337089245E-22  -1.35834946134603E-10  -1.36196106653900E-10  -4.31956512891127E-18
      3.70058924687077E-07
      0.00000000000000E+00  -1.48329250590156E-13   0.00000000000000E+00   7.91322514130798E-16   1.33119548494486E-22
      1.48332646146961E-10   1.48333437469608E-10  -1.27952671641013E-18  -1.07636517744991E-02  -1.07636517745015E-02
      0.00000000000000E+00   0.00000000000000E+00   2.38391321035737E-12   0.00000000000000E+00   2.38391321035737E-12
      5.61220498475248E-18  -5.14322657718076E-01  -5.14275180763428E-01   0.00000000000000E+00  -2.79304216744637E-13
     -1.44780217933602E-22  -1.50438046463077E-10  -1.50717350679966E-10  -4.33267826834236E-18
      3.72058924687077E-07
      0.00000000000000E+00  -2.02150266593766E-13   0.00000000000000E+00   2.15010444827720E-15   1.61593792262700E-22
      2.02171253666519E-10   2.02173403771129E-10  -1.25796101130649E-18  -1.99675256909358E-02  -1.99675256909267E-02
      0.00000000000000E+00   0.00000000000000E+00  -9.08923634386639E-12   0.00000000000000E+00  -9.08923634386639E-12
      5.59402651206475E-18  -5.25319135965640E-01  -5.25258313615741E-01   0.00000000000000E+00  -3.96785629684916E-14
     -1.44925264478532E-22  -1.93044488864149E-10  -1.93084167427263E-10  -4.33606550075826E-18
      3.74058924687077E-07
      0.00000000000000E+00  -3.25681438137890E-13   0.00000000000000E+00   4.37507042387679E-15   2.08150770706246E-22
      3.25701650258442E-10   3.25706025329074E-10  -1.21897002448882E-18  -3.63221534614194E-02  -3.63221534613950E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.44230061558020E-11   0.00000000000000E+00  -2.44230061558020E-11
      5.54518049975314E-18  -5.35889974971749E-01  -5.35795069528695E-01   0.00000000000000E+00   2.44284323441108E-13
     -1.44007098140436E-22  -3.01527303496568E-10  -3.01283019173271E-10  -4.32621047526432E-18
      3.76058924687077E-07
      0.00000000000000E+00  -5.43996378480181E-13   0.00000000000000E+00   6.78209355191826E-15   2.49866194305374E-22
      5.43958288252404E-10   5.43965070346206E-10  -1.17084888402366E-18  -5.57444389351472E-02  -5.57444389351133E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.39646288166402E-11   0.00000000000000E+00  -3.39646288166402E-11
      5.47725124211986E-18  -5.45848701815698E-01  -5.45688048520219E-01   0.00000000000000E+00   3.41219371910925E-13
     -1.42699423204433E-22  -5.10341660901335E-10  -5.10000441529566E-10  -4.30640235809620E-18
      3.78058924687077E-07
      0.00000000000000E+00  -8.95118808824556E-13   0.00000000000000E+00   9.93641577600798E-15   2.78226208073340E-22
      8.95112064419616E-10   8.95122000835670E-10  -1.12079061289607E-18  -7.56703463375499E-02  -7.56703463375106E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.92741649442408E-11   0.00000000000000E+00  -3.92741649442408E-11
      5.39870291223138E-18  -5.54941497516841E-01  -5.54671898343962E-01   0.00000000000000E+00   3.32242310858490E-13
     -1.41395695501217E-22  -8.56180078202146E-10  -8.55847835891429E-10  -4.27791229933531E-18
      3.80058924687077E-07
      0.00000000000000E+00  -1.43369634780949E-12   0.00000000000000E+00   1.44295966700741E-14   2.98463870836216E-22
      1.43371786935823E-09   1.43373229895520E-09  -1.07225783176140E-18  -9.54128745332284E-02  -9.54128745331848E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.35827669309969E-11   0.00000000000000E+00  -4.35827669309969E-11
      5.31153737836939E-18  -5.62819966046405E-01  -5.62382054791488E-01   0.00000000000000E+00   3.03097942307188E-13
     -1.40175927335969E-22  -1.39045262996637E-09  -1.39014953202420E-09  -4.23927954660798E-18
      3.82058924687077E-07
      0.00000000000000E+00  -2.22365293253143E-12   0.00000000000000E+00   2.05182003668617E-14   3.15230646799422E-22
      2.22367548780738E-09   2.22369600600807E-09  -1.02676335874082E-18  -1.14843259037311E-01  -1.14843259037263E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.83217034416218E-11   0.00000000000000E+00  -4.83217034416218E-11
      5.21489397148614E-18  -5.69021346893009E-01  -5.68336078201703E-01   0.00000000000000E+00   2.77452395697155E-13
     -1.39028099026286E-22  -2.17565175496200E-09  -2.17537430256644E-09  -4.18813061274532E-18
      3.84058924687077E-07
      0.00000000000000E+00  -3.32569793428454E-12   0.00000000000000E+00   2.81143138689309E-14   3.29865888495955E-22
      3.32563217004708E-09   3.32566028436128E-09  -9.84826437923878E-19  -1.33915710434972E-01  -1.33915710434918E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38737444591679E-11   0.00000000000000E+00  -5.38737444591679E-11
      5.10714648256781E-18  -5.72974973024088E-01  -5.71944316409425E-01   0.00000000000000E+00   2.61015025036163E-13
     -1.37915549679234E-22  -3.27204755492702E-09  -3.27178653990212E-09  -4.12232004464393E-18
      3.86058924687077E-07
      0.00000000000000E+00  -4.78722323746792E-12   0.00000000000000E+00   3.68937476787221E-14   3.42161177606155E-22
      4.78717473281090E-09   4.78721162655892E-09  -9.46310789207214E-19  -1.52613188825108E-01  -1.52613188825048E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01336109147054E-11   0.00000000000000E+00  -6.01336109147054E-11
      4.98687926073839E-18  -5.74028648802019E-01  -5.72539548587017E-01   0.00000000000000E+00   2.60861245975370E-13
     -1.36770385683244E-22  -4.72733887689005E-09  -4.72707801564422E-09  -4.04056847153118E-18
      3.88058924687077E-07
      0.00000000000000E+00  -6.64009896589256E-12   0.00000000000000E+00   4.64674573466893E-14   3.51506612776810E-22
      6.64001075895372E-09   6.64005722641141E-09  -9.10727769486807E-19  -1.70933317055197E-01  -1.70933317055130E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66817346151794E-11   0.00000000000000E+00  -6.66817346151794E-11
      4.85351579150804E-18  -5.71480230545931E-01  -5.69409508025967E-01   0.00000000000000E+00   2.86007284609871E-13
     -1.35483121789698E-22  -6.57366149908070E-09  -6.57337549179623E-09  -3.94278802202123E-18
      3.90058924687077E-07
      0.00000000000000E+00  -8.90526571964179E-12   0.00000000000000E+00   5.65774196857886E-14   3.57303062174871E-22
      8.90524918960613E-09   8.90530576702617E-09  -8.77481337940460E-19  -1.88880278737117E-01  -1.88880278737044E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30174826119652E-11   0.00000000000000E+00  -7.30174826119652E-11
      4.70748082628411E-18  -5.64598687972146E-01  -5.61816352763721E-01   0.00000000000000E+00   3.44438907756757E-13
     -1.33902230360950E-22  -8.83263272332183E-09  -8.83228828441421E-09  -3.82999948834365E-18
      3.92058924687077E-07
      0.00000000000000E+00  -1.16011842908943E-11   0.00000000000000E+00   6.71565160580448E-14   3.59005507639263E-22
      1.16011876505764E-08   1.16012548070928E-08  -8.46012883355665E-19  -2.06460905407790E-01  -2.06460905407711E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.87751699504604E-11   0.00000000000000E+00  -7.87751699504604E-11
      4.54993048638319E-18  -5.52629895624437E-01  -5.49000071185772E-01   0.00000000000000E+00   4.38607551193931E-13
     -1.31851146050917E-22  -1.15229182446934E-08  -1.15224796371423E-08  -3.70391760302752E-18
      3.94058924687077E-07
      0.00000000000000E+00  -1.47463154718289E-11   0.00000000000000E+00   7.82087782020041E-14   3.56012192740057E-22
      1.47461991049298E-08   1.47462773137083E-08  -8.15861514965559E-19  -2.23682844413553E-01  -2.23682844413469E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.38332435389324E-11   0.00000000000000E+00  -8.38332435389324E-11
      4.38226399930532E-18  -5.34796621171452E-01  -5.30177595097664E-01   0.00000000000000E+00   5.61152555375898E-13
     -1.29165409362286E-22  -1.46630052227247E-08  -1.46624440701694E-08  -3.56640248433976E-18
      3.96058924687077E-07
      0.00000000000000E+00  -1.83525072335452E-11   0.00000000000000E+00   8.95795126830622E-14   3.47474760314121E-22
      1.83524117416182E-08   1.83525013211313E-08  -7.86677184610889E-19  -2.40553647515469E-01  -2.40553647515380E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.83104301142558E-11   0.00000000000000E+00  -8.83104301142558E-11
      4.20564313907681E-18  -5.10310258373162E-01  -5.04556523275796E-01   0.00000000000000E+00   6.93948559138115E-13
     -1.25741462387323E-22  -1.82648848395760E-08  -1.82641908910170E-08  -3.41896595446592E-18
      3.98058924687077E-07
      0.00000000000000E+00  -2.24113098602202E-11   0.00000000000000E+00   1.00760446501290E-13   3.32194602489418E-22
      2.24112442529309E-08   2.24113450133777E-08  -7.58211060911300E-19  -2.57080412743201E-01  -2.57080412743109E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.24453387472153E-11   0.00000000000000E+00  -9.24453387472153E-11
      4.02075246158238E-18  -4.78409503973540E-01  -4.71378319134484E-01   0.00000000000000E+00   8.13703687737046E-13
     -1.21568480317209E-22  -2.23197133783181E-08  -2.23188996746305E-08  -3.26254140067108E-18
      4.00058924687077E-07
      0.00000000000000E+00  -2.68799237043152E-11   0.00000000000000E+00   1.10905750259637E-13   3.09211784771729E-22
      2.68797898315709E-08   2.68799007373215E-08  -7.30287290095392E-19  -2.73269989337033E-01  -2.73269989336936E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63553608195449E-11   0.00000000000000E+00  -9.63553608195449E-11
      3.82804173994329E-18  -4.38424274409584E-01  -4.29986442715166E-01   0.00000000000000E+00   9.05135846087436E-13
     -1.16689804221274E-22  -2.67844505123479E-08  -2.67835453765019E-08  -3.09775444984790E-18
      4.02058924687077E-07
      0.00000000000000E+00  -3.16800970497294E-11   0.00000000000000E+00   1.19144639362665E-13   2.79993447973387E-22
      3.16799875590860E-08   3.16801067037257E-08  -7.02760420594548E-19  -2.89129613073366E-01  -2.89129613073267E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.98218398554297E-11   0.00000000000000E+00  -9.98218398554297E-11
      3.62839806023243E-18  -3.89844335125378E-01  -3.79895172711961E-01   0.00000000000000E+00   9.69020048378601E-13
     -1.11081222737135E-22  -3.15812538839185E-08  -3.15802848638702E-08  -2.92563763963788E-18
      4.04058924687077E-07
      0.00000000000000E+00  -3.66690113301051E-11   0.00000000000000E+00   1.23868585921528E-13   2.50517168700873E-22
      3.66689064971979E-08   3.66690303657841E-08  -6.75521300216506E-19  -3.04666572829071E-01  -3.04666572828968E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02779823831303E-10   0.00000000000000E+00  -1.02779823831303E-10
      3.42283841256982E-18  -3.32464566626095E-01  -3.20944391453249E-01   0.00000000000000E+00   9.96009219710091E-13
     -1.04556004058398E-22  -3.65672465511724E-08  -3.65662505419528E-08  -2.74731711235332E-18
      4.06058924687077E-07
      0.00000000000000E+00  -4.14249155121852E-11   0.00000000000000E+00   1.18159775006220E-13   2.25586407212181E-22
      4.14247969414817E-08   4.14249151012569E-08  -6.48641160114128E-19  -3.19884832762191E-01  -3.19884832762084E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06879699736825E-10   0.00000000000000E+00  -1.06879699736825E-10
      3.20907901309617E-18  -2.66943895747317E-01  -2.53926431875358E-01   0.00000000000000E+00   9.28400762472973E-13
     -9.67690765375980E-23  -4.13189638022824E-08  -4.13180354015200E-08  -2.56043785298204E-18
      4.08058924687077E-07
      0.00000000000000E+00  -4.49930835526976E-11   0.00000000000000E+00   8.87761822089515E-14   1.93070747938437E-22
      4.49929887438879E-08   4.49930775200703E-08  -6.22474267085443E-19  -3.34781779405441E-01  -3.34781779405326E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15460967862895E-10   0.00000000000000E+00  -1.15460967862895E-10
      2.97815707737038E-18  -1.95761396579916E-01  -1.81622249316955E-01   0.00000000000000E+00   7.34193509240399E-13
     -8.82139138548807E-23  -4.48783507457166E-08  -4.48776165522074E-08  -2.35568281028494E-18
      4.10058924687077E-07
      0.00000000000000E+00  -4.64485471032253E-11   0.00000000000000E+00   3.64131177757284E-14   1.35548932786455E-22
      4.64485135238184E-08   4.64485499369363E-08  -5.97214640656034E-19  -3.49359043515083E-01  -3.49359043514956E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26395446777631E-10   0.00000000000000E+00  -1.26395446777631E-10
      2.72536618381512E-18  -1.23125704671500E-01  -1.08531284217021E-01   0.00000000000000E+00   5.24280000086323E-13
     -8.04958592747304E-23  -4.63226787701586E-08  -4.63221544901586E-08  -2.12815154315909E-18
      4.12058924687077E-07
      0.00000000000000E+00  -4.14509075728149E-11   0.00000000000000E+00  -1.01038193238552E-13   6.52452418345170E-23
      4.14510754825177E-08   4.14509744443246E-08  -5.71439842257139E-19  -3.63645762403434E-01  -3.63645762403308E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25620577584966E-10   0.00000000000000E+00  -1.25620577584966E-10
      2.47412502864519E-18  -6.16308089751757E-02  -4.86106171180239E-02   0.00000000000000E+00   4.34471405568813E-13
     -5.46160066819520E-23  -4.13257883381451E-08  -4.13253538667396E-08  -1.90268518638805E-18
      4.14058924687077E-07
      0.00000000000000E+00  -2.75491044596093E-11   0.00000000000000E+00  -3.43616386974996E-13   2.51397415142301E-23
      2.75493777600976E-08   2.75490341437106E-08  -5.40509993293198E-19  -3.77708981821405E-01  -3.77708981821311E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.34742380608689E-11   0.00000000000000E+00  -9.34742380608689E-11
      2.28717655252345E-18  -2.84016380604400E-02  -1.97513067860267E-02   0.00000000000000E+00   4.89418871285781E-13
     -2.34870426118230E-23  -2.74560493245210E-08  -2.74555599056498E-08  -1.74666655923025E-18
      4.16058924687077E-07
      0.00000000000000E+00  -1.76584365544679E-11   0.00000000000000E+00  -2.43937464994996E-13   1.28730484516963E-23
      1.76586832656782E-08   1.76584393282132E-08  -5.06774613179851E-19  -3.91543016108402E-01  -3.91543016108335E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64403083017181E-11   0.00000000000000E+00  -6.64403083017181E-11
      2.15429593592001E-18  -1.50685626053699E-02  -9.52590181989122E-03   0.00000000000000E+00   3.11676480044550E-13
     -9.50607964365285E-24  -1.75923106963916E-08  -1.75919990199115E-08  -1.64752132274016E-18
      4.18058924687077E-07
      0.00000000000000E+00  -1.34512128324655E-11   0.00000000000000E+00  -1.03490523141586E-13   6.70236714321789E-24
      1.34512801330845E-08   1.34511766425614E-08  -4.72962631888213E-19  -4.05119943125955E-01  -4.05119943125899E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59452418057041E-11   0.00000000000000E+00  -5.59452418057041E-11
      2.04240545230861E-18  -1.01759993765746E-02  -5.95559801410005E-03   0.00000000000000E+00   1.46078281282008E-13
     -7.32366051076689E-24  -1.33953774790369E-08  -1.33952314007557E-08  -1.56944282042039E-18
      4.20058924687077E-07
      0.00000000000000E+00  -1.19584603186316E-11   0.00000000000000E+00  -3.65189252495404E-14   4.93652338677118E-24
      1.19585709447318E-08   1.19585344258066E-08  -4.39771110357623E-19  -4.18429897242043E-01  -4.18429897241989E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30497499181155E-11   0.00000000000000E+00  -5.30497499181155E-11
      1.93630595247238E-18  -8.27455543379931E-03  -4.52352193684784E-03   0.00000000000000E+00   6.98492122153015E-14
     -5.59025541881009E-24  -1.19055545251007E-08  -1.19054846758885E-08  -1.49653484211475E-18
      4.22058924687077E-07
      0.00000000000000E+00  -1.14527631955670E-11   0.00000000000000E+00  -1.22008927691329E-14   4.05672853539941E-24
      1.14527333270511E-08   1.14527211261583E-08  -4.07375285140876E-19  -4.31473017189031E-01  -4.31473017188978E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27386960522759E-11   0.00000000000000E+00  -5.27386960522759E-11
      1.83082856036782E-18  -7.38680534474821E-03  -3.79503697886626E-03   0.00000000000000E+00   4.09469426117135E-14
     -4.66590213730416E-24  -1.14000233770487E-08  -1.13999824301061E-08  -1.42345327522695E-18
      4.24058924687077E-07
      0.00000000000000E+00  -1.12690737211519E-11   0.00000000000000E+00  -4.27883684893523E-15   3.50999788403613E-24
      1.12690344770181E-08   1.12690301981813E-08  -3.75861799097113E-19  -4.44252955876136E-01  -4.44252955876083E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.32028054176665E-11   0.00000000000000E+00  -5.32028054176665E-11
      1.72442294953249E-18  -6.86824046014159E-03  -3.33449144565188E-03   0.00000000000000E+00   2.99634723600093E-14
     -4.05462082669745E-24  -1.12158573562359E-08  -1.12158273927636E-08  -1.34856115043538E-18
      4.26058924687077E-07
      0.00000000000000E+00  -1.11888932655697E-11   0.00000000000000E+00  -1.74591511478675E-15   3.12406523195754E-24
      1.11888714832655E-08   1.11888697373504E-08  -3.45290387309290E-19  -4.56774401022962E-01  -4.56774401022908E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38481126815285E-11   0.00000000000000E+00  -5.38481126815285E-11
      1.61672672416943E-18  -6.51199895473245E-03  -3.00370750177828E-03   0.00000000000000E+00   2.50152332026375E-14
     -3.59796065280462E-24  -1.11350466399021E-08  -1.11350216246689E-08  -1.27143633686014E-18
      4.28058924687077E-07
      0.00000000000000E+00  -1.11450833259217E-11   0.00000000000000E+00  -8.66696668824070E-16   2.83317575697922E-24
      1.11451016246778E-08   1.11451007579811E-08  -3.15697377992689E-19  -4.69042210230318E-01  -4.69042210230263E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44775083049593E-11   0.00000000000000E+00  -5.44775083049593E-11
      1.50777170755952E-18  -6.24536818541412E-03  -2.75106367478008E-03   0.00000000000000E+00   2.21054218430756E-14
     -3.23810426771981E-24  -1.10906453550980E-08  -1.10906232496762E-08  -1.19207432956683E-18
      4.30058924687077E-07
      0.00000000000000E+00  -1.11168869915990E-11   0.00000000000000E+00  -4.99234903172932E-16   2.60559076312545E-24
      1.11168795841087E-08   1.11168790848738E-08  -2.87097462533088E-19  -4.81060993662681E-01  -4.81060993662626E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50194351853013E-11   0.00000000000000E+00  -5.50194351853013E-11
      1.39773283718891E-18  -6.03714790565555E-03  -2.55190447226880E-03   0.00000000000000E+00   1.99918316261072E-14
     -2.94738425307034E-24  -1.10618796415201E-08  -1.10618596496885E-08  -1.11063537465582E-18
      4.32058924687077E-07
      0.00000000000000E+00  -1.10969566836250E-11   0.00000000000000E+00  -3.09182051508502E-16   2.42292623939167E-24
      1.10969429251725E-08   1.10969426159905E-08  -2.59488579253075E-19  -4.92834551241684E-01  -4.92834551241629E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54431740343367E-11   0.00000000000000E+00  -5.54431740343367E-11
      1.28684648912024E-18  -5.87053046867350E-03  -2.39170060327119E-03   0.00000000000000E+00   1.82844490664898E-14
     -2.70889326226153E-24  -1.10415177264052E-08  -1.10414994419562E-08  -1.02735790986716E-18
      4.34058924687077E-07
      0.00000000000000E+00  -1.10821696809346E-11   0.00000000000000E+00  -1.94834064394142E-16   2.27337062948810E-24
      1.10821526996044E-08   1.10821525047704E-08  -2.32860157512152E-19  -5.04364161487590E-01  -5.04364161487534E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57270529323702E-11   0.00000000000000E+00  -5.57270529323702E-11
      1.17539238325550E-18  -5.73488821492619E-03  -2.26080651402884E-03   0.00000000000000E+00   1.68397131546606E-14
     -2.51087715836770E-24  -1.10264422915512E-08  -1.10264254518380E-08  -9.42532225743346E-19
      4.36058924687077E-07
      0.00000000000000E+00  -1.10707809335209E-11   0.00000000000000E+00  -1.22494242072241E-16   2.14894667811341E-24
      1.10707654465955E-08   1.10707653241012E-08  -2.07212685775286E-19  -5.15641554361375E-01  -5.15641554361319E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58218650532396E-11   0.00000000000000E+00  -5.58218650532396E-11
      1.06374865314902E-18  -5.62294741927189E-03  -2.15248224780738E-03   0.00000000000000E+00   1.55810225334802E-14
     -2.34481011965254E-24  -1.10149590400705E-08  -1.10149434590480E-08  -8.56535967373734E-19
      4.38058924687077E-07
      0.00000000000000E+00  -1.10615046150629E-11   0.00000000000000E+00  -8.16756757903499E-17   2.04425624596636E-24
      1.10614718829654E-08   1.10614718012897E-08  -1.82617945460113E-19  -5.26622643931358E-01  -5.26622643931303E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55446072534358E-11   0.00000000000000E+00  -5.55446072534358E-11
      9.52659438642148E-19  -5.52966193122342E-03  -2.06203652339641E-03   0.00000000000000E+00   1.44265919729519E-14
     -2.20467636697444E-24  -1.10059416206282E-08  -1.10059271940363E-08  -7.70041493182034E-19
      4.40058924687077E-07
      0.00000000000000E+00  -1.10530548992398E-11   0.00000000000000E+00  -7.08175943944073E-17   1.95581223938985E-24
      1.10530465544960E-08   1.10530464836784E-08  -1.59296130075434E-19  -5.37190991473985E-01  -5.37190991473930E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.45089194492477E-11   0.00000000000000E+00  -5.45089194492477E-11
      8.43641599743652E-19  -5.45163727243357E-03  -1.98633937293952E-03   0.00000000000000E+00   1.32670422940155E-14
     -2.08651833103171E-24  -1.09985508312714E-08  -1.09985375642291E-08  -6.84345469668219E-19
      4.42058924687077E-07
      0.00000000000000E+00  -1.10445133386795E-11   0.00000000000000E+00  -8.53952608371416E-17   1.88138802019455E-24
      1.10445552287258E-08   1.10445551433305E-08  -1.37593690452345E-19  -5.47164437646924E-01  -5.47164437646872E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.23375440322330E-11   0.00000000000000E+00  -5.23375440322330E-11
      7.38966511679186E-19  -5.38657315932251E-03  -1.92326587945484E-03   0.00000000000000E+00   1.20294235647917E-14
     -1.98762725486827E-24  -1.09922296287218E-08  -1.09922175992983E-08  -6.01372821226842E-19
      4.44058924687077E-07
      0.00000000000000E+00  -1.10352370202215E-11   0.00000000000000E+00  -1.19983782275284E-16   1.81958686403906E-24
      1.10352338384535E-08   1.10352337184697E-08  -1.17978422959355E-19  -5.56295306765712E-01  -5.56295306765663E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.86403682669336E-11   0.00000000000000E+00  -4.86403682669336E-11
      6.41685775145319E-19  -5.33292961286247E-03  -1.87139377771226E-03   0.00000000000000E+00   1.06373811870897E-14
     -1.90623533853667E-24  -1.09866039875840E-08  -1.09865933502028E-08  -5.23707352185965E-19
      4.46058924687077E-07
      0.00000000000000E+00  -1.10242156517566E-11   0.00000000000000E+00  -1.78273202178461E-16   1.76974479422086E-24
      1.10242321856499E-08   1.10242320073767E-08  -1.01094951960969E-19  -5.64243580316967E-01  -5.64243580316925E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.28773864605186E-11   0.00000000000000E+00  -4.28773864605186E-11
      5.55931002224282E-19  -5.28984463234863E-03  -1.82995885563404E-03   0.00000000000000E+00   9.00267269592346E-15
     -1.84155811065513E-24  -1.09813636235889E-08  -1.09813546209162E-08  -4.54836050263312E-19
      4.48058924687077E-07
      0.00000000000000E+00  -1.10105307859127E-11   0.00000000000000E+00  -2.65116664172905E-16   1.73192481375205E-24
      1.10105515232830E-08   1.10105512581663E-08  -8.78104258742783E-20  -5.70555371534904E-01  -5.70555371534869E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.43910565526876E-11   0.00000000000000E+00  -3.43910565526876E-11
      4.87148889118907E-19  -5.25710729893243E-03  -1.79885773598063E-03   0.00000000000000E+00   7.01115182744735E-15
     -1.79382572867221E-24  -1.09761672127655E-08  -1.09761602016137E-08  -3.99338463244628E-19
      4.50058924687077E-07
      0.00000000000000E+00  -1.09931721305805E-11   0.00000000000000E+00  -3.81942367173024E-16   1.70692095401814E-24
      1.09931828363134E-08   1.09931824543710E-08  -7.92119568954373E-20  -5.74667465452665E-01  -5.74667465452643E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25655981313962E-11   0.00000000000000E+00  -2.25655981313962E-11
      4.42017692856114E-19  -5.23516461456607E-03  -1.77866134209214E-03   0.00000000000000E+00   4.54777363242338E-15
     -1.76430872147948E-24  -1.09706214040132E-08  -1.09706168562396E-08  -3.62805735960677E-19
      4.52058924687077E-07
      0.00000000000000E+00  -1.09713130831251E-11   0.00000000000000E+00  -5.25493614280584E-16   1.69635357628041E-24
      1.09712981484065E-08   1.09712976229129E-08  -7.65735660433709E-20  -5.75932608507708E-01  -5.75932608507701E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97484525216772E-12   0.00000000000000E+00  -6.97484525216772E-12
      4.28068002351779E-19  -5.22524198365529E-03  -1.77072170364194E-03   0.00000000000000E+00   1.50295251932534E-15
     -1.75553185888754E-24  -1.09643242806132E-08  -1.09643227776607E-08  -3.51494436308408E-19
      4.54058924687077E-07
      0.00000000000000E+00  -1.09442188856489E-11   0.00000000000000E+00  -5.24152247814774E-16   1.70295790947745E-24
      1.09442122404874E-08   1.09442117163352E-08  -8.13264388621030E-20  -5.73651338589088E-01  -5.73651338589100E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25362564142314E-11   0.00000000000000E+00   1.25362564142314E-11
      4.53140515180241E-19  -5.22959526554222E-03  -1.77746175653205E-03   0.00000000000000E+00  -2.40832915127152E-15
     -1.77187268596147E-24  -1.09567455644202E-08  -1.09567479727494E-08  -3.71814076318139E-19
      4.56058924687077E-07
      0.00000000000000E+00  -1.09111547802542E-11   0.00000000000000E+00  -8.89270173797055E-16   1.73128502517203E-24
      1.09111632702923E-08   1.09111623810221E-08  -9.50695306415688E-20  -5.67094218163492E-01  -5.67094218163528E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58471459862276E-11   0.00000000000000E+00   3.58471459862276E-11
      5.24834807152697E-19  -5.25216921641576E-03  -1.80310432319673E-03   0.00000000000000E+00  -6.83584197300739E-15
     -1.82098309170047E-24  -1.09470026911664E-08  -1.09470095270083E-08  -4.29765276511128E-19
      4.58058924687077E-07
      0.00000000000000E+00  -1.08708349406201E-11   0.00000000000000E+00  -1.12986242392020E-15   1.78919255805676E-24
      1.08708517624447E-08   1.08708506325823E-08  -1.19640086808212E-19  -5.55508529686514E-01  -5.55508529686577E-01
      0.00000000000000E+00   0.00000000000000E+00   6.25615903437559E-11   0.00000000000000E+00   6.25615903437559E-11
      6.49957987840209E-19  -5.30014879132688E-03  -1.85536870607292E-03   0.00000000000000E+00  -1.25453654323269E-14
     -1.91700478065337E-24  -1.09333996775606E-08  -1.09334122229260E-08  -5.30317901031997E-19
      4.60058924687077E-07
      0.00000000000000E+00  -1.08204121798931E-11   0.00000000000000E+00  -1.00799438482576E-14   1.89096610509334E-24
      1.08204696702500E-08   1.08204595903061E-08  -1.57239453324768E-19  -5.38117985575702E-01  -5.38117985575794E-01
      0.00000000000000E+00   0.00000000000000E+00   9.18971640218413E-11   0.00000000000000E+00   9.18971640218413E-11
      8.33752315883891E-19  -5.38759627104557E-03  -1.94944845705734E-03   0.00000000000000E+00  -1.11995117156150E-14
     -2.08830560501153E-24  -1.09123455548162E-08  -1.09123567543280E-08  -6.76512862559123E-19
      4.62058924687077E-07
      0.00000000000000E+00  -1.07531818322572E-11   0.00000000000000E+00  -2.04563377726786E-15   2.06405414849706E-24
      1.07531437931385E-08   1.07531417475047E-08  -2.10583507118817E-19  -5.14132880509243E-01  -5.14132880509365E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22373986092449E-10   0.00000000000000E+00   1.22373986092449E-10
      1.07850028806879E-18  -5.54462137462506E-03  -2.11808558929825E-03   0.00000000000000E+00  -2.94078635100167E-14
     -2.39873652717700E-24  -1.08754863257336E-08  -1.08755157335972E-08  -8.67916780949972E-19
      4.64058924687076E-07
      0.00000000000000E+00  -1.06496728134243E-11   0.00000000000000E+00  -3.01530761625095E-15   2.36344162480854E-24
      1.06496218514660E-08   1.06496188361584E-08  -2.82972155735003E-19  -4.82786749193466E-01  -4.82786749193618E-01
      0.00000000000000E+00   0.00000000000000E+00   1.51324968777876E-10   0.00000000000000E+00   1.51324968777876E-10
      1.38115022562454E-18  -5.84357253085809E-03  -2.44053518148128E-03   0.00000000000000E+00  -4.29574409743638E-14
     -3.01790338099465E-24  -1.08009008474953E-08  -1.08009438049363E-08  -1.09817806988954E-18
      4.66058924687076E-07
      0.00000000000000E+00  -1.04468796336701E-11   0.00000000000000E+00  -2.11206814339663E-14   2.89206506642876E-24
      1.04469305003126E-08   1.04469093796311E-08  -3.77878881316686E-19  -4.43399975238506E-01  -4.43399975238681E-01
      0.00000000000000E+00   0.00000000000000E+00   1.74677286173149E-10   0.00000000000000E+00   1.74677286173149E-10
      1.73050479797084E-18  -6.48637823671555E-03  -3.13985060160094E-03   0.00000000000000E+00  -4.74417319502628E-14
     -4.50880619337237E-24  -1.06215392240723E-08  -1.06215866658043E-08  -1.35262591665415E-18
      4.68058924687076E-07
      0.00000000000000E+00  -9.90958792100610E-12   0.00000000000000E+00  -1.42890271866404E-14   3.69786163232406E-24
      9.90964865156235E-09   9.90963436253517E-09  -4.96836179385994E-19  -3.95448384380815E-01  -3.95448384381004E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88953288391481E-10   0.00000000000000E+00   1.88953288391481E-10
      2.10841137475380E-18  -8.13777247051387E-03  -4.95603744507690E-03   0.00000000000000E+00  -9.30632580159341E-14
     -9.20327214322869E-24  -1.00984945876686E-08  -1.00985876509267E-08  -1.61157519536781E-18
      4.70058924687076E-07
      0.00000000000000E+00  -8.21303193530867E-12   0.00000000000000E+00  -4.34295520680523E-14   3.27540482392525E-24
      8.21306051952806E-09   8.21301708997600E-09  -6.34081903578389E-19  -3.38689323213759E-01  -3.38689323213959E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00182794994134E-10   0.00000000000000E+00   2.00182794994134E-10
      2.50877696474207E-18  -1.30489243117778E-02  -1.03982102562992E-02   0.00000000000000E+00  -1.35389480242974E-13
     -2.60762372903698E-23  -8.41306449548986E-09  -8.41319988497013E-09  -1.87469506116368E-18
      4.72058924687076E-07
      0.00000000000000E+00  -4.44519343610709E-12   0.00000000000000E+00  -9.51027650057994E-14  -6.96128677828211E-24
      4.44524615809278E-09   4.44515105532776E-09  -7.76480701668297E-19  -2.73665857180330E-01  -2.73665857180555E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25089486459713E-10   0.00000000000000E+00   2.25089486459713E-10
      2.95895593766150E-18  -2.51748520256924E-02  -2.37034266382925E-02   0.00000000000000E+00  -2.06200547409172E-13
     -6.14553130662197E-23  -4.67003434124001E-09  -4.67024054178748E-09  -2.18247523599320E-18
      4.74058924687076E-07
      0.00000000000000E+00  -1.29078593671458E-12   0.00000000000000E+00  -8.09077404253330E-14  -2.74427259065010E-23
      1.29084742575220E-09   1.29076651801175E-09  -9.20666807334354E-19  -2.02679523272064E-01  -2.02679523272308E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43993308749464E-10   0.00000000000000E+00   2.43993308749464E-10
      3.44694255516042E-18  -4.31840580831454E-02  -4.27005141709234E-02   0.00000000000000E+00  -3.81014672387953E-13
     -8.31494540513855E-23  -1.53437881208874E-09  -1.53475982676121E-09  -2.52627574782607E-18
      4.76058924687076E-07
      0.00000000000000E+00  -2.00864440272861E-13   0.00000000000000E+00  -3.02909432629957E-14  -4.07759158092221E-23
      2.00917233062506E-10   2.00886942119202E-10  -1.06809417853095E-18  -1.29761304009690E-01  -1.29761304009928E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37845665323614E-10   0.00000000000000E+00   2.37845665323614E-10
      3.92263388580765E-18  -6.29745746327799E-02  -6.28363479677195E-02   0.00000000000000E+00  -6.26384831891120E-13
     -9.10146230748134E-23  -4.38106222610832E-10  -4.38732607442814E-10  -2.85453970727670E-18
      4.78058924687076E-07
      0.00000000000000E+00   1.72668105950150E-14   0.00000000000000E+00  -9.75915912663348E-15  -4.49952185891808E-23
     -1.72407970510041E-11  -1.72505562101758E-11  -1.19759672236220E-18  -6.61445460417393E-02  -6.61445460419394E-02
      0.00000000000000E+00   0.00000000000000E+00   2.00129181036472E-10   0.00000000000000E+00   2.00129181036472E-10
      4.32289224788059E-18  -8.28696187032237E-02  -8.28120011131833E-02   0.00000000000000E+00  -7.86739349718307E-13
     -9.79903962344763E-23  -1.82091885476480E-10  -1.82878624826296E-10  -3.12529552551839E-18
      4.80058924687077E-07
      0.00000000000000E+00   2.12161342949387E-14   0.00000000000000E+00  -2.59764367696551E-15  -4.59296787170360E-23
     -2.11844462372525E-11  -2.11870438809754E-11  -1.27201908448722E-18  -3.03831497671315E-02  -3.03831497672625E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31012929418209E-10   0.00000000000000E+00   1.31012929418209E-10
      4.58491810671701E-18  -1.02509227286146E-01  -1.02474625774354E-01   0.00000000000000E+00  -6.14499376074777E-13
     -1.02650219975344E-22  -1.09211386161056E-10  -1.09825885537234E-10  -3.31289902222979E-18
      4.82058924687077E-07
      0.00000000000000E+00   3.67378948830107E-16   0.00000000000000E+00  -1.49758243392201E-16  -4.59500930287628E-23
     -3.68923743560824E-13  -3.69073501850167E-13  -1.30444836423661E-18  -1.58013008655766E-02  -1.58013008656561E-02
      0.00000000000000E+00   0.00000000000000E+00   7.95095891159250E-11   0.00000000000000E+00   7.95095891159250E-11
      4.74393728494886E-18  -1.21814058215846E-01  -1.21789124579848E-01   0.00000000000000E+00  -3.92676936189291E-13
     -1.05264628792781E-22  -7.87478386777803E-11  -7.91405156140748E-11  -3.43948892071225E-18
      4.84058924687077E-07
      0.00000000000000E+00  -1.51543816392419E-14   0.00000000000000E+00   4.78632535628518E-16  -4.53813186517596E-23
      1.51430374748162E-11   1.51435161073064E-11  -1.31702714475806E-18  -1.04442184096046E-02  -1.04442184096571E-02
      0.00000000000000E+00   0.00000000000000E+00   5.24169006865735E-11   0.00000000000000E+00   5.24169006865735E-11
      4.84877108632201E-18  -1.40751595690542E-01  -1.40730310594646E-01   0.00000000000000E+00  -2.94957821811978E-13
     -1.07094097937803E-22  -6.72654589719611E-11  -6.75604167938802E-11  -3.53174394156395E-18
      4.86058924687077E-07
      0.00000000000000E+00  -2.57165264181075E-14   0.00000000000000E+00   4.90179567935401E-16  -4.40424515881508E-23
      2.57309197834070E-11   2.57314099629309E-11  -1.32127172402438E-18  -8.38610208147831E-03  -8.38610208151674E-03
      0.00000000000000E+00   0.00000000000000E+00   3.84377401667784E-11   0.00000000000000E+00   3.84377401667784E-11
      4.92564656665557E-18  -1.59311849017419E-01  -1.59291632461448E-01   0.00000000000000E+00  -2.71487913842192E-13
     -1.08703238212008E-22  -6.38976622157583E-11  -6.41691501297092E-11  -3.60437484263119E-18
      4.88058924687077E-07
      0.00000000000000E+00  -3.34314843435397E-14   0.00000000000000E+00   3.88896648424006E-16  -4.15686261691162E-23
      3.34781086263121E-11   3.34784975229189E-11  -1.32203745698168E-18  -7.44476930905992E-03  -7.44476930909046E-03
      0.00000000000000E+00   0.00000000000000E+00   3.05383712696172E-11   0.00000000000000E+00   3.05383712696172E-11
      4.98672330919480E-18  -1.77495672502651E-01  -1.77475504023758E-01   0.00000000000000E+00  -2.73711916459905E-13
     -1.10267571486776E-22  -6.37431568759658E-11  -6.40168687925360E-11  -3.66468585221312E-18
      4.90058924687077E-07
      0.00000000000000E+00  -3.95850817364440E-14   0.00000000000000E+00   3.12561070964282E-16  -3.75368446360787E-23
      3.95849366988276E-11   3.95852492598611E-11  -1.32131804958286E-18  -6.90522027685346E-03  -6.90522027687906E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55980352637176E-11   0.00000000000000E+00   2.55980352637176E-11
      5.03791937972224E-18  -1.95308597038783E-01  -1.95288061189958E-01   0.00000000000000E+00  -2.81531854124080E-13
     -1.11826312410041E-22  -6.49017526693433E-11  -6.51832845235792E-11  -3.71660133013938E-18
      4.92058924687077E-07
      0.00000000000000E+00  -4.47283870200655E-14   0.00000000000000E+00   2.48168749428656E-16  -3.15314790946129E-23
      4.47103347337937E-11   4.47105829025116E-11  -1.31996722512653E-18  -6.53867904011723E-03  -6.53867904013951E-03
      0.00000000000000E+00   0.00000000000000E+00   2.22779721828226E-11   0.00000000000000E+00   2.22779721828226E-11
      5.08247532408788E-18  -2.12757932336787E-01  -2.12736827851045E-01   0.00000000000000E+00  -2.88778862550270E-13
     -1.13381181641707E-22  -6.66997762226701E-11  -6.69885550853337E-11  -3.76250809896135E-18
      4.94058924687077E-07
      0.00000000000000E+00  -4.92287791432343E-14   0.00000000000000E+00   2.05647303069197E-16  -2.32336166530224E-23
      4.92400295109501E-11   4.92402351582300E-11  -1.31837080611446E-18  -6.26582133914444E-03  -6.26582133916439E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99459424635341E-11   0.00000000000000E+00   1.99459424635341E-11
      5.12236720901495E-18  -2.29851374789565E-01  -2.29829578067772E-01   0.00000000000000E+00  -2.94221803990366E-13
     -1.14926830360350E-22  -6.88919558176583E-11  -6.91861776217636E-11  -3.80399640290049E-18
      4.96058924687077E-07
      0.00000000000000E+00  -5.34536370547806E-14   0.00000000000000E+00   1.78597829360877E-16  -1.25451106723943E-23
      5.34076156001217E-11   5.34077941979385E-11  -1.31670765161941E-18  -6.05333000981352E-03  -6.05333000983178E-03
      0.00000000000000E+00   0.00000000000000E+00   1.82569267855621E-11   0.00000000000000E+00   1.82569267855621E-11
      5.15888106258608E-18  -2.46596320654436E-01  -2.46573743205010E-01   0.00000000000000E+00  -2.98032657900420E-13
     -1.16458546029138E-22  -7.13666883254845E-11  -7.16647209835014E-11  -3.84217341096666E-18
      4.98058924687077E-07
      0.00000000000000E+00  -5.73111160174967E-14   0.00000000000000E+00   1.61444742146236E-16   2.91643184017655E-25
      5.73526708846621E-11   5.73528323294045E-11  -1.31505864614696E-18  -5.88359302950762E-03  -5.88359302952462E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69991573946892E-11   0.00000000000000E+00   1.69991573946892E-11
      5.19287937737545E-18  -2.62999700579955E-01  -2.62976276656816E-01   0.00000000000000E+00  -3.00700008539037E-13
     -1.17973709684093E-22  -7.40512897154368E-11  -7.43519897240938E-11  -3.87782073122849E-18
      5.00058924687077E-07
      0.00000000000000E+00  -6.11685949802128E-14   0.00000000000000E+00   1.50410451901555E-16   1.42732497202392E-23
      6.11580627592972E-11   6.11582131697633E-11  -1.31345686766962E-18  -5.74559456405022E-03  -5.74559456406626E-03
      0.00000000000000E+00   0.00000000000000E+00   1.60339940202036E-11   0.00000000000000E+00   1.60339940202036E-11
      5.22494736541586E-18  -2.79068407712643E-01  -2.79044089141709E-01   0.00000000000000E+00  -3.02723736605866E-13
     -1.19471784321714E-22  -7.68894834532414E-11  -7.71922071899667E-11  -3.91149049774624E-18
      5.02058924687077E-07
      0.00000000000000E+00  -6.48423844685139E-14   0.00000000000000E+00   1.43175639706934E-16   2.83120490203912E-23
      6.48752436320326E-11   6.48753868077006E-11  -1.31191234098734E-18  -5.63182708632645E-03  -5.63182708634172E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52681337027513E-11   0.00000000000000E+00   1.52681337027513E-11
      5.25548363282137E-18  -2.94809866829240E-01  -2.94784618621284E-01   0.00000000000000E+00  -3.04538810699320E-13
     -1.20953726859283E-22  -7.98389816996314E-11  -8.01435205104516E-11  -3.94357129183402E-18
      5.04058924687077E-07
      0.00000000000000E+00  -6.85161739568150E-14   0.00000000000000E+00   1.38344632417586E-16   4.17431414258187E-23
      6.85380164732142E-11   6.85381548178884E-11  -1.31042454533081E-18  -5.53707261951021E-03  -5.53707261952484E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46366774554349E-11   0.00000000000000E+00   1.46366774554349E-11
      5.28475698773223E-18  -3.10230764612736E-01  -3.10204561575133E-01   0.00000000000000E+00  -3.06458883942271E-13
     -1.22421678791142E-22  -8.28683733892595E-11  -8.31748322733241E-11  -3.97433244240142E-18
      5.06058924687077E-07
      0.00000000000000E+00  -7.21899634451160E-14   0.00000000000000E+00   1.35035518974429E-16   5.40425576596951E-23
      7.21683093421458E-11   7.21684443777189E-11  -1.30898883535981E-18  -5.45781204704251E-03  -5.45781204705660E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40912170486885E-11   0.00000000000000E+00   1.40912170486885E-11
      5.31293942182961E-18  -3.25332815778412E-01  -3.25305641061083E-01   0.00000000000000E+00  -3.08604004032183E-13
     -1.23877913434919E-22  -8.59510574222505E-11  -8.62596614264066E-11  -4.00395058646980E-18
      5.08058924687077E-07
      0.00000000000000E+00  -7.57719081962096E-14   0.00000000000000E+00   1.32643468367326E-16   6.48922511058410E-23
      7.57790085140923E-11   7.57791411576255E-11  -1.30759978444611E-18  -5.39166671679846E-03  -5.39166671681206E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35970857957317E-11   0.00000000000000E+00   1.35970857957317E-11
      5.34013359342107E-18  -3.40112443022003E-01  -3.40084286636872E-01   0.00000000000000E+00  -3.11005322668220E-13
     -1.25324464596363E-22  -8.90652216305641E-11  -8.93762269533576E-11  -4.03253380897496E-18
      5.10058924687077E-07
      0.00000000000000E+00  -7.93538529473031E-14   0.00000000000000E+00   1.30919529444375E-16   7.41888237729083E-23
      7.93802713199519E-11   7.93804022395555E-11  -1.30625147090737E-18  -5.33703478592050E-03  -5.33703478593365E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31426869740228E-11   0.00000000000000E+00   1.31426869740228E-11
      5.36641896736912E-18  -3.54577776506447E-01  -3.54548628919115E-01   0.00000000000000E+00  -3.14087764310932E-13
     -1.26765056538089E-22  -9.22090014491400E-11  -9.25230892135778E-11  -4.06016749646175E-18
      5.12058924687077E-07
      0.00000000000000E+00  -8.30276424356042E-14   0.00000000000000E+00   1.29997955867768E-16   8.20049224445174E-23
      8.29880140385764E-11   8.29881440366143E-11  -1.30493559575871E-18  -5.29299146234324E-03  -5.29299146235598E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27452599265756E-11   0.00000000000000E+00   1.27452599265756E-11
      5.39190948722227E-18  -3.68777241276226E-01  -3.68747082507116E-01   0.00000000000000E+00  -3.19075973415867E-13
     -1.28208578642779E-22  -9.54143279896447E-11  -9.57334039631888E-11  -4.08697389146356E-18
      5.14058924687077E-07
      0.00000000000000E+00  -8.66095871866977E-14   0.00000000000000E+00   1.29798249588738E-16   8.85159174081317E-23
      8.66174152213587E-11   8.66175450196968E-11  -1.30364376148591E-18  -5.25926633452099E-03  -5.25926633453339E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23969232494828E-11   0.00000000000000E+00   1.23969232494828E-11
      5.41670333372123E-18  -3.82760889935848E-01  -3.82729697707948E-01   0.00000000000000E+00  -3.26129770219151E-13
     -1.29663963840238E-22  -9.86883384988321E-11  -9.90144682691810E-11  -4.11305957223533E-18
      5.16058924687077E-07
      0.00000000000000E+00  -9.02833766749988E-14   0.00000000000000E+00   1.29510178633545E-16   9.39239099583058E-23
      9.02639667902792E-11   9.02640963005518E-11  -1.30237264152787E-18  -5.23623781652427E-03  -5.23623781653630E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20338649314550E-11   0.00000000000000E+00   1.20338649314550E-11
      5.44077106358415E-18  -3.96503661899165E-01  -3.96471435461332E-01   0.00000000000000E+00  -3.33041663332794E-13
     -1.31129717084456E-22  -1.01964919568543E-10  -1.02297961232007E-10  -4.13839842205627E-18
      5.18058924687077E-07
      0.00000000000000E+00  -9.39571661632999E-14   0.00000000000000E+00   1.29408537518957E-16   9.84334823883227E-23
      9.39248029643911E-11   9.39249323730271E-11  -1.30111856503086E-18  -5.22504629955982E-03  -5.22504629957147E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16519968328793E-11   0.00000000000000E+00   1.16519968328793E-11
      5.46407505724991E-18  -4.09984029912698E-01  -4.09950770704768E-01   0.00000000000000E+00  -3.39920919627514E-13
     -1.32604722591334E-22  -1.05237008286145E-10  -1.05576929205906E-10  -4.16295649221904E-18
      5.20058924687077E-07
      0.00000000000000E+00  -9.76309556516009E-14   0.00000000000000E+00   1.29547711229165E-16   1.02232508220384E-22
      9.76031408001922E-11   9.76032703480057E-11  -1.29987550890584E-18  -5.22782221095593E-03  -5.22782221096718E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12594407946797E-11   0.00000000000000E+00   1.12594407946797E-11
      5.48659393883926E-18  -4.23196808075876E-01  -4.23162513965621E-01   0.00000000000000E+00  -3.47199322930196E-13
     -1.34089476435706E-22  -1.08515511819622E-10  -1.08862711142686E-10  -4.18671842993342E-18
      5.22058924687077E-07
      0.00000000000000E+00  -1.01304745139902E-13   0.00000000000000E+00   1.30307577595990E-16   1.05482832240228E-22
      1.01309013563940E-10   1.01309143871623E-10  -1.29863388835141E-18  -5.24828592151778E-03  -5.24828592152864E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08582666657385E-11   0.00000000000000E+00   1.08582666657385E-11
      5.50831047217074E-18  -4.36143867510320E-01  -4.36108532553206E-01   0.00000000000000E+00  -3.54951221437736E-13
     -1.35584484012126E-22  -1.11812459315788E-10  -1.12167410537362E-10  -4.20967658381933E-18
      5.24058924687078E-07
      0.00000000000000E+00  -1.05070379365411E-13   0.00000000000000E+00   1.32252792502561E-16   1.08322422633377E-22
      1.05064688550162E-10   1.05064820803063E-10  -1.29737746097916E-18  -5.29317027774017E-03  -5.29317027775061E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04452608683175E-11   0.00000000000000E+00   1.04452608683175E-11
      5.52920099390738E-18  -4.48829396707486E-01  -4.48793008957363E-01   0.00000000000000E+00  -3.63022732281642E-13
     -1.37089227367498E-22  -1.15147058938961E-10  -1.15510081671380E-10  -4.23182353292821E-18
      5.26058924687078E-07
      0.00000000000000E+00  -1.08927858328127E-13   0.00000000000000E+00   1.36594511219135E-16   1.10877359707114E-22
      1.08918562497719E-10   1.08918699092341E-10  -1.29607591687293E-18  -5.37554505853742E-03  -5.37554505854743E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00102331307167E-11   0.00000000000000E+00   1.00102331307167E-11
      5.54922146016881E-18  -4.61258206979985E-01  -4.61220742455716E-01   0.00000000000000E+00  -3.71055108010184E-13
     -1.38601396006008E-22  -1.18557877114910E-10  -1.18928932223059E-10  -4.25314554329588E-18
      5.28058924687078E-07
      0.00000000000000E+00  -1.12969026765258E-13   0.00000000000000E+00   1.46165208927119E-16   1.13289055873676E-22
      1.12980697200972E-10   1.12980843366294E-10  -1.29466646163492E-18  -5.52310949208057E-03  -5.52310949209010E-03
      0.00000000000000E+00   0.00000000000000E+00   9.52744356511878E-12   0.00000000000000E+00   9.52744356511878E-12
      5.56827634729905E-18  -4.73435114790308E-01  -4.73396522948727E-01   0.00000000000000E+00  -3.78312215308149E-13
     -1.40115541971842E-22  -1.22129974715965E-10  -1.22508286931414E-10  -4.27360988566413E-18
      5.30058924687078E-07
      0.00000000000000E+00  -1.17561263625634E-13   0.00000000000000E+00   1.68579812190289E-16   1.15784124798652E-22
      1.17525763689257E-10   1.17525932269185E-10  -1.29300225733482E-18  -5.80154579633412E-03  -5.80154579634305E-03
      0.00000000000000E+00   0.00000000000000E+00   8.92791071651691E-12   0.00000000000000E+00   8.92791071651691E-12
      5.58613216873208E-18  -4.85364539653079E-01  -4.85324705156475E-01   0.00000000000000E+00  -3.83053510271820E-13
     -1.41619514184602E-22  -1.26070789475287E-10  -1.26453842985701E-10  -4.29312991139726E-18
      5.32058924687078E-07
      0.00000000000000E+00  -1.23347482069708E-13   0.00000000000000E+00   2.26674987862286E-16   1.18900049642985E-22
      1.23344947608654E-10   1.23345174283760E-10  -1.29068396168095E-18  -6.39113356975377E-03  -6.39113356976177E-03
      0.00000000000000E+00   0.00000000000000E+00   8.00129354806426E-12   0.00000000000000E+00   8.00129354806426E-12
      5.60213475582821E-18  -4.97049723498185E-01  -4.97008348035325E-01   0.00000000000000E+00  -3.80254937553918E-13
     -1.43082754667283E-22  -1.30966212894128E-10  -1.31346467831825E-10  -4.31145079414726E-18
      5.34058924687078E-07
      0.00000000000000E+00  -1.33174868950914E-13   0.00000000000000E+00   4.19109124077348E-16   1.24361726834888E-22
      1.33172886657865E-10   1.33173305767113E-10  -1.28642250444341E-18  -7.87641055983733E-03  -7.87641055984334E-03
      0.00000000000000E+00   0.00000000000000E+00   6.00292005033557E-12   0.00000000000000E+00   6.00292005033557E-12
      5.61414059592888E-18  -5.08489991665821E-01  -5.08446150060063E-01   0.00000000000000E+00  -3.52447845709580E-13
     -1.44411739079171E-22  -1.38823777971594E-10  -1.39176225817448E-10  -4.32771809148547E-18
      5.36058924687078E-07
      0.00000000000000E+00  -1.57697413785323E-13   0.00000000000000E+00   1.01568547185937E-15   1.38322392012134E-22
      1.57664467582528E-10   1.57665483268138E-10  -1.27575374612480E-18  -1.22676295609964E-02  -1.22676295609967E-02
      0.00000000000000E+00   0.00000000000000E+00   2.71487641675653E-13   0.00000000000000E+00   2.71487641675653E-13
      5.61468357121223E-18  -5.19669161816402E-01  -5.19619410806710E-01   0.00000000000000E+00  -2.37740727708611E-13
     -1.45292988956009E-22  -1.57699230181960E-10  -1.57936970909814E-10  -4.33892982508743E-18
      5.38058924687078E-07
      0.00000000000000E+00  -2.27315724588629E-13   0.00000000000000E+00   2.70562468171102E-15   1.73122939711087E-22
      2.27272392612282E-10   2.27275098237136E-10  -1.24930667737740E-18  -2.35760780992277E-02  -2.35760780992144E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.33651490944034E-11   0.00000000000000E+00  -1.33651490944034E-11
      5.58795327302342E-18  -5.30520351890166E-01  -5.30452969492916E-01   0.00000000000000E+00   4.75819565659193E-14
     -1.45114837239763E-22  -2.13957531099155E-10  -2.13909949142734E-10  -4.33864659564602E-18
      5.40058924687078E-07
      0.00000000000000E+00  -3.73899925171841E-13   0.00000000000000E+00   5.00503514760735E-15   2.20880252717114E-22
      3.73867555493370E-10   3.73872560528738E-10  -1.20685001784772E-18  -4.12053236918522E-02  -4.12053236918245E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.77128093742008E-11   0.00000000000000E+00  -2.77128093742008E-11
      5.53252765427502E-18  -5.40902191251887E-01  -5.40793149458566E-01   0.00000000000000E+00   2.93532412832850E-13
     -1.44013331593764E-22  -3.46453283567225E-10  -3.46159751154536E-10  -4.32567763642731E-18
      5.42058924687078E-07
      0.00000000000000E+00  -6.23625765639107E-13   0.00000000000000E+00   7.53436828126952E-15   2.59102824081248E-22
      6.23644764368777E-10   6.23652298737318E-10  -1.15764045847139E-18  -6.09278283120056E-02  -6.09278283119699E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.56925568466352E-11   0.00000000000000E+00  -3.56925568466352E-11
      5.46114254058175E-18  -5.50611550792119E-01  -5.50426339738053E-01   0.00000000000000E+00   3.49130150166356E-13
     -1.42674143050446E-22  -5.88308872040706E-10  -5.87959741890682E-10  -4.30350208211036E-18
      5.44058924687078E-07
      0.00000000000000E+00  -1.01956842774075E-12   0.00000000000000E+00   1.10033723243865E-14   2.84682285952348E-22
      1.01951656137523E-09   1.01952756474784E-09  -1.10773759172659E-18  -8.08394597831987E-02  -8.08394597831583E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.04680571083902E-11   0.00000000000000E+00  -4.04680571083902E-11
      5.38020642636497E-18  -5.59372193239187E-01  -5.59063781234815E-01   0.00000000000000E+00   3.29234783211610E-13
     -1.41379934435340E-22  -9.79388742422524E-10  -9.79059507639454E-10  -4.27246883463838E-18
      5.46058924687078E-07
      0.00000000000000E+00  -1.61977378539194E-12   0.00000000000000E+00   1.59182601280534E-14   3.03734255268340E-22
      1.61972927643572E-09   1.61974519469616E-09  -1.05990042562977E-18  -1.00510203916383E-01  -1.00510203916338E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48075687986990E-11   0.00000000000000E+00  -4.48075687986990E-11
      5.29059128876757E-18  -5.66805682150970E-01  -5.66309560617928E-01   0.00000000000000E+00   2.99846042751085E-13
     -1.40170097894746E-22  -1.57523747194007E-09  -1.57493762589746E-09  -4.23069086313780E-18
      5.48058924687078E-07
      0.00000000000000E+00  -2.48853315463794E-12   0.00000000000000E+00   2.24375450699335E-14   3.19932827354870E-22
      2.48855639844806E-09   2.48857883599345E-09  -1.01532564119513E-18  -1.19851394495664E-01  -1.19851394495615E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.97505326620329E-11   0.00000000000000E+00  -4.97505326620329E-11
      5.19109022344351E-18  -5.72418311388573E-01  -5.71650051396976E-01   0.00000000000000E+00   2.75697721700427E-13
     -1.39025557216298E-22  -2.43910400105298E-09  -2.43882830333142E-09  -4.17576458224838E-18
      5.50058924687078E-07
      0.00000000000000E+00  -3.68389240939390E-12   0.00000000000000E+00   3.03930383831309E-14   3.34031413000820E-22
      3.68390568380019E-09   3.68393607683891E-09  -9.74326741271063E-19  -1.38827327381691E-01  -1.38827327381636E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55228911074648E-11   0.00000000000000E+00  -5.55228911074648E-11
      5.08004444122858E-18  -5.75614060451220E-01  -5.74471061416126E-01   0.00000000000000E+00   2.62327430244063E-13
     -1.37903137460736E-22  -3.62867551316155E-09  -3.62841318573144E-09  -4.10571769995752E-18
      5.52058924687078E-07
      0.00000000000000E+00  -5.24901857614736E-12   0.00000000000000E+00   3.94259622685683E-14   3.45635538358811E-22
      5.24900029930777E-09   5.24903972527038E-09  -9.36644072851466E-19  -1.57426342481559E-01  -1.57426342481497E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19145514383774E-11   0.00000000000000E+00  -6.19145514383774E-11
      4.95621533835183E-18  -5.75724093306355E-01  -5.74090070841899E-01   0.00000000000000E+00   2.67648074497748E-13
     -1.36724590172504E-22  -5.18739282190637E-09  -5.18712517383201E-09  -4.01957126550036E-18
      5.54058924687078E-07
      0.00000000000000E+00  -7.21201614448383E-12   0.00000000000000E+00   4.91648936477933E-14   3.54117498466939E-22
      7.21193070659834E-09   7.21197987149234E-09  -9.01739714219128E-19  -1.75648552057482E-01  -1.75648552057413E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.84572521047908E-11   0.00000000000000E+00  -6.84572521047908E-11
      4.81930083414224E-18  -5.72036804054693E-01  -5.69786474432652E-01   0.00000000000000E+00   3.00970195957970E-13
     -1.35367788370799E-22  -7.14382358958337E-09  -7.14352261938755E-09  -3.91756111992311E-18
      5.56058924687078E-07
      0.00000000000000E+00  -9.59244804342851E-12   0.00000000000000E+00   5.94060366725010E-14   3.58901160721942E-22
      9.59240165088252E-09   9.59246105691955E-09  -8.69016950146848E-19  -1.93499180530434E-01  -1.93499180530360E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.46666308428487E-11   0.00000000000000E+00  -7.46666308428487E-11
      4.66996757245655E-18  -5.63814536277043E-01  -5.60816250894307E-01   0.00000000000000E+00   3.69436669595521E-13
     -1.33670392065843E-22  -9.51816386274617E-09  -9.51779442607670E-09  -3.80095062230970E-18
      5.58058924687078E-07
      0.00000000000000E+00  -1.24089587546345E-11   0.00000000000000E+00   7.01220198561706E-14   3.59450580759904E-22
      1.24089077138499E-08   1.24089778358701E-08  -8.37939356236971E-19  -2.10985435970835E-01  -2.10985435970755E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.02354271568648E-11   0.00000000000000E+00  -8.02354271568648E-11
      4.50949671814281E-18  -5.50296233928047E-01  -5.46412413535023E-01   0.00000000000000E+00   4.73279314881990E-13
     -1.31452445234126E-22  -1.23292156880280E-08  -1.23287424087132E-08  -3.67155736190585E-18
      5.60058924687078E-07
      0.00000000000000E+00  -1.56794580018573E-11   0.00000000000000E+00   8.12989542609547E-14   3.55126776101409E-22
      1.56793477696621E-08   1.56794290686167E-08  -8.08075241220539E-19  -2.28115016009445E-01  -2.28115016009360E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.51135951538951E-11   0.00000000000000E+00  -8.51135951538951E-11
      4.33926952783502E-18  -5.30698652931410E-01  -5.25786053517934E-01   0.00000000000000E+00   6.01915946530592E-13
     -1.28559163711529E-22  -1.55949173894093E-08  -1.55943154734629E-08  -3.53119428661448E-18
      5.62058924687078E-07
      0.00000000000000E+00  -1.94121199667084E-11   0.00000000000000E+00   9.27026495194401E-14   3.44987414918950E-22
      1.94120657533461E-08   1.94121584559960E-08  -7.79103302592211E-19  -2.44895364426859E-01  -2.44895364426770E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94724582133339E-11   0.00000000000000E+00  -8.94724582133339E-11
      4.16032461140836E-18  -5.04234288917344E-01  -4.98147079827517E-01   0.00000000000000E+00   7.34522442651773E-13
     -1.24910176895625E-22  -1.93234205202252E-08  -1.93226859977827E-08  -3.38122130881615E-18
      5.64058924687078E-07
      0.00000000000000E+00  -2.35900452175416E-11   0.00000000000000E+00   1.03707002041399E-13   3.27761001523646E-22
      2.35899827646483E-08   2.35900864716506E-08  -7.50798675707081E-19  -2.61333449862668E-01  -2.61333449862575E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.35543839330650E-11   0.00000000000000E+00  -9.35543839330650E-11
      3.97321584354222E-18  -4.70158810595547E-01  -4.62756606317292E-01   0.00000000000000E+00   8.47882043028796E-13
     -1.20520159501896E-22  -2.34973799697605E-08  -2.34965320877176E-08  -3.22241716783514E-18
      5.66058924687078E-07
      0.00000000000000E+00  -2.81596882725649E-11   0.00000000000000E+00   1.13412378879991E-13   3.02781183182191E-22
      2.81595657238246E-08   2.81596791362038E-08  -7.22998950143572E-19  -2.77436134770437E-01  -2.77436134770339E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.74010842841711E-11   0.00000000000000E+00  -9.74010842841711E-11
      3.77841367497389E-18  -4.27839045722247E-01  -4.18998328606143E-01   0.00000000000000E+00   9.30763261350337E-13
     -1.15433772449481E-22  -2.80632088151809E-08  -2.80622780519196E-08  -3.05541472483031E-18
      5.68058924687078E-07
      0.00000000000000E+00  -3.30318678919498E-11   0.00000000000000E+00   1.20939849082402E-13   2.72578862217673E-22
      3.30317835605647E-08   3.30319045004141E-08  -6.95563338554295E-19  -2.93210794385834E-01  -2.93210794385734E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00725626257583E-10   0.00000000000000E+00  -1.00725626257583E-10
      3.57696242245872E-18  -3.76824959354670E-01  -3.66450159775931E-01   0.00000000000000E+00   9.86394517041909E-13
     -1.09593851690376E-22  -3.29321652686734E-08  -3.29311788741564E-08  -2.88139908390442E-18
      5.70058924687079E-07
      0.00000000000000E+00  -3.80240885828649E-11   0.00000000000000E+00   1.23966269882257E-13   2.43959534769619E-22
      3.80239586738203E-08   3.80240826400904E-08  -6.68408307708106E-19  -3.08664354731932E-01  -3.08664354731829E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03715275483438E-10   0.00000000000000E+00  -1.03715275483438E-10
      3.36953187149184E-18  -3.17057384413579E-01  -3.05110539176104E-01   0.00000000000000E+00   9.95508209843327E-13
     -1.02762036794901E-22  -3.79213628728168E-08  -3.79203673646070E-08  -2.70112356378373E-18
      5.72058924687079E-07
      0.00000000000000E+00  -4.25848226983791E-11   0.00000000000000E+00   1.13341906148259E-13   2.19167700901745E-22
      4.25847206311480E-08   4.25848339730544E-08  -6.41677736344491E-19  -3.23799233660608E-01  -3.23799233660500E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08626682120674E-10   0.00000000000000E+00  -1.08626682120674E-10
      3.15227850725049E-18  -2.49581783393018E-01  -2.36199373816145E-01   0.00000000000000E+00   8.93331026398628E-13
     -9.46291869148696E-23  -4.24771006219599E-08  -4.24762072909336E-08  -2.51060077090600E-18
      5.74058924687079E-07
      0.00000000000000E+00  -4.56922975370585E-11   0.00000000000000E+00   7.73648321394784E-14   1.81094060413480E-22
      4.56922478149692E-08   4.56923251798016E-08  -6.15757781340465E-19  -3.38611907820450E-01  -3.38611907820332E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18488482025107E-10   0.00000000000000E+00  -1.18488482025107E-10
      2.91530154320028E-18  -1.77376056280455E-01  -1.63017512872856E-01   0.00000000000000E+00   6.77845888752117E-13
     -8.63303398308975E-23  -4.55745145436651E-08  -4.55738366977764E-08  -2.29954376185981E-18
      5.76058924687079E-07
      0.00000000000000E+00  -4.62475908182152E-11   0.00000000000000E+00   1.40941174860792E-14   1.17492147495280E-22
      4.62476087824117E-08   4.62476228765293E-08  -5.90680034382509E-19  -3.53108388221295E-01  -3.53108388221167E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28477408709646E-10   0.00000000000000E+00  -1.28477408709646E-10
      2.65834672578099E-18  -1.05486894376504E-01  -9.09564038444600E-02   0.00000000000000E+00   4.89124772461656E-13
     -7.64817460002665E-23  -4.61196345925920E-08  -4.61191454678196E-08  -2.06766669139848E-18
      5.78058924687079E-07
      0.00000000000000E+00  -3.82896117181319E-11   0.00000000000000E+00  -1.96822001486894E-13   5.12834122742048E-23
      3.82897685449642E-08   3.82895717229627E-08  -5.63894868052019E-19  -3.67331302798591E-01  -3.67331302798471E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19829997808922E-10   0.00000000000000E+00  -1.19829997808922E-10
      2.41868673016314E-18  -5.04920269518976E-02  -3.84660396366104E-02   0.00000000000000E+00   4.73533334601008E-13
     -4.48899730538929E-23  -3.81702152584884E-08  -3.81697417251538E-08  -1.85479186211113E-18
      5.80058924687079E-07
      0.00000000000000E+00  -2.43709091732800E-11   0.00000000000000E+00  -3.42926801759721E-13   1.99667086964823E-23
      2.43712516219216E-08   2.43709086951198E-08  -5.31822224549689E-19  -3.81337699353992E-01  -3.81337699353907E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.47475141185947E-11   0.00000000000000E+00  -8.47475141185947E-11
      2.24919170192596E-18  -2.36661169071754E-02  -1.60143540071713E-02   0.00000000000000E+00   4.59974589258506E-13
     -1.89938209900023E-23  -2.42866211555905E-08  -2.42861611810013E-08  -1.71736947737627E-18
      5.82058924687079E-07
      0.00000000000000E+00  -1.61718376380269E-11   0.00000000000000E+00  -2.02099822512735E-13   9.59657857266604E-24
      1.61720390338791E-08   1.61718369340566E-08  -4.97925491977486E-19  -3.95106518102612E-01  -3.95106518102549E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25638437838189E-11   0.00000000000000E+00  -6.25638437838189E-11
      2.12406401435832E-18  -1.33171748588093E-02  -8.24167082578351E-03   0.00000000000000E+00   2.60557963458023E-13
     -1.00077976397871E-23  -1.61095336482362E-08  -1.61092730902728E-08  -1.62613852238083E-18
      5.84058924687079E-07
      0.00000000000000E+00  -1.29060224724017E-11   0.00000000000000E+00  -8.02564861718080E-14   6.09481821979153E-24
      1.29060879663828E-08   1.29060077098967E-08  -4.64243855832979E-19  -4.08614217947378E-01  -4.08614217947323E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47673847912711E-11   0.00000000000000E+00  -5.47673847912711E-11
      2.01452924477578E-18  -9.51746737344084E-03  -5.46845903330958E-03   0.00000000000000E+00   1.19636549706749E-13
     -6.74398306550331E-24  -1.28513599616551E-08  -1.28512403251054E-08  -1.55028538894280E-18
      5.86058924687079E-07
      0.00000000000000E+00  -1.17736687073701E-11   0.00000000000000E+00  -2.76363185522979E-14   4.65729225263459E-24
      1.17737232327913E-08   1.17736955964727E-08  -4.31248499552585E-19  -4.21854411579609E-01  -4.21854411579556E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28339936313928E-11   0.00000000000000E+00  -5.28339936313928E-11
      1.90886125751299E-18  -7.98647276510125E-03  -4.29360738614165E-03   0.00000000000000E+00   5.95276716063675E-14
     -5.30275700003098E-24  -1.17209211305129E-08  -1.17208616028413E-08  -1.47761275796041E-18
      5.88058924687079E-07
      0.00000000000000E+00  -1.13878289663612E-11   0.00000000000000E+00  -9.24947738079647E-15   3.89259211639265E-24
      1.13878738709067E-08   1.13878646214293E-08  -3.99075355156956E-19  -4.34828541788683E-01  -4.34828541788630E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28223431481000E-11   0.00000000000000E+00  -5.28223431481000E-11
      1.80321657121679E-18  -7.22897524013280E-03  -3.65766688416740E-03   0.00000000000000E+00   3.71077579401968E-14
     -4.48627427729719E-24  -1.13350793860392E-08  -1.13350422782812E-08  -1.40414121605983E-18
      5.90058924687079E-07
      0.00000000000000E+00  -1.12425305920989E-11   0.00000000000000E+00  -3.33938848752200E-15   3.39762959268493E-24
      1.12424934884803E-08   1.12424901490918E-08  -3.67802469078518E-19  -4.47540667952192E-01  -4.47540667952139E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33656466504992E-11   0.00000000000000E+00  -5.33656466504992E-11
      1.69648527791579E-18  -6.76405687524375E-03  -3.23872060971020E-03   0.00000000000000E+00   2.83484600922337E-14
     -3.92402681126803E-24  -1.11891528509014E-08  -1.11891245024413E-08  -1.32868280883727E-18
      5.92058924687079E-07
      0.00000000000000E+00  -1.11753002444630E-11   0.00000000000000E+00  -1.43162536244381E-15   3.04075485565433E-24
      1.11752810954744E-08   1.11752796638490E-08  -3.37483390156391E-19  -4.59995574904803E-01  -4.59995574904749E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40179411051493E-11   0.00000000000000E+00  -5.40179411051493E-11
      1.58844939570549E-18  -6.43558163288561E-03  -2.93162506065165E-03   0.00000000000000E+00   2.41402521304214E-14
     -3.49628767497252E-24  -1.11212858629960E-08  -1.11212617227438E-08  -1.25096600554910E-18
      5.94058924687079E-07
      0.00000000000000E+00  -1.11367254548359E-11   0.00000000000000E+00  -7.43161916916461E-16   2.76867720507552E-24
      1.11366931206117E-08   1.11366923774498E-08  -3.08148465401203E-19  -4.72198096485348E-01  -4.72198096485294E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46289634705758E-11   0.00000000000000E+00  -5.46289634705758E-11
      1.47919146876434E-18  -6.18633015117555E-03  -2.69472218910510E-03   0.00000000000000E+00   2.15021764070935E-14
     -3.15649681817843E-24  -1.10820849161556E-08  -1.10820634139792E-08  -1.17104300336314E-18
      5.96058924687079E-07
      0.00000000000000E+00  -1.11111007731550E-11   0.00000000000000E+00  -4.39053315350471E-16   2.55422840581257E-24
      1.11110689727924E-08   1.11110685337391E-08  -2.79807410417966E-19  -4.84152716428024E-01  -4.84152716427969E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51423500008614E-11   0.00000000000000E+00  -5.51423500008614E-11
      1.36890676876262E-18  -5.99023462718784E-03  -2.50686029340500E-03   0.00000000000000E+00   1.95161001831497E-14
     -2.88074980458195E-24  -1.10559456998384E-08  -1.10559261837382E-08  -1.08909935834465E-18
      5.98058924687079E-07
      0.00000000000000E+00  -1.10927318257135E-11   0.00000000000000E+00  -2.74201991240812E-16   2.38114025991135E-24
      1.10926898703628E-08   1.10926895961608E-08  -2.52454877200491E-19  -4.95862866175410E-01  -4.95862866175354E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55321888138370E-11   0.00000000000000E+00  -5.55321888138370E-11
      1.25784239113494E-18  -5.83254355017369E-03  -2.35508140556914E-03   0.00000000000000E+00   1.78865164944887E-14
     -2.65378427987521E-24  -1.10371752938634E-08  -1.10371574073469E-08  -1.00538751393445E-18
      6.00058924687079E-07
      0.00000000000000E+00  -1.10789551151323E-11   0.00000000000000E+00  -1.72787488763769E-16   2.23878064426018E-24
      1.10789238707770E-08   1.10789236979895E-08  -2.26080139283994E-19  -5.07328550002734E-01  -5.07328550002678E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57749945037884E-11   0.00000000000000E+00  -5.57749945037884E-11
      1.14629240212737E-18  -5.70367265413738E-03  -2.23062306320532E-03   0.00000000000000E+00   1.64970570012724E-14
     -2.46480260426483E-24  -1.10231652005428E-08  -1.10231487034858E-08  -9.20212262843374E-19
      6.02058924687079E-07
      0.00000000000000E+00  -1.10682092808790E-11   0.00000000000000E+00  -1.08775452224229E-16   2.11992489155466E-24
      1.10682076424452E-08   1.10682075336697E-08  -2.00692992758818E-19  -5.18536330285230E-01  -5.18536330285174E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58027896465273E-11   0.00000000000000E+00  -5.58027896465273E-11
      1.03468682283431E-18  -5.59699720877493E-03  -2.12733164334886E-03   0.00000000000000E+00   1.52753204369664E-14
     -2.30596728757664E-24  -1.10124200193436E-08  -1.10124047440232E-08  -8.33993830075495E-19
      6.04058924687079E-07
      0.00000000000000E+00  -1.10593003413699E-11   0.00000000000000E+00  -7.58979537703704E-17   2.01972606259483E-24
      1.10592626366823E-08   1.10592625607843E-08  -1.76397343331157E-19  -5.29426555544316E-01  -5.29426555544261E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53772808816412E-11   0.00000000000000E+00  -5.53772808816412E-11
      9.23932261071030E-19  -5.50794804184913E-03  -2.04096575511488E-03   0.00000000000000E+00   1.41319826883699E-14
     -2.17185017766926E-24  -1.10038994118854E-08  -1.10038852799027E-08  -7.47534917739873E-19
      6.06058924687079E-07
      0.00000000000000E+00  -1.10509424702840E-11   0.00000000000000E+00  -7.25069069804662E-17   1.93508228533251E-24
      1.10509171397956E-08   1.10509170672887E-08  -1.53448673169788E-19  -5.39864948877978E-01  -5.39864948877924E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40939214002159E-11   0.00000000000000E+00  -5.40939214002159E-11
      8.15744418270598E-19  -5.43346347681249E-03  -1.96870556983608E-03   0.00000000000000E+00   1.29610128242287E-14
     -2.05888682681349E-24  -1.09968361069013E-08  -1.09968231458885E-08  -6.62295745100810E-19
      6.07058924687079E-07
      0.00000000000000E+00  -1.10461665439492E-11   0.00000000000000E+00  -1.06698781582807E-16   1.89695409083962E-24
      1.10461982052419E-08   1.10461980985431E-08  -1.42413971421851E-19  -5.44937572254221E-01  -5.44937572254168E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.32603073307882E-11   0.00000000000000E+00  -5.32603073307882E-11
      7.62484110939810E-19  -5.40017244467071E-03  -1.93663839580088E-03   0.00000000000000E+00   1.22594183844889E-14
     -2.00914202303573E-24  -1.09929500506307E-08  -1.09929377912123E-08  -6.20070139517960E-19
      6.08408924687079E-07
      0.00000000000000E+00  -1.10402884807680E-11   0.00000000000000E+00  -9.43586376848452E-17   1.85148486989354E-24
      1.10402506079698E-08   1.10402505136112E-08  -1.28347221060032E-19  -5.51454801368864E-01  -5.51454801368813E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.11552180764164E-11   0.00000000000000E+00  -5.11552180764164E-11
      6.93424566536648E-19  -5.36052851592860E-03  -1.89820471158866E-03   0.00000000000000E+00   1.13773297766963E-14
     -1.94853392890797E-24  -1.09891066728645E-08  -1.09890952955347E-08  -5.65077345476615E-19
      6.10231424687079E-07
      0.00000000000000E+00  -1.10315632307332E-11   0.00000000000000E+00  -1.12820406113358E-16   1.79938849520104E-24
      1.10316041648834E-08   1.10316040520630E-08  -1.11232597697346E-19  -5.59461186076055E-01  -5.59461186076008E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70663647953007E-11   0.00000000000000E+00  -4.70663647953007E-11
      6.07646116697213E-19  -5.31543455523925E-03  -1.85454620305382E-03   0.00000000000000E+00   1.00775475733409E-14
     -1.87983154868951E-24  -1.09845477648152E-08  -1.09845376872677E-08  -4.96413518999867E-19
      6.12231424687079E-07
      0.00000000000000E+00  -1.10200826385823E-11   0.00000000000000E+00  -1.98434246822848E-16   1.75366394177857E-24
      1.10200431197829E-08   1.10200429213486E-08  -9.54184975068034E-20  -5.66934433135996E-01  -5.66934433135956E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04824248817757E-11   0.00000000000000E+00  -4.04824248817757E-11
      5.26681266933661E-19  -5.27596735435453E-03  -1.81664668262866E-03   0.00000000000000E+00   8.38471433832125E-15
     -1.82081442986602E-24  -1.09795688811812E-08  -1.09795604964668E-08  -4.31262769426857E-19
      6.14231424687079E-07
      0.00000000000000E+00  -1.10053874806291E-11   0.00000000000000E+00  -2.97595577199258E-16   1.72000175269148E-24
      1.10053612693658E-08   1.10053609717702E-08  -8.35198998179974E-20  -5.72604773677447E-01  -5.72604773677416E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.09957110540743E-11   0.00000000000000E+00  -3.09957110540743E-11
      4.64689844825513E-19  -5.24677590139281E-03  -1.78909174634754E-03   0.00000000000000E+00   6.26483547800276E-15
     -1.77894171874473E-24  -1.09743715255516E-08  -1.09743652607161E-08  -3.81169945007516E-19
      6.16231424687079E-07
      0.00000000000000E+00  -1.09866511542388E-11   0.00000000000000E+00  -4.23929626265701E-16   1.69949178773816E-24
      1.09866803033093E-08   1.09866798793797E-08  -7.66865579453648E-20  -5.75879181009744E-01  -5.75879181009725E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80091107447154E-11   0.00000000000000E+00  -1.80091107447154E-11
      4.28671623336082E-19  -5.22859428559472E-03  -1.77270409315881E-03   0.00000000000000E+00   3.63554883018205E-15
     -1.75581713756834E-24  -1.09686744041838E-08  -1.09686707686350E-08  -3.51985065390717E-19
      6.18231424687079E-07
      0.00000000000000E+00  -1.09632307462508E-11   0.00000000000000E+00  -5.75325205475262E-16   1.69406484829620E-24
      1.09632522331535E-08   1.09632516578283E-08  -7.62436035714704E-20  -5.76090678805673E-01  -5.76090678805672E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17663815273410E-12   0.00000000000000E+00  -1.17663815273410E-12
      4.26318347030614E-19  -5.22294463479203E-03  -1.76913254362823E-03   0.00000000000000E+00   3.89873409189999E-16
     -1.75445816837478E-24  -1.09620754095490E-08  -1.09620750196755E-08  -3.50074743459144E-19
      6.20231424687080E-07
      0.00000000000000E+00  -1.09343914987677E-11   0.00000000000000E+00  -5.53078567181035E-16   1.70692083141342E-24
      1.09344074201348E-08   1.09344068670562E-08  -8.36709943945704E-20  -5.72528605778931E-01  -5.72528605778951E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95689789183755E-11   0.00000000000000E+00   1.95689789183755E-11
      4.65456304867365E-19  -5.23251147402661E-03  -1.78125145042075E-03   0.00000000000000E+00  -3.79355171698298E-15
     -1.78004938918536E-24  -1.09539720524229E-08  -1.09539758459746E-08  -3.81785310472794E-19
      6.22231424687080E-07
      0.00000000000000E+00  -1.08993068091544E-11   0.00000000000000E+00  -9.58090005547834E-16   1.74342299404093E-24
      1.08992857944834E-08   1.08992848363934E-08  -1.00632003230210E-19  -5.64455880443774E-01  -5.64455880443818E-01
      0.00000000000000E+00   0.00000000000000E+00   4.40244427868252E-11   0.00000000000000E+00   4.40244427868252E-11
      5.53505190441015E-19  -5.26201135747010E-03  -1.81411245599225E-03   0.00000000000000E+00  -8.50193013169372E-15
     -1.84177086547976E-24  -1.09433007772501E-08  -1.09433092791802E-08  -4.52873187210805E-19
      6.24231424687080E-07
      0.00000000000000E+00  -1.08563234721413E-11   0.00000000000000E+00  -4.02158945337176E-15   1.81296845848405E-24
      1.08562688602773E-08   1.08562648386878E-08  -1.29062637450371E-19  -5.51112000899234E-01  -5.51112000899306E-01
      0.00000000000000E+00   0.00000000000000E+00   7.16934930744175E-11   0.00000000000000E+00   7.16934930744175E-11
      6.96892176589851E-19  -5.32020408921425E-03  -1.87714176103649E-03   0.00000000000000E+00  -1.18342190958753E-14
     -1.95696696101206E-24  -1.09279464975431E-08  -1.09279583317622E-08  -5.67829539139479E-19
      6.26231424687080E-07
      0.00000000000000E+00  -1.08016758535028E-11   0.00000000000000E+00  -1.58730370587878E-15   1.93293468808863E-24
      1.08017057305286E-08   1.08017041432249E-08  -1.71310262563359E-19  -5.31714037535476E-01  -5.31714037535577E-01
      0.00000000000000E+00   0.00000000000000E+00   1.01619942821036E-10   0.00000000000000E+00   1.01619942821036E-10
      9.00132062231923E-19  -5.42468196777260E-03  -1.98938317849704E-03   0.00000000000000E+00  -2.25420520248699E-14
     -2.16153440496521E-24  -1.09033015439939E-08  -1.09033240860460E-08  -7.28821799668566E-19
      6.28231424687080E-07
      0.00000000000000E+00  -1.07262713242554E-11   0.00000000000000E+00  -2.36839786012395E-15   2.13726201577193E-24
      1.07263036589550E-08   1.07263012905572E-08  -2.30277676878279E-19  -5.05473791589633E-01  -5.05473791589765E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32007770520910E-10   0.00000000000000E+00   1.32007770520910E-10
      1.16414760327374E-18  -5.61436067753624E-03  -2.19324697064278E-03   0.00000000000000E+00  -3.30339462700624E-14
     -2.54000439091967E-24  -1.08582760271318E-08  -1.08583090610781E-08  -9.33869926395464E-19
      6.30231424687080E-07
      0.00000000000000E+00  -1.06027401527113E-11   0.00000000000000E+00  -3.56892004964095E-15   2.49401747506574E-24
      1.06027604401287E-08   1.06027568712086E-08  -3.09412101814196E-19  -4.71644347889357E-01  -4.71644347889517E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59725873161182E-10   0.00000000000000E+00   1.59725873161182E-10
      1.48359934959611E-18  -5.98685663623430E-03  -2.59593840810011E-03   0.00000000000000E+00  -4.83187337226858E-14
     -3.33168707879508E-24  -1.07624344256361E-08  -1.07624827443698E-08  -1.17418724778191E-18
      6.32231424687080E-07
      0.00000000000000E+00  -1.03373088621816E-11   0.00000000000000E+00  -4.39029371731181E-14   3.11797372049047E-24
      1.03373865109546E-08   1.03373426080174E-08  -4.11952623813396E-19  -4.29587984663368E-01  -4.29587984663548E-01
      0.00000000000000E+00   0.00000000000000E+00   1.80447679878640E-10   0.00000000000000E+00   1.80447679878640E-10
      1.84449470935339E-18  -6.82938063541805E-03  -3.51555124705413E-03   0.00000000000000E+00  -3.44314821960157E-14
     -5.39378846196508E-24  -1.05177558564138E-08  -1.05177902878960E-08  -1.43254208553999E-18
      6.34231424687080E-07
      0.00000000000000E+00  -9.57279326966610E-12   0.00000000000000E+00  -2.03217832461960E-14   3.89432637169281E-24
      9.57285786882370E-09   9.57283754704045E-09  -5.37869219458041E-19  -3.78847361557154E-01  -3.78847361557346E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92237594860090E-10   0.00000000000000E+00   1.92237594860090E-10
      2.22896989907357E-18  -9.12543370242988E-03  -6.04878057348461E-03   0.00000000000000E+00  -1.04737827625450E-13
     -1.24076934939147E-23  -9.76497040407290E-09  -9.76507514190054E-09  -1.69110067961553E-18
      6.36231424687080E-07
      0.00000000000000E+00  -7.23185460772066E-12   0.00000000000000E+00  -5.95286057286677E-14   1.75583464380242E-24
      7.23187567367995E-09   7.23181614507423E-09  -6.78177449823769E-19  -3.19342454123328E-01  -3.19342454123535E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06475649139518E-10   0.00000000000000E+00   2.06475649139518E-10
      2.64192119735260E-18  -1.59216119980432E-02  -1.35780622881712E-02   0.00000000000000E+00  -1.51727492432072E-13
     -3.59306116413397E-23  -7.43814006672127E-09  -7.43829179421374E-09  -1.96374374752883E-18
      6.38231424687080E-07
      0.00000000000000E+00  -3.21998464175868E-12   0.00000000000000E+00  -1.01455800220215E-13  -1.31508829274620E-23
      3.22006174393344E-09   3.21996028813321E-09  -8.20968238526023E-19  -2.52063480079675E-01  -2.52063480079909E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33503388016585E-10   0.00000000000000E+00   2.33503388016585E-10
      3.10892797338577E-18  -3.03673296423378E-02  -2.92792695870522E-02   0.00000000000000E+00  -2.47172766191994E-13
     -7.08900532848716E-23  -3.45321650338353E-09  -3.45346367614979E-09  -2.28795973485975E-18
      6.40231424687080E-07
      0.00000000000000E+00  -7.83711142591826E-13   0.00000000000000E+00  -6.34964443996633E-14  -3.28304736329070E-23
      7.83763683523023E-10   7.83700187078591E-10  -9.66472541576481E-19  -1.79927995694973E-01  -1.79927995695218E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44880169609848E-10   0.00000000000000E+00   2.44880169609848E-10
      3.59868831260547E-18  -4.92615967974838E-02  -4.89375314261056E-02   0.00000000000000E+00  -4.54724738779570E-13
     -8.60824884384667E-23  -1.02812563194957E-09  -1.02858035668844E-09  -2.63221577102899E-18
      6.42231424687080E-07
      0.00000000000000E+00  -8.44053134937171E-14   0.00000000000000E+00  -2.15854570114649E-14  -4.27837191292749E-23
      8.44483965162673E-11   8.44268110592130E-11  -1.11271330336526E-18  -1.07840408184530E-01  -1.07840408184760E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30517892969865E-10   0.00000000000000E+00   2.30517892969865E-10
      4.05972409854520E-18  -6.91725470492293E-02  -6.90733208053911E-02   0.00000000000000E+00  -6.99334517759100E-13
     -9.32405099676615E-23  -3.14245369511225E-10  -3.14944704029077E-10  -2.94701079517994E-18
      6.44231424687080E-07
      0.00000000000000E+00   2.70941974762204E-14   0.00000000000000E+00  -6.70742146835863E-15  -4.54497841122640E-23
     -2.70682351627613E-11  -2.70749425842751E-11  -1.22689562118296E-18  -5.18759668409173E-02  -5.18759668410970E-02
      0.00000000000000E+00   0.00000000000000E+00   1.79687198768568E-10   0.00000000000000E+00   1.79687198768568E-10
      4.41909849608233E-18  -8.90028056006419E-02  -8.89547237433840E-02   0.00000000000000E+00  -7.65722354277409E-13
     -9.97523434100772E-23  -1.51846533829915E-10  -1.52612256184293E-10  -3.19220287489937E-18
      6.46231424687080E-07
      0.00000000000000E+00   1.46033132159968E-14   0.00000000000000E+00  -1.50183708376182E-15  -4.60034940036020E-23
     -1.46061833250046E-11  -1.46076851621343E-11  -1.28540309398428E-18  -2.42346391754730E-02  -2.42346391755848E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11822500940988E-10   0.00000000000000E+00   1.11822500940988E-10
      4.64274349796431E-18  -1.08543979891951E-01  -1.08513351671642E-01   0.00000000000000E+00  -5.34096743266245E-13
     -1.03609987776589E-22  -9.66807190354838E-11  -9.72148157788537E-11  -3.35734040398003E-18
      6.48231424687080E-07
      0.00000000000000E+00  -5.14330528362150E-15   0.00000000000000E+00   1.51921351620455E-16  -4.58393845077099E-23
      5.13161489349134E-12   5.13176681479713E-12  -1.30978184433357E-18  -1.35246759148667E-02  -1.35246759149357E-02
      0.00000000000000E+00   0.00000000000000E+00   6.90063377444059E-11   0.00000000000000E+00   6.90063377444059E-11
      4.78075617345312E-18  -1.27736875210503E-01  -1.27713517670258E-01   0.00000000000000E+00  -3.50018405485968E-13
     -1.05879364022200E-22  -7.37880861536114E-11  -7.41381045592032E-11  -3.47097432911955E-18
      6.50231424687080E-07
      0.00000000000000E+00  -1.88281711275430E-14   0.00000000000000E+00   4.96021663716215E-16  -4.50628420777487E-23
      1.88486373454470E-11   1.88491333670656E-11  -1.31893920959372E-18  -9.59558269285506E-03  -9.59558269290215E-03
      0.00000000000000E+00   0.00000000000000E+00   4.70895233079825E-11   0.00000000000000E+00   4.70895233079825E-11
      4.87493522006909E-18  -1.46557605087847E-01  -1.46536830965542E-01   0.00000000000000E+00  -2.82586085227573E-13
     -1.07604853669086E-22  -6.56560705897128E-11  -6.59386566750480E-11  -3.55599601047537E-18
      6.52231424687080E-07
      0.00000000000000E+00  -2.83800237971258E-14   0.00000000000000E+00   4.66850339081589E-16  -4.34144521137940E-23
      2.83740324344746E-11   2.83744992847702E-11  -1.32176253078600E-18  -8.02111732111217E-03  -8.02111732114770E-03
      0.00000000000000E+00   0.00000000000000E+00   3.55244035499097E-11   0.00000000000000E+00   3.55244035499097E-11
      4.94598402716891E-18  -1.65000519981587E-01  -1.64980388600508E-01   0.00000000000000E+00  -2.70780730755890E-13
     -1.09190785761308E-22  -6.36281221038146E-11  -6.38989028346797E-11  -3.62422149638290E-18
      6.54231424687080E-07
      0.00000000000000E+00  -3.55439132993129E-14   0.00000000000000E+00   3.71682418422798E-16  -4.05025934516157E-23
      3.55144423602093E-11   3.55148140425872E-11  -1.32192424647020E-18  -7.24828562355209E-03  -7.24828562358085E-03
      0.00000000000000E+00   0.00000000000000E+00   2.87665407740222E-11   0.00000000000000E+00   2.87665407740222E-11
      5.00351710871695E-18  -1.83068398384762E-01  -1.83048146615584E-01   0.00000000000000E+00  -2.75997190333764E-13
     -1.10751964770207E-22  -6.40053576261649E-11  -6.42813548166094E-11  -3.68159286224675E-18
      6.56231424687080E-07
      0.00000000000000E+00  -4.12382870061795E-14   0.00000000000000E+00   2.90150703998346E-16  -3.58994885100822E-23
      4.12613273484828E-11   4.12616174991509E-11  -1.32094532619542E-18  -6.77695817504683E-03  -6.77695817507126E-03
      0.00000000000000E+00   0.00000000000000E+00   2.44284477407529E-11   0.00000000000000E+00   2.44284477407529E-11
      5.05237400419846E-18  -2.00767541574936E-01  -2.00746846099059E-01   0.00000000000000E+00  -2.83951399789666E-13
     -1.12309937920535E-22  -6.54061138400021E-11  -6.56900652399041E-11  -3.73142867800304E-18
      6.58231424687080E-07
      0.00000000000000E+00  -4.61979028153860E-14   0.00000000000000E+00   2.43452471491189E-16  -2.92079234034449E-23
      4.61684911389879E-11   4.61687345914302E-11  -1.31948874107620E-18  -6.44510599377845E-03  -6.44510599379991E-03
      0.00000000000000E+00   0.00000000000000E+00   2.14657179843543E-11   0.00000000000000E+00   2.14657179843543E-11
      5.09530544016717E-18  -2.18105489519016E-01  -2.18084181584121E-01   0.00000000000000E+00  -2.90678964238486E-13
     -1.13862550678812E-22  -6.73437736114322E-11  -6.76344525757846E-11  -3.77581669909096E-18
      6.60231424687080E-07
      0.00000000000000E+00  -5.06064502013472E-14   0.00000000000000E+00   1.95871685302090E-16  -2.01635913684780E-23
      5.05656698227686E-11   5.05658656944337E-11  -1.31785781008780E-18  -6.19371445399279E-03  -6.19371445401215E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93629290521795E-11   0.00000000000000E+00   1.93629290521795E-11
      5.13403129827153E-18  -2.35089894765820E-01  -2.35067864123820E-01   0.00000000000000E+00  -2.95560358803710E-13
     -1.15404296809984E-22  -6.96332343876946E-11  -6.99287947466137E-11  -3.81617348818373E-18
      6.62231424687080E-07
      0.00000000000000E+00  -5.46476186384784E-14   0.00000000000000E+00   1.72414029595080E-16  -8.76273025829751E-24
      5.46522627947123E-11   5.46524352087331E-11  -1.31619291156568E-18  -5.99611575462910E-03  -5.99611575464693E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78267469417509E-11   0.00000000000000E+00   1.78267469417509E-11
      5.16968479215502E-18  -2.51727999011786E-01  -2.51705165011683E-01   0.00000000000000E+00  -2.98960142230187E-13
     -1.16931049640487E-22  -7.21802220081364E-11  -7.24791821504835E-11  -3.85349188058935E-18
      6.64231424687081E-07
      0.00000000000000E+00  -5.85050976011945E-14   0.00000000000000E+00   1.57489450195173E-16   4.58824397030233E-24
      5.85467869959315E-11   5.85469444853863E-11  -1.31455619535283E-18  -5.83731380800861E-03  -5.83731380802528E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66724459602706E-11   0.00000000000000E+00   1.66724459602706E-11
      5.20302968407557E-18  -2.68026644512461E-01  -2.68002947363977E-01   0.00000000000000E+00  -3.01375909852099E-13
     -1.18440886231157E-22  -7.49180145356866E-11  -7.52193904456571E-11  -3.88847348872274E-18
      6.66231424687081E-07
      0.00000000000000E+00  -6.23625765639107E-14   0.00000000000000E+00   1.47834711443474E-16   1.86640529629709E-23
      6.23201908019202E-11   6.23203386366503E-11  -1.31297161588060E-18  -5.70759763320954E-03  -5.70759763322532E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57777381940176E-11   0.00000000000000E+00   1.57777381940176E-11
      5.23458516046360E-18  -2.83992858559548E-01  -2.83968254647305E-01   0.00000000000000E+00  -3.03292033874128E-13
     -1.19933773278714E-22  -7.77947847966735E-11  -7.80980768306676E-11  -3.92161354458300E-18
      6.68231424687081E-07
      0.00000000000000E+00  -6.60363660522117E-14   0.00000000000000E+00   1.41464253065250E-16   3.25803647797813E-23
      6.60174150133227E-11   6.60175564776083E-11  -1.31144492746677E-18  -5.60026170177938E-03  -5.60026170179444E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50597472730286E-11   0.00000000000000E+00   1.50597472730286E-11
      5.26470465500966E-18  -2.99634133880117E-01  -2.99608591540098E-01   0.00000000000000E+00  -3.05113919763765E-13
     -1.21411106634734E-22  -8.07721898307517E-11  -8.10773037506368E-11  -3.95325972754289E-18
      6.70231424687081E-07
      0.00000000000000E+00  -6.97101555405128E-14   0.00000000000000E+00   1.37187973606262E-16   4.57069706077509E-23
      6.96682003173362E-11   6.96683375053555E-11  -1.30997379637142E-18  -5.51067580055460E-03  -5.51067580056906E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44597003117576E-11   0.00000000000000E+00   1.44597003117576E-11
      5.29362405563317E-18  -3.14956129889969E-01  -3.14929626604620E-01   0.00000000000000E+00  -3.07100422748069E-13
     -1.22875197449667E-22  -8.38209373942429E-11  -8.41280378171139E-11  -3.98365025926175E-18
      6.72231424687081E-07
      0.00000000000000E+00  -7.32921002916063E-14   0.00000000000000E+00   1.34213442831193E-16   5.75793879589160E-23
      7.32913001971166E-11   7.32914344106170E-11  -1.30855309640366E-18  -5.43573650947125E-03  -5.43573650948518E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39331260639072E-11   0.00000000000000E+00   1.39331260639072E-11
      5.32149030776099E-18  -3.29958348784786E-01  -3.29930870138926E-01   0.00000000000000E+00  -3.09315213114453E-13
     -1.24328184347431E-22  -8.69152452612855E-11  -8.72245604745243E-11  -4.01293721135732E-18
      6.74231424687081E-07
      0.00000000000000E+00  -7.68740450426999E-14   0.00000000000000E+00   1.32040827360005E-16   6.79480764146153E-23
      7.68979155177929E-11   7.68980475586882E-11  -1.30717732959796E-18  -5.37333068562479E-03  -5.37333068563824E-03
      0.00000000000000E+00   0.00000000000000E+00   1.34515327927222E-11   0.00000000000000E+00   1.34515327927222E-11
      5.34839337334644E-18  -3.44638470796488E-01  -3.44610007822538E-01   0.00000000000000E+00  -3.11858256528777E-13
     -1.25772350981061E-22  -9.00377220947552E-11  -9.03495803514098E-11  -4.04121604374847E-18
      6.76231424687081E-07
      0.00000000000000E+00  -8.04559897937934E-14   0.00000000000000E+00   1.30525168998031E-16   7.67697741950016E-23
      8.04989016989858E-11   8.04990322242316E-11  -1.30584017566588E-18  -5.32207108741386E-03  -5.32207108742687E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30109584315764E-11   0.00000000000000E+00   1.30109584315764E-11
      5.37441529020959E-18  -3.59012657484410E-01  -3.58983199043324E-01   0.00000000000000E+00  -3.15331264590050E-13
     -1.27212466968879E-22  -9.31946593910907E-11  -9.35099906558080E-11  -4.06857511454371E-18
      6.78231424687081E-07
      0.00000000000000E+00  -8.41297792820945E-14   0.00000000000000E+00   1.29900715576382E-16   8.41592971896631E-23
      8.41127789984297E-11   8.41129088992294E-11  -1.30453233711540E-18  -5.28124230813752E-03  -5.28124230815015E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26356467053135E-11   0.00000000000000E+00   1.26356467053135E-11
      5.39968658362022E-18  -3.73144464834445E-01  -3.73113986315059E-01   0.00000000000000E+00  -3.21182809621060E-13
     -1.28659372628046E-22  -9.64273727947934E-11  -9.67485556045431E-11  -4.09515424650481E-18
      6.80231424687081E-07
      0.00000000000000E+00  -8.77117240331881E-14   0.00000000000000E+00   1.29738202582272E-16   9.03051889952552E-23
      8.77481970183212E-11   8.77483267566141E-11  -1.30324722417255E-18  -5.25076863239728E-03  -5.25076863240957E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22866929370590E-11   0.00000000000000E+00   1.22866929370590E-11
      5.42425996949433E-18  -3.87056839068917E-01  -3.87025325393833E-01   0.00000000000000E+00  -3.28317867285030E-13
     -1.30118259264030E-22  -9.97067018262575E-11  -1.00035019693673E-10  -4.12101274532179E-18
      6.82231424687081E-07
      0.00000000000000E+00  -9.13855135214891E-14   0.00000000000000E+00   1.29505071041642E-16   9.54123768328684E-23
      9.13991317649384E-11   9.13992612701049E-11  -1.30198190082149E-18  -5.23125023864529E-03  -5.23125023865721E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19167558912389E-11   0.00000000000000E+00   1.19167558912389E-11
      5.44809348127681E-18  -4.00719435054969E-01  -4.00686887960580E-01   0.00000000000000E+00  -3.35154329632372E-13
     -1.31586893755546E-22  -1.02980862831580E-10  -1.03316017161344E-10  -4.14611158045533E-18
      6.84231424687081E-07
      0.00000000000000E+00  -9.50593030097902E-14   0.00000000000000E+00   1.29311569113343E-16   9.96820274759368E-23
      9.50647215308977E-11   9.50648508425665E-11  -1.30073205686692E-18  -5.22409821441490E-03  -5.22409821442643E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15310028455306E-11   0.00000000000000E+00   1.15310028455306E-11
      5.47115548696787E-18  -4.14116764913152E-01  -4.14083184779423E-01   0.00000000000000E+00  -3.42130272626242E-13
     -1.33064850712083E-22  -1.06253723415338E-10  -1.06595853688097E-10  -4.17042343010095E-18
      6.86231424687081E-07
      0.00000000000000E+00  -9.87330924980913E-14   0.00000000000000E+00   1.29693442817335E-16   1.03294314463853E-22
      9.87500199912135E-11   9.87501496847596E-11  -1.29949075499172E-18  -5.23184349533589E-03  -5.23184349534702E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11358364754838E-11   0.00000000000000E+00   1.11358364754838E-11
      5.49342715991884E-18  -4.27246644326760E-01  -4.27212027924766E-01   0.00000000000000E+00  -3.49561143368917E-13
     -1.34552771603649E-22  -1.09536425016739E-10  -1.09885986160243E-10  -4.19393640492712E-18
      6.88231424687081E-07
      0.00000000000000E+00  -1.02498726723600E-13   0.00000000000000E+00   1.30738423258349E-16   1.06402958555075E-22
      1.02467983131318E-10   1.02468113869848E-10  -1.29824682176683E-18  -5.25892625340729E-03  -5.25892625341802E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07316173732535E-11   0.00000000000000E+00   1.07316173732535E-11
      5.51489039466535E-18  -4.40111973495993E-01  -4.40076313402340E-01   0.00000000000000E+00  -3.57437921298695E-13
     -1.36050932024213E-22  -1.12842293321666E-10  -1.13199731243101E-10  -4.21664357289852E-18
      6.90231424687081E-07
      0.00000000000000E+00  -1.06264360949108E-13   0.00000000000000E+00   1.33279149132541E-16   1.09140412352203E-22
      1.06246848847650E-10   1.06246982126908E-10  -1.29698077956162E-18  -5.31353899674241E-03  -5.31353899675272E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03133855288019E-11   0.00000000000000E+00   1.03133855288019E-11
      5.53551716572295E-18  -4.52717240056789E-01  -4.52680521515814E-01   0.00000000000000E+00  -3.65548776855862E-13
     -1.37558349909172E-22  -1.16194818878717E-10  -1.16560367655711E-10  -4.23853638616133E-18
      6.92231424687081E-07
      0.00000000000000E+00  -1.10121839911825E-13   0.00000000000000E+00   1.38775703401224E-16   1.11633423455505E-22
      1.10148537604409E-10   1.10148676380224E-10  -1.29565512236485E-18  -5.41199006034472E-03  -5.41199006035459E-03
      0.00000000000000E+00   0.00000000000000E+00   9.86756328829230E-12   0.00000000000000E+00   9.86756328829230E-12
      5.55525229229953E-18  -4.65067302067948E-01  -4.65029495095901E-01   0.00000000000000E+00  -3.73448826890223E-13
     -1.39071942569473E-22  -1.19642790841487E-10  -1.20016239668516E-10  -4.25959716993468E-18
      6.94231424687081E-07
      0.00000000000000E+00  -1.14346697823371E-13   0.00000000000000E+00   1.51642277891646E-16   1.14038598121921E-22
      1.14317200537153E-10   1.14317352179545E-10  -1.29418939662331E-18  -5.58994517655239E-03  -5.58994517656175E-03
      0.00000000000000E+00   0.00000000000000E+00   9.35963903730213E-12   0.00000000000000E+00   9.35963903730213E-12
      5.57397157037414E-18  -4.77166900594687E-01  -4.77127940670376E-01   0.00000000000000E+00  -3.80198560794083E-13
     -1.40584763456872E-22  -1.23296792655912E-10  -1.23676991216847E-10  -4.27978217375082E-18
      6.96231424687081E-07
      0.00000000000000E+00  -1.19122624158162E-13   0.00000000000000E+00   1.80858689775042E-16   1.16640409526409E-22
      1.19126942836494E-10   1.19127123695300E-10  -1.29238713869927E-18  -5.93557279539982E-03  -5.93557279540851E-03
      0.00000000000000E+00   0.00000000000000E+00   8.69380812243522E-12   0.00000000000000E+00   8.69380812243522E-12
      5.59135918661901E-18  -4.89020215378554E-01  -4.88979950312794E-01   0.00000000000000E+00  -3.83431040488674E-13
     -1.42080950404020E-22  -1.27437500777105E-10  -1.27820931817735E-10  -4.29897204791974E-18
      6.98231424687081E-07
      0.00000000000000E+00  -1.25735445237104E-13   0.00000000000000E+00   2.62331125600029E-16   1.20188924130971E-22
      1.25714712280104E-10   1.25714974611350E-10  -1.28968523294639E-18  -6.70359453945595E-03  -6.70359453946351E-03
      0.00000000000000E+00   0.00000000000000E+00   7.56397677704964E-12   0.00000000000000E+00   7.56397677704964E-12
      5.60648714017311E-18  -5.00629757575895E-01  -5.00587773449654E-01   0.00000000000000E+00  -3.75896283807956E-13
     -1.43518261845207E-22  -1.32903055104448E-10  -1.33278951388399E-10  -4.31680190722672E-18
      7.00231424687081E-07
      0.00000000000000E+00  -1.38226329497328E-13   0.00000000000000E+00   5.21161064339793E-16   1.27250822236748E-22
      1.38228732825495E-10   1.38229253986687E-10  -1.28418213702026E-18  -8.75603667457665E-03  -8.75603667458150E-03
      0.00000000000000E+00   0.00000000000000E+00   4.84937593064322E-12   0.00000000000000E+00   4.84937593064322E-12
      5.61618589203440E-18  -5.11992116794278E-01  -5.11947046000326E-01   0.00000000000000E+00  -3.31273893868718E-13
     -1.44760212724391E-22  -1.42747356023316E-10  -1.43078629917330E-10  -4.33200375501414E-18
      7.02231424687081E-07
      0.00000000000000E+00  -1.72392571738528E-13   0.00000000000000E+00   1.40425727363060E-15   1.46420623979003E-22
      1.72433314046880E-10   1.72434718304300E-10  -1.26966968459562E-18  -1.48669896644176E-02  -1.48669896644146E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.06367375571540E-12   0.00000000000000E+00  -3.06367375571540E-12
      5.61005854452297E-18  -5.23080357116197E-01  -5.23027004438523E-01   0.00000000000000E+00  -1.66942596801174E-13
     -1.45376429617437E-22  -1.69204101951638E-10  -1.69371044548585E-10  -4.34038885992734E-18
      7.04231424687081E-07
      0.00000000000000E+00  -2.63318861573979E-13   0.00000000000000E+00   3.40718452910504E-15   1.87776687791511E-22
      2.63358740770655E-10   2.63362147955372E-10  -1.23747260098163E-18  -2.85688021864924E-02  -2.85688021864740E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.83767631463757E-11   0.00000000000000E+00  -1.83767631463757E-11
      5.57330501823021E-18  -5.33804350058327E-01  -5.33727178809039E-01   0.00000000000000E+00   1.44444568910128E-13
     -1.44838882146178E-22  -2.45129829377761E-10  -2.44985384808996E-10  -4.33583241724859E-18
      7.06231424687081E-07
      0.00000000000000E+00  -4.38374930691525E-13   0.00000000000000E+00   5.73028968154305E-15   2.34244244567812E-22
      4.38338408938879E-10   4.38344139228795E-10  -1.19200683135617E-18  -4.72070167686763E-02  -4.72070167686455E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.07678933047173E-11   0.00000000000000E+00  -3.07678933047173E-11
      5.51176923162078E-18  -5.44002682663912E-01  -5.43874294170530E-01   0.00000000000000E+00   3.26293522270007E-13
     -1.43606937508807E-22  -4.07902539446205E-10  -4.07576245924079E-10  -4.31976240026461E-18
      7.08231424687081E-07
      0.00000000000000E+00  -7.27869542369649E-13   0.00000000000000E+00   8.47571369903078E-15   2.68086224266321E-22
      7.27857103797717E-10   7.27865579511684E-10  -1.14213151661472E-18  -6.70899792710779E-02  -6.70899792710406E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.73392938590776E-11   0.00000000000000E+00  -3.73392938590776E-11
      5.43709064390262E-18  -5.53452368298405E-01  -5.53234847672394E-01   0.00000000000000E+00   3.46427711375996E-13
     -1.42268257872612E-22  -6.90872713363838E-10  -6.90526285652604E-10  -4.29495912728790E-18
      7.10231424687082E-07
      0.00000000000000E+00  -1.18011302837951E-12   0.00000000000000E+00   1.23518295220922E-14   2.91015361838510E-22
      1.18006492195054E-09   1.18007727378035E-09  -1.09267012446262E-18  -8.69440218914918E-02  -8.69440218914500E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.17802698637944E-11   0.00000000000000E+00  -4.17802698637944E-11
      5.35353010417503E-18  -5.61848558075479E-01  -5.61489984245946E-01   0.00000000000000E+00   3.19995433598536E-13
     -1.41000516961651E-22  -1.13861699935002E-09  -1.13829700391656E-09  -4.26085997971241E-18
      7.12231424687082E-07
      0.00000000000000E+00  -1.85645767317574E-12   0.00000000000000E+00   1.77624214036222E-14   3.08971721753275E-22
      1.85644699717522E-09   1.85646475959693E-09  -1.04576000316148E-18  -1.06518932828529E-01  -1.06518932828483E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.62491845852656E-11   0.00000000000000E+00  -4.62491845852656E-11
      5.26103173500450E-18  -5.68777293068396E-01  -5.68207055618420E-01   0.00000000000000E+00   2.91636653025876E-13
     -1.39813773286470E-22  -1.81050721166455E-09  -1.81021557501167E-09  -4.21527173184302E-18
      7.14231424687082E-07
      0.00000000000000E+00  -2.82055187964315E-12   0.00000000000000E+00   2.47550379209760E-14   3.24522837956177E-22
      2.82050606796704E-09   2.82053082300528E-09  -1.00228872633538E-18  -1.25749733318053E-01  -1.25749733318002E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.14470151413494E-11   0.00000000000000E+00  -5.14470151413494E-11
      5.15813770472181E-18  -5.73710862892604E-01  -5.72838567147738E-01   0.00000000000000E+00   2.70133694936772E-13
     -1.38681968403367E-22  -2.76935394155873E-09  -2.76908380786393E-09  -4.15584897838643E-18
      7.16231424687082E-07
      0.00000000000000E+00  -4.12621666378535E-12   0.00000000000000E+00   3.29594638165164E-14   3.37915141331740E-22
      4.12620656500283E-09   4.12623952446699E-09  -9.62359809631707E-19  -1.44609809416456E-01  -1.44609809416398E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74495936094789E-11   0.00000000000000E+00  -5.74495936094789E-11
      5.04323851750285E-18  -5.76027230868918E-01  -5.74745505258451E-01   0.00000000000000E+00   2.61669302697192E-13
     -1.37552433337505E-22  -4.06905160016007E-09  -4.06878993085751E-09  -4.08087870787113E-18
      7.18231424687082E-07
      0.00000000000000E+00  -5.81175128101788E-12   0.00000000000000E+00   4.23718707460871E-14   3.48621978632746E-22
      5.81172444139607E-09   5.81176681326716E-09  -9.25598523348331E-19  -1.63092152514374E-01  -1.63092152514310E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.39434606641758E-11   0.00000000000000E+00  -6.39434606641758E-11
      4.91535159617450E-18  -5.75041582568037E-01  -5.73230928806580E-01   0.00000000000000E+00   2.74557481467489E-13
     -1.36333910312817E-22  -5.74809791008433E-09  -5.74782335260300E-09  -3.98975307282616E-18
      7.20231424687082E-07
      0.00000000000000E+00  -7.90167827617515E-12   0.00000000000000E+00   5.22779026309496E-14   3.56020110083856E-22
      7.90165960679105E-09   7.90171188469404E-09  -8.91430157253350E-19  -1.81198951267206E-01  -1.81198951267136E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.04295615875578E-11   0.00000000000000E+00  -7.04295615875578E-11
      4.77449247299938E-18  -5.70033263783319E-01  -5.67566273561047E-01   0.00000000000000E+00   3.18196034279450E-13
     -1.34890655187961E-22  -7.83160051914062E-09  -7.83128232310648E-09  -3.88306231574603E-18
      7.22231424687082E-07
      0.00000000000000E+00  -1.04148258203847E-11   0.00000000000000E+00   6.26635718671688E-14   3.59554675655835E-22
      1.04147696720246E-08   1.04148323355968E-08  -8.59268158368366E-19  -1.98936272387128E-01  -1.98936272387052E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.64625700453656E-11   0.00000000000000E+00  -7.64625700453656E-11
      4.62156733290865E-18  -5.60257516562884E-01  -5.57000726555743E-01   0.00000000000000E+00   3.98011425954296E-13
     -1.33051484516202E-22  -1.03387677769773E-08  -1.03383697655514E-08  -3.76229917454028E-18
      7.24231424687082E-07
      0.00000000000000E+00  -1.33698383952997E-11   0.00000000000000E+00   7.35290364225356E-14   3.58677937820821E-22
      1.33697368468197E-08   1.33698103758565E-08  -8.28606087266807E-19  -2.16311590492720E-01  -2.16311590492639E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.18112873239856E-11   0.00000000000000E+00  -8.18112873239856E-11
      4.45794475826068E-18  -5.44945874730772E-01  -5.40759854903229E-01   0.00000000000000E+00   5.11196116494305E-13
     -1.30638869852501E-22  -1.32885102846489E-08  -1.32879990885325E-08  -3.62933867099387E-18
      7.26231424687082E-07
      0.00000000000000E+00  -1.67829725194058E-11   0.00000000000000E+00   8.48175730516681E-14   3.52678541989742E-22
      1.67829058122210E-08   1.67829906297944E-08  -7.99046822249936E-19  -2.33332579218217E-01  -2.33332579218130E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.65033026816812E-11   0.00000000000000E+00  -8.65033026816812E-11
      4.28493815289731E-18  -5.23310611564751E-01  -5.18050780489447E-01   0.00000000000000E+00   6.43643159078684E-13
     -1.27516063585500E-22  -1.66971309702717E-08  -1.66964873271128E-08  -3.48589133064738E-18
      7.28231424687082E-07
      0.00000000000000E+00  -2.06566161558704E-11   0.00000000000000E+00   9.61839427605851E-14   3.40492230456937E-22
      2.06565675832279E-08   2.06566637671710E-08  -7.70301143363937E-19  -2.50006533849774E-01  -2.50006533849683E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.07538745702070E-11   0.00000000000000E+00  -9.07538745702070E-11
      4.10343040375690E-18  -4.94571060137727E-01  -4.88092170327823E-01   0.00000000000000E+00   7.72530078103128E-13
     -1.23632815862050E-22  -2.05666824226787E-08  -2.05659098926008E-08  -3.33312926039296E-18
      7.30231424687082E-07
      0.00000000000000E+00  -2.49629403493197E-11   0.00000000000000E+00   1.06885079129958E-13   3.20857659692945E-22
      2.49628597122964E-08   2.49629665973759E-08  -7.42168160401616E-19  -2.66340321868494E-01  -2.66340321868399E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.47763407061852E-11   0.00000000000000E+00  -9.47763407061852E-11
      3.91387772234453E-18  -4.58009785856046E-01  -4.50175423487757E-01   0.00000000000000E+00   8.76767743562244E-13
     -1.19024998719558E-22  -2.48690670244131E-08  -2.48681902566697E-08  -3.17170956194291E-18
      7.32231424687082E-07
      0.00000000000000E+00  -2.96373782494968E-11   0.00000000000000E+00   1.16015814877456E-13   2.93764015235164E-22
      2.96372743904480E-08   2.96373904062631E-08  -7.14495320961905E-19  -2.82340919974121E-01  -2.82340919974022E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.84991563014436E-11   0.00000000000000E+00  -9.84991563014436E-11
      3.71687940974164E-18  -4.13041478593598E-01  -4.03735519744396E-01   0.00000000000000E+00   9.50824126239827E-13
     -1.13719360593322E-22  -2.95398420740878E-08  -2.95388912499617E-08  -3.00238408877974E-18
      7.34231424687082E-07
      0.00000000000000E+00  -3.45755023901967E-11   0.00000000000000E+00   1.22587579117819E-13   2.63236272564515E-22
      3.45754151599218E-08   3.45755377475012E-08  -6.87148767104976E-19  -2.98015815027463E-01  -2.98015815027361E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01631587462954E-10   0.00000000000000E+00  -1.01631587462954E-10
      3.51361623481573E-18  -3.59298782091153E-01  -3.48437890919577E-01   0.00000000000000E+00   9.96700103712310E-13
     -1.07608508221962E-22  -3.44749028601418E-08  -3.44739061600382E-08  -2.82646746771076E-18
      7.36231424687082E-07
      0.00000000000000E+00  -3.95212496440848E-11   0.00000000000000E+00   1.22834788134398E-13   2.36228319597214E-22
      3.95211034886964E-08   3.95212263234847E-08  -6.60094446678810E-19  -3.13371061774977E-01  -3.13371061774872E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04858800451775E-10   0.00000000000000E+00  -1.04858800451775E-10
      3.30389863391219E-18  -2.96957296076537E-01  -2.84539062341905E-01   0.00000000000000E+00   9.78741010715399E-13
     -1.00391818842372E-22  -3.94173462640436E-08  -3.94163675230329E-08  -2.64380418723338E-18
      7.38231424687082E-07
      0.00000000000000E+00  -4.37437195924636E-11   0.00000000000000E+00   1.04976937423524E-13   2.10052605756208E-22
      4.37436300856138E-08   4.37437350625514E-08  -6.33571834600245E-19  -3.28406905809959E-01  -3.28406905809848E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11108900616677E-10   0.00000000000000E+00  -1.11108900616677E-10
      3.08168083267883E-18  -2.27620131300718E-01  -2.13873316276176E-01   0.00000000000000E+00   8.34644477462396E-13
     -9.19415415123058E-23  -4.36334608064121E-08  -4.36326261619347E-08  -2.44810899807859E-18
      7.40231424687082E-07
      0.00000000000000E+00  -4.62434578050409E-11   0.00000000000000E+00   6.23028200520532E-14   1.63772672979970E-22
      4.62434080467567E-08   4.62434703495769E-08  -6.07942862790785E-19  -3.43120353313756E-01  -3.43120353313634E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22050570282199E-10   0.00000000000000E+00  -1.22050570282199E-10
      2.83757969211443E-18  -1.54767632734985E-01  -1.40236517436379E-01   0.00000000000000E+00   6.08956622454960E-13
     -8.40532781221151E-23  -4.61220287359170E-08  -4.61214197792946E-08  -2.22963682932365E-18
      7.42231424687082E-07
      0.00000000000000E+00  -4.51385656164343E-11   0.00000000000000E+00  -2.70633748463787E-14   9.47920479138028E-23
      4.51385894267073E-08   4.51385623633325E-08  -5.82904541989303E-19  -3.57524531412618E-01  -3.57524531412488E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29488115836949E-10   0.00000000000000E+00  -1.29488115836949E-10
      2.57860346044054E-18  -8.54761474122750E-02  -7.12953689885542E-02   0.00000000000000E+00   4.60539483154404E-13
     -6.99489531238458E-23  -4.50095347869787E-08  -4.50090742474956E-08  -1.99569891845123E-18
      7.44231424687082E-07
      0.00000000000000E+00  -3.38112623318929E-11   0.00000000000000E+00  -2.80144953718779E-13   3.80292085151171E-23
      3.38115308494470E-08   3.38112507044933E-08  -5.54438185729285E-19  -3.71678687878674E-01  -3.71678687878564E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09728129260895E-10   0.00000000000000E+00  -1.09728129260895E-10
      2.35914720191874E-18  -3.95912033999504E-02  -2.89729889983863E-02   0.00000000000000E+00   4.94377125171318E-13
     -3.43655405210164E-23  -3.37020169523576E-08  -3.37015225752325E-08  -1.80470901618946E-18
      7.46231424687082E-07
      0.00000000000000E+00  -2.11171256682290E-11   0.00000000000000E+00  -3.13395513476299E-13   1.56747160372026E-23
      2.11174034456491E-08   2.11170900501357E-08  -5.21402490371404E-19  -3.85615431056263E-01  -3.85615431056187E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.57819121962647E-11   0.00000000000000E+00  -7.57819121962647E-11
      2.20758337752622E-18  -1.93103581181098E-02  -1.26809371150979E-02   0.00000000000000E+00   4.04811603033913E-13
     -1.51617022553441E-23  -2.10417129495424E-08  -2.10413081379394E-08  -1.68618088715481E-18
      7.48231424687082E-07
      0.00000000000000E+00  -1.47928807535931E-11   0.00000000000000E+00  -1.55765700203128E-13   8.11942481405132E-24
      1.47930350082048E-08   1.47928792425046E-08  -4.87468545985094E-19  -3.99305168815854E-01  -3.99305168815795E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91054713834149E-11   0.00000000000000E+00  -5.91054713834149E-11
      2.08937243475939E-18  -1.17277699638695E-02  -7.08563925497033E-03   0.00000000000000E+00   2.06066962739087E-13
     -8.66016633213561E-24  -1.47339798380839E-08  -1.47337737711212E-08  -1.60190388877429E-18
      7.50231424687082E-07
      0.00000000000000E+00  -1.24186024520413E-11   0.00000000000000E+00  -5.82521843408410E-14   5.52918600307364E-24
      1.24186287709716E-08   1.24185705187873E-08  -4.53975436581738E-19  -4.12730441417687E-01  -4.12730441417633E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38058845745400E-11   0.00000000000000E+00  -5.38058845745400E-11
      1.98176066561031E-18  -8.90479304997257E-03  -5.00905647647773E-03   0.00000000000000E+00   9.46610071264143E-14
     -6.18803870911688E-24  -1.23648592952199E-08  -1.23647646342127E-08  -1.52778522902857E-18
      7.52231424687082E-07
      0.00000000000000E+00  -1.16093584725058E-11   0.00000000000000E+00  -1.96745013591028E-14   4.37749133740324E-24
      1.16093359592026E-08   1.16093162847012E-08  -4.21223739187071E-19  -4.25888157143287E-01  -4.25888157143235E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27185923020193E-11   0.00000000000000E+00  -5.27185923020193E-11
      1.87632348100627E-18  -7.70318190029020E-03  -4.06207005618705E-03   0.00000000000000E+00   5.01139734430440E-14
     -5.00966937038865E-24  -1.15566478063726E-08  -1.15565976923992E-08  -1.45509974181920E-18
      7.54231424687083E-07
      0.00000000000000E+00  -1.13285891108624E-11   0.00000000000000E+00  -6.66244956316212E-15   3.71973165914584E-24
      1.13285996251192E-08   1.13285929626697E-08  -3.89321423456895E-19  -4.38780911276611E-01  -4.38780911276558E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29613077842656E-11   0.00000000000000E+00  -5.29613077842656E-11
      1.77040086543774E-18  -7.06476838875133E-03  -3.51217779389396E-03   0.00000000000000E+00   3.35595446048722E-14
     -4.29357484200028E-24  -1.12756652144300E-08  -1.12756316548854E-08  -1.38107944198084E-18
      7.56231424687083E-07
      0.00000000000000E+00  -1.12168140656808E-11   0.00000000000000E+00  -2.51646337039700E-15   3.27600348419633E-24
      1.12168462341571E-08   1.12168437176937E-08  -3.58338386533403E-19  -4.51413104789409E-01  -4.51413104789356E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.35654420057057E-11   0.00000000000000E+00  -5.35654420057057E-11
      1.66326998142632E-18  -6.65175272470493E-03  -3.13455923349053E-03   0.00000000000000E+00   2.67699528888630E-14
     -3.78051295546519E-24  -1.11633050456409E-08  -1.11632782756880E-08  -1.30493159489292E-18
      7.58231424687083E-07
      0.00000000000000E+00  -1.11614316891447E-11   0.00000000000000E+00  -1.14773498483318E-15   2.94927958651649E-24
      1.11613747913271E-08   1.11613736435921E-08  -3.28320950272626E-19  -4.63789585169392E-01  -4.63789585169338E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.42146052956221E-11   0.00000000000000E+00  -5.42146052956221E-11
      1.55484077083508E-18  -6.35172801586043E-03  -2.85221426107218E-03   0.00000000000000E+00   2.32219797121311E-14
     -3.38336080496652E-24  -1.11071822602762E-08  -1.11071590382965E-08  -1.22651982056245E-18
      7.60231424687083E-07
      0.00000000000000E+00  -1.11277246705895E-11   0.00000000000000E+00  -6.25417197086152E-16   2.69722509485955E-24
      1.11277645916616E-08   1.11277639662444E-08  -2.99292660958688E-19  -4.75915122597416E-01  -4.75915122597361E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47993948508712E-11   0.00000000000000E+00  -5.47993948508712E-11
      1.44524198113334E-18  -6.12094412146930E-03  -2.63220247310705E-03   0.00000000000000E+00   2.08393046307014E-14
     -3.06535564615717E-24  -1.10729854106982E-08  -1.10729645713935E-08  -1.14594932017465E-18
      7.62231424687083E-07
      0.00000000000000E+00  -1.11047634862876E-11   0.00000000000000E+00  -3.78469025336425E-16   2.49695592440682E-24
      1.11047776187564E-08   1.11047772402873E-08  -2.71257864504073E-19  -4.87793985543434E-01  -4.87793985543378E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52767956663978E-11   0.00000000000000E+00  -5.52767956663978E-11
      1.33468838980054E-18  -5.93797211086578E-03  -2.45662192316087E-03   0.00000000000000E+00   1.89820682977492E-14
     -2.80604438160126E-24  -1.10495194266892E-08  -1.10495004446209E-08  -1.06343052529647E-18
      7.64231424687083E-07
      0.00000000000000E+00  -1.10880477441159E-11   0.00000000000000E+00  -2.37841730491988E-16   2.33430113196490E-24
      1.10880323148463E-08   1.10880320770046E-08  -2.44208181200524E-19  -4.99428959918600E-01  -4.99428959918545E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56244125111720E-11   0.00000000000000E+00  -5.56244125111720E-11
      1.22343956477820E-18  -5.79003704106164E-03  -2.31407102470634E-03   0.00000000000000E+00   1.74355032479392E-14
     -2.59180205712076E-24  -1.10324250999967E-08  -1.10324076644934E-08  -9.79231383577674E-19
      7.66231424687083E-07
      0.00000000000000E+00  -1.10753731703812E-11   0.00000000000000E+00  -1.49600807234804E-16   2.19984476041241E-24
      1.10753503512701E-08   1.10753502016692E-08  -2.18134936749387E-19  -5.10817682576986E-01  -5.10817682576930E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58126983236953E-11   0.00000000000000E+00  -5.58126983236953E-11
      1.11181416813081E-18  -5.66861840249120E-03  -2.19670624630591E-03   0.00000000000000E+00   1.33097251600465E-14
     -2.41284573979134E-24  -1.10195508130707E-08  -1.10195375033456E-08  -8.93679231381421E-19
      7.68231424687083E-07
      0.00000000000000E+00  -1.10653620940256E-11   0.00000000000000E+00  -9.52652347261080E-17   2.08717181502247E-24
      1.10653167657762E-08   1.10653166705110E-08  -1.93066463014524E-19  -5.21937259696111E-01  -5.21937259696055E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57380323643521E-11   0.00000000000000E+00  -5.57380323643521E-11
      1.00033810340210E-18  -5.56779068379901E-03  -2.09901523061272E-03   0.00000000000000E+00   1.49191356787207E-14
     -2.26211687379140E-24  -1.10095935572823E-08  -1.10095786381466E-08  -8.07271640387580E-19
      7.70231424687083E-07
      0.00000000000000E+00  -1.10566368439909E-11   0.00000000000000E+00  -7.20159824066060E-17   1.99204329312368E-24
      1.10566679884066E-08   1.10566679163906E-08  -1.69153252987800E-19  -5.32705487568820E-01  -5.32705487568765E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50906332642284E-11   0.00000000000000E+00  -5.50906332642284E-11
      8.90156836873647E-19  -5.48351045941403E-03  -2.01725511908901E-03   0.00000000000000E+00   1.37771866988149E-14
     -2.13484971212050E-24  -1.10015910603130E-08  -1.10015772831264E-08  -7.21003583885846E-19
      7.72231424687083E-07
      0.00000000000000E+00  -1.10482789729050E-11   0.00000000000000E+00  -7.62370445500241E-17   1.91176088472102E-24
      1.10483228491746E-08   1.10483227729375E-08  -1.46690687277141E-19  -5.42967446663538E-01  -5.42967446663484E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34675127331201E-11   0.00000000000000E+00  -5.34675127331201E-11
      7.83221811407406E-19  -5.41306488095386E-03  -1.94892681274816E-03   0.00000000000000E+00   1.25837016154721E-14
     -2.02787679262309E-24  -1.09948678439060E-08  -1.09948552602044E-08  -6.36531124130266E-19
      7.74231424687083E-07
      0.00000000000000E+00  -1.10394618781331E-11   0.00000000000000E+00  -9.96925611979730E-17   1.84459499089973E-24
      1.10394847799434E-08   1.10394846802509E-08  -1.26087721887448E-19  -5.52506977202979E-01  -5.52506977202929E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.05057070242228E-11   0.00000000000000E+00  -5.05057070242228E-11
      6.82210397358961E-19  -5.35460481642949E-03  -1.89231758528171E-03   0.00000000000000E+00   1.12697781007202E-14
     -1.93902403229187E-24  -1.09889902430047E-08  -1.09889789732266E-08  -5.56122675471513E-19
      7.76231424687083E-07
      0.00000000000000E+00  -1.10293589570403E-11   0.00000000000000E+00  -1.48803045657981E-16   1.78956221281168E-24
      1.10293599010023E-08   1.10293597521992E-08  -1.07901990965242E-19  -5.61029109537947E-01  -5.61029109537902E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57402989859585E-11   0.00000000000000E+00  -4.57402989859585E-11
      5.90729799387044E-19  -5.30697370900527E-03  -1.84637456307515E-03   0.00000000000000E+00   9.76049348067101E-15
     -1.86706692363915E-24  -1.09836292137068E-08  -1.09836194532133E-08  -4.82827808421803E-19
      7.78231424687083E-07
      0.00000000000000E+00  -1.10170517622545E-11   0.00000000000000E+00  -2.22385777762310E-16   1.74640836490826E-24
      1.10170160760694E-08   1.10170158536837E-08  -9.28987407248984E-20  -5.68131820611238E-01  -5.68131820611199E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85499446643677E-11   0.00000000000000E+00  -3.85499446643677E-11
      5.13629910058309E-19  -5.26968217318498E-03  -1.81070629937537E-03   0.00000000000000E+00   7.94381602135342E-15
     -1.81179124892206E-24  -1.09784738528353E-08  -1.09784659090193E-08  -4.20731169333410E-19
      7.80231424687083E-07
      0.00000000000000E+00  -1.10014381569292E-11   0.00000000000000E+00  -3.26115209287778E-16   1.71559851245066E-24
      1.10014164221824E-08   1.10014160960672E-08  -8.20696964812790E-20  -5.73298557402864E-01  -5.73298557402836E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.82794544076620E-11   0.00000000000000E+00  -2.82794544076620E-11
      4.57071001242984E-19  -5.24287517357330E-03  -1.78557807686118E-03   0.00000000000000E+00   5.70649744934750E-15
     -1.77399322995170E-24  -1.09731423481570E-08  -1.09731366416595E-08  -3.75001304761705E-19
      7.82231424687083E-07
      0.00000000000000E+00  -1.09815996936924E-11   0.00000000000000E+00  -4.58214492917451E-16   1.69836535289274E-24
      1.09816452194432E-08   1.09816447612287E-08  -7.66101195339485E-20  -5.75915619542495E-01  -5.75915619542480E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44028735642579E-11   0.00000000000000E+00  -1.44028735642579E-11
      4.28265254114469E-19  -5.22741385798390E-03  -1.77197385899479E-03   0.00000000000000E+00   2.93622824695057E-15
     -1.75559462851591E-24  -1.09672448238927E-08  -1.09672418876644E-08  -3.51655134580520E-19
      7.84231424687083E-07
      0.00000000000000E+00  -1.09569853041207E-11   0.00000000000000E+00  -4.89640527527592E-16   1.69688995059075E-24
      1.09569704586567E-08   1.09569699690162E-08  -7.78827332855986E-20  -5.75303209357608E-01  -5.75303209357612E-01
      0.00000000000000E+00   0.00000000000000E+00   3.36044794123618E-12   0.00000000000000E+00   3.36044794123618E-12
      4.34986149996941E-19  -5.22504433709641E-03  -1.77178200067019E-03   0.00000000000000E+00  -6.02632014358829E-16
     -1.76003059716704E-24  -1.09603298143254E-08  -1.09603304169574E-08  -3.57103416711342E-19
      7.86231424687083E-07
      0.00000000000000E+00  -1.09266765408422E-11   0.00000000000000E+00  -7.97570958393019E-16   1.71478463796517E-24
      1.09267057760910E-08   1.09267049785200E-08  -8.74064258026640E-20  -5.70743546419543E-01  -5.70743546419568E-01
      0.00000000000000E+00   0.00000000000000E+00   2.50108816652891E-11   0.00000000000000E+00   2.50108816652891E-11
      4.85007913327519E-19  -5.23883175627398E-03  -1.78828382663413E-03   0.00000000000000E+00  -4.66604207377569E-15
     -1.79322710633420E-24  -1.09517111941433E-08  -1.09517158601853E-08  -3.97601487524855E-19
      7.88231424687083E-07
      0.00000000000000E+00  -1.08898468012220E-11   0.00000000000000E+00  -7.31367358562972E-16   1.75816351055871E-24
      1.08898727453055E-08   1.08898720139381E-08  -1.06899215221057E-19  -5.61494243405957E-01  -5.61494243406007E-01
      0.00000000000000E+00   0.00000000000000E+00   5.02800433192976E-11   0.00000000000000E+00   5.02800433192976E-11
      5.85567999966114E-19  -5.27422311477236E-03  -1.82731923192704E-03   0.00000000000000E+00  -1.01183844300526E-14
     -1.86582535095370E-24  -1.09401419388730E-08  -1.09401520572574E-08  -4.78668784745057E-19
      7.90231424687083E-07
      0.00000000000000E+00  -1.08444755010415E-11   0.00000000000000E+00  -1.29386648103904E-15   1.83787754211838E-24
      1.08445200583034E-08   1.08445187644369E-08  -1.38381380703725E-19  -5.46789295869356E-01  -5.46789295869434E-01
      0.00000000000000E+00   0.00000000000000E+00   7.85836431306999E-11   0.00000000000000E+00   7.85836431306999E-11
      7.42735286227514E-19  -5.34151617117063E-03  -1.89998493712453E-03   0.00000000000000E+00  -1.63358167230205E-14
     -1.99833001323892E-24  -1.09230860717509E-08  -1.09231024075676E-08  -6.04353905523789E-19
      7.92231424687083E-07
      0.00000000000000E+00  -1.07861540929147E-11   0.00000000000000E+00  -1.72922114081768E-15   1.97426754164800E-24
      1.07861177595853E-08   1.07861160303641E-08  -1.84321222015211E-19  -5.25842248567010E-01  -5.25842248567119E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08806728137016E-10   0.00000000000000E+00   1.08806728137016E-10
      9.60348742501547E-19  -5.46183874993022E-03  -2.02918739539552E-03   0.00000000000000E+00  -2.47694431986086E-14
     -2.23434681054788E-24  -1.08948979890579E-08  -1.08949227585011E-08  -7.76027520486335E-19
      7.94231424687083E-07
      0.00000000000000E+00  -1.07027590715303E-11   0.00000000000000E+00  -3.33060542029573E-13   2.20748318341696E-24
      1.07027710254760E-08   1.07024379649340E-08  -2.47764531047667E-19  -4.97869592305591E-01  -4.97869592305730E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38876358028134E-10   0.00000000000000E+00   1.38876358028134E-10
      1.23810145855781E-18  -5.68319756885638E-03  -2.26733499565357E-03   0.00000000000000E+00   2.94295578051284E-13
     -2.68065926714111E-24  -1.08416086185402E-08  -1.08413143229621E-08  -9.90336927510146E-19
      7.96231424687083E-07
      0.00000000000000E+00  -1.05581036104284E-11   0.00000000000000E+00  -8.55696599302259E-15   2.61738275542239E-24
      1.05581523287833E-08   1.05581437718173E-08  -3.32225588648617E-19  -4.62144163545696E-01  -4.62144163545861E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65307456296171E-10   0.00000000000000E+00   1.65307456296171E-10
      1.56871637115016E-18  -6.13044725550302E-03  -2.75182636833826E-03   0.00000000000000E+00  -4.85186557051347E-14
     -3.65598908063134E-24  -1.07234027094578E-08  -1.07234512281135E-08  -1.23649078250154E-18
      7.98231424687083E-07
      0.00000000000000E+00  -1.02234213880442E-11   0.00000000000000E+00  -1.80167804164226E-14   3.31805522268936E-24
      1.02234620886376E-08   1.02234440718572E-08  -4.40564747188546E-19  -4.18063980896962E-01  -4.18063980897146E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83792578100657E-10   0.00000000000000E+00   1.83792578100657E-10
      1.93630152735147E-18  -7.18606366075880E-03  -3.90707667520428E-03   0.00000000000000E+00  -6.91422917234624E-14
     -6.36876859817014E-24  -1.04071675076662E-08  -1.04072366499579E-08  -1.49573678016292E-18
      8.00231424687084E-07
      0.00000000000000E+00  -9.20927179979871E-12   0.00000000000000E+00  -2.63299515253571E-14   3.92707760521649E-24
      9.20925477664202E-09   9.20922844669050E-09  -5.71089502225144E-19  -3.65231736341291E-01  -3.65231736341486E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94420505491631E-10   0.00000000000000E+00   1.94420505491631E-10
      2.32514253833473E-18  -1.01811177588431E-02  -7.21834087536173E-03   0.00000000000000E+00  -1.14996875479478E-13
     -1.59977470716790E-23  -9.40353395530663E-09  -9.40364895218212E-09  -1.75405303610959E-18
      8.02231424687084E-07
      0.00000000000000E+00  -6.31616257776161E-12   0.00000000000000E+00  -7.65860241856328E-14  -3.88674987188277E-25
      6.31625069339834E-09   6.31617410737415E-09  -7.12596860074814E-19  -3.03735849861499E-01  -3.03735849861711E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12355524929771E-10   0.00000000000000E+00   2.12355524929771E-10
      2.74985358819428E-18  -1.87336983690698E-02  -1.66767853435810E-02   0.00000000000000E+00  -1.63429838739496E-13
     -4.49557489724056E-23  -6.52836620246514E-09  -6.52852963230393E-09  -2.03725672811946E-18
      8.04231424687084E-07
      0.00000000000000E+00  -2.40917930169063E-12   0.00000000000000E+00  -9.90719869586768E-14  -1.82953720439295E-23
      2.40923699509241E-09   2.40913792310543E-09  -8.55631781951102E-19  -2.34983306810511E-01  -2.34983306810750E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38499950851127E-10   0.00000000000000E+00   2.38499950851127E-10
      3.22685348989653E-18  -3.46975270632727E-02  -3.38633548624970E-02   0.00000000000000E+00  -2.87792590258909E-13
     -7.64291276370153E-23  -2.64735008136622E-09  -2.64763787395656E-09  -2.37122170794543E-18
      8.06231424687084E-07
      0.00000000000000E+00  -5.11667030983132E-13   0.00000000000000E+00  -5.04423551511645E-14  -3.62235119364129E-23
      5.11753383050273E-10   5.11702940695086E-10  -1.00207639473831E-18  -1.62296969922008E-01  -1.62296969922251E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43735386222405E-10   0.00000000000000E+00   2.43735386222405E-10
      3.71432426234134E-18  -5.40388723090700E-02  -5.38008637115939E-02   0.00000000000000E+00  -5.13931957642421E-13
     -8.79033830308988E-23  -7.54924394959760E-10  -7.55438326917490E-10  -2.71224786760302E-18
      8.08231424687084E-07
      0.00000000000000E+00  -3.06761422273139E-14   0.00000000000000E+00  -1.63262219755665E-14  -4.38264389421617E-23
      3.07023757480691E-11   3.06860495260497E-11  -1.14512146382385E-18  -9.19107244867381E-02  -9.19107244869605E-02
      0.00000000000000E+00   0.00000000000000E+00   2.22341652367249E-10   0.00000000000000E+00   2.22341652367249E-10
      4.15900756707584E-18  -7.39753812306076E-02  -7.38956625255388E-02   0.00000000000000E+00  -7.46396072232705E-13
     -9.49797775358161E-23  -2.52281305820971E-10  -2.53027701893299E-10  -3.01388610325199E-18
      8.10231424687084E-07
      0.00000000000000E+00   2.76452658994656E-14   0.00000000000000E+00  -4.77879135274439E-15  -4.56796906741665E-23
     -2.76319049439072E-11  -2.76366837353056E-11  -1.24547646188970E-18  -4.29267553682168E-02  -4.29267553683793E-02
      0.00000000000000E+00   0.00000000000000E+00   1.62414070851586E-10   0.00000000000000E+00   1.62414070851586E-10
      4.48383570877901E-18  -9.37444055183222E-02  -9.37019427839528E-02   0.00000000000000E+00  -7.24261596556679E-13
     -1.00905841898562E-22  -1.34053125519623E-10  -1.34777387116281E-10  -3.23835924688931E-18
      8.12231424687084E-07
      0.00000000000000E+00   9.36816319516773E-15   0.00000000000000E+00  -8.91533835808785E-16  -4.60155499171776E-23
     -9.38708274605451E-12  -9.38797427993633E-12  -1.29345102928625E-18  -2.06181605957643E-02  -2.06181605958632E-02
      0.00000000000000E+00   0.00000000000000E+00   9.89673179609494E-11   0.00000000000000E+00   9.89673179609494E-11
      4.68177034470091E-18  -1.13205243716010E-01  -1.13177021163223E-01   0.00000000000000E+00  -4.77634575537983E-13
     -1.04247937846588E-22  -8.91017091053715E-11  -8.95793436810138E-11  -3.38831931541466E-18
      8.14231424687084E-07
      0.00000000000000E+00  -8.90893950913009E-15   0.00000000000000E+00   2.96361563467423E-16  -4.57140457518778E-23
      8.94961792845809E-12   8.94991428997584E-12  -1.31290041757724E-18  -1.22043233771943E-02  -1.22043233772566E-02
      0.00000000000000E+00   0.00000000000000E+00   6.23060065051324E-11   0.00000000000000E+00   6.23060065051324E-11
      4.80638235771117E-18  -1.32309660402091E-01  -1.32287210946718E-01   0.00000000000000E+00  -3.25439787523352E-13
     -1.06321682544825E-22  -7.09304810074784E-11  -7.12559207951081E-11  -3.49348194013393E-18
      8.16231424687084E-07
      0.00000000000000E+00  -2.13998237693537E-14   0.00000000000000E+00   5.04042650719504E-16  -4.47588434128784E-23
      2.14403553465401E-11   2.14408593891461E-11  -1.31999660039289E-18  -9.09104231205655E-03  -9.09104231210020E-03
      0.00000000000000E+00   0.00000000000000E+00   4.36480034245462E-11   0.00000000000000E+00   4.36480034245462E-11
      4.89367836456026E-18  -1.51039372295476E-01  -1.51018865931689E-01   0.00000000000000E+00  -2.76719455178211E-13
     -1.07992886523120E-22  -6.48121433584059E-11  -6.50888628136921E-11  -3.57368176416738E-18
      8.18231424687084E-07
      0.00000000000000E+00  -3.03087632784838E-14   0.00000000000000E+00   4.38024336528030E-16  -4.28441076805847E-23
      3.02647188867619E-11   3.02651569110556E-11  -1.32196072492401E-18  -7.79141595619810E-03  -7.79141595623168E-03
      0.00000000000000E+00   0.00000000000000E+00   3.35841165916804E-11   0.00000000000000E+00   3.35841165916804E-11
      4.96084659774363E-18  -1.69391423394457E-01  -1.69371307672109E-01   0.00000000000000E+00  -2.71306656642980E-13
     -1.09567869446035E-22  -6.35779668459832E-11  -6.38492735027357E-11  -3.63888587281962E-18
      8.20231424687084E-07
      0.00000000000000E+00  -3.70134290946333E-14   0.00000000000000E+00   3.49885267576228E-16  -3.95639424610761E-23
      3.70009273771505E-11   3.70012772623785E-11  -1.32175553857491E-18  -7.11704092867609E-03  -7.11704092870365E-03
      0.00000000000000E+00   0.00000000000000E+00   2.75544364353901E-11   0.00000000000000E+00   2.75544364353901E-11
      5.01595547061441E-18  -1.87369752776041E-01  -1.87349414595352E-01   0.00000000000000E+00  -2.77916963415488E-13
     -1.11127843078400E-22  -6.42777967342421E-11  -6.45557136977687E-11  -3.69419993203949E-18
      8.22231424687084E-07
      0.00000000000000E+00  -4.25241133270849E-14   0.00000000000000E+00   2.74010764985993E-16  -3.44908437033866E-23
      4.25058518853034E-11   4.25061258960339E-11  -1.32062038954356E-18  -6.68795920638699E-03  -6.68795920641060E-03
      0.00000000000000E+00   0.00000000000000E+00   2.36144780380583E-11   0.00000000000000E+00   2.36144780380583E-11
      5.06318442669052E-18  -2.04981106259310E-01  -2.04960275169342E-01   0.00000000000000E+00  -2.85736396482109E-13
     -1.12685013044086E-22  -6.58348675374979E-11  -6.61206039340927E-11  -3.74256403714696E-18
      8.24231424687084E-07
      0.00000000000000E+00  -4.73000396618763E-14   0.00000000000000E+00   2.22387238364282E-16  -2.72487502428534E-23
      4.72660995771071E-11   4.72663219643183E-11  -1.31910283815954E-18  -6.37892941630537E-03  -6.37892941632627E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08944310554535E-11   0.00000000000000E+00   2.08944310554535E-11
      5.10497328880143E-18  -2.22233125918796E-01  -2.22211652199535E-01   0.00000000000000E+00  -2.92009868755026E-13
     -1.14235491460839E-22  -6.78687431509022E-11  -6.81607530197715E-11  -3.78587045064190E-18
      8.26231424687084E-07
      0.00000000000000E+00  -5.16167423106300E-14   0.00000000000000E+00   1.89200911128789E-16  -1.76243276100413E-23
      5.15739690140003E-11   5.15741582148938E-11  -1.31745515200442E-18  -6.14222325720642E-03  -6.14222325722537E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89495852641436E-11   0.00000000000000E+00   1.89495852641436E-11
      5.14287245932972E-18  -2.39133394146052E-01  -2.39111176098387E-01   0.00000000000000E+00  -2.96498356345981E-13
     -1.15773917648669E-22  -7.02272451225753E-11  -7.05237434790370E-11  -3.82541730732530E-18
      8.28231424687084E-07
      0.00000000000000E+00  -5.55660660105537E-14   0.00000000000000E+00   1.68186376482764E-16  -5.69453039925804E-24
      5.56057576626973E-11   5.56059258490681E-11  -1.31579351966132E-18  -5.95501568903098E-03  -5.95501568904850E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75193417470418E-11   0.00000000000000E+00   1.75193417470418E-11
      5.17791114282380E-18  -2.55689034096666E-01  -2.55665996583377E-01   0.00000000000000E+00  -2.99613800125391E-13
     -1.17296688483336E-22  -7.28256537958674E-11  -7.31252675961101E-11  -3.86211762316248E-18
      8.30231424687084E-07
      0.00000000000000E+00  -5.94235449732698E-14   0.00000000000000E+00   1.54772515836586E-16   7.95768430298986E-24
      5.94658833941300E-11   5.94660381666538E-11  -1.31416827556577E-18  -5.80392117912905E-03  -5.80392117914549E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64369241698190E-11   0.00000000000000E+00   1.64369241698190E-11
      5.21078499116344E-18  -2.71906867211515E-01  -2.71882954742759E-01   0.00000000000000E+00  -3.01867146015340E-13
     -1.18802390264213E-22  -7.56010951903385E-11  -7.59029623364727E-11  -3.89661671559767E-18
      8.32231424687084E-07
      0.00000000000000E+00  -6.31891791987784E-14   0.00000000000000E+00   1.46051710383796E-16   2.20583470000621E-23
      6.32175270408643E-11   6.32176730925967E-11  -1.31259767109421E-18  -5.68008309021841E-03  -5.68008309023400E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55911969842045E-11   0.00000000000000E+00   1.55911969842045E-11
      5.24196738513185E-18  -2.87794063015749E-01  -2.87769235209936E-01   0.00000000000000E+00  -3.03727613930884E-13
     -1.20291350172930E-22  -7.85051424627504E-11  -7.88088700768015E-11  -3.92936971403764E-18
      8.34231424687084E-07
      0.00000000000000E+00  -6.68629686870795E-14   0.00000000000000E+00   1.40276401258956E-16   3.58370479286936E-23
      6.69013063277046E-11   6.69014466041417E-11  -1.31108484840536E-18  -5.57735037056963E-03  -5.57735037058454E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49063244578295E-11   0.00000000000000E+00   1.49063244578295E-11
      5.27178003404751E-18  -3.03358021263501E-01  -3.03332248834222E-01   0.00000000000000E+00  -3.05573040846566E-13
     -1.21765268130758E-22  -8.15021980210025E-11  -8.18077710619708E-11  -3.96069518564215E-18
      8.36231424687084E-07
      0.00000000000000E+00  -7.05367581753806E-14   0.00000000000000E+00   1.36375531183625E-16   4.86961197382354E-23
      7.05440829526184E-11   7.05442193281983E-11  -1.30962643773258E-18  -5.49150978715398E-03  -5.49150978716830E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43275580961906E-11   0.00000000000000E+00   1.43275580961906E-11
      5.30043515023989E-18  -3.18603253292053E-01  -3.18576515738563E-01   0.00000000000000E+00  -3.07614737177128E-13
     -1.23226510497936E-22  -8.45641626870888E-11  -8.48717774243891E-11  -3.99080871250731E-18
      8.38231424687084E-07
      0.00000000000000E+00  -7.41187029264741E-14   0.00000000000000E+00   1.33626200697306E-16   6.02206165970567E-23
      7.41623247706535E-11   7.41624583969144E-11  -1.30821713231718E-18  -5.41973817142237E-03  -5.41973817143619E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38134941362315E-11   0.00000000000000E+00   1.38134941362315E-11
      5.32806213851235E-18  -3.33527646434154E-01  -3.33499931111772E-01   0.00000000000000E+00  -3.09884490466084E-13
     -1.24677108310802E-22  -8.76660680425556E-11  -8.79759525331463E-11  -4.01984500619517E-18
      8.40231424687084E-07
      0.00000000000000E+00  -7.77924924147752E-14   0.00000000000000E+00   1.31612460303158E-16   7.02135499557684E-23
      7.77664797643576E-11   7.77666113768881E-11  -1.30685133785911E-18  -5.36010893499046E-03  -5.36010893500380E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33413359538505E-11   0.00000000000000E+00   1.33413359538505E-11
      5.35474481042005E-18  -3.48131468784531E-01  -3.48102766939159E-01   0.00000000000000E+00  -3.12578434201560E-13
     -1.26119730167639E-22  -9.07953688964110E-11  -9.11079473307386E-11  -4.04789347256095E-18
      8.42231424687084E-07
      0.00000000000000E+00  -8.13744371658687E-14   0.00000000000000E+00   1.30286523815692E-16   7.86751092757942E-23
      8.13686301900453E-11   8.13687604766478E-11  -1.30552222625599E-18  -5.31139711195639E-03  -5.31139711196931E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29136971683294E-11   0.00000000000000E+00   1.29136971683294E-11
      5.38057220475671E-18  -3.62439812154458E-01  -3.62410110402401E-01   0.00000000000000E+00  -3.16472629879840E-13
     -1.27560279637570E-22  -9.39659850149688E-11  -9.42824576449762E-11  -4.07504997850072E-18
      8.44231424687085E-07
      0.00000000000000E+00  -8.49563819169622E-14   0.00000000000000E+00   1.29860369422381E-16   8.57467635998260E-23
      8.49879616420696E-11   8.49880915025248E-11  -1.30422020515691E-18  -5.27304602138513E-03  -5.27304602139768E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25524370058719E-11   0.00000000000000E+00   1.25524370058719E-11
      5.40567707876846E-18  -3.76520680169342E-01  -3.76489952196655E-01   0.00000000000000E+00  -3.22906726115371E-13
     -1.29010166839260E-22  -9.72176217821526E-11  -9.75405285083970E-11  -4.10145687361155E-18
      8.46231424687085E-07
      0.00000000000000E+00  -8.86301714052633E-14   0.00000000000000E+00   1.29391411201432E-16   9.16234133520218E-23
      8.86275947893249E-11   8.86277241808277E-11  -1.30294013834032E-18  -5.24513366893522E-03  -5.24513366894741E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21995259302098E-11   0.00000000000000E+00   1.21995259302098E-11
      5.43007613062887E-18  -3.90375372408401E-01  -3.90343609202186E-01   0.00000000000000E+00  -3.29985963874415E-13
     -1.30471575792025E-22  -1.00497264147033E-10  -1.00827250111038E-10  -4.12713599228855E-18
      8.48231424687085E-07
      0.00000000000000E+00  -9.23039608935644E-14   0.00000000000000E+00   1.29461708911595E-16   9.65109896450521E-23
      9.22819578250015E-11   9.22820872868069E-11  -1.30167900771400E-18  -5.22844171215719E-03  -5.22844171216901E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18248242907894E-11   0.00000000000000E+00   1.18248242907894E-11
      5.45372577921045E-18  -4.03974732947071E-01  -4.03941936745971E-01   0.00000000000000E+00  -3.36804592285098E-13
     -1.31942422285570E-22  -1.03770106985180E-10  -1.04106911577597E-10  -4.15204677149646E-18
      8.50231424687085E-07
      0.00000000000000E+00  -9.59777503818655E-14   0.00000000000000E+00   1.29429509786388E-16   1.00606787833599E-22
      9.59516704629070E-11   9.59517998925174E-11  -1.30043194377072E-18  -5.22461207613470E-03  -5.22461207614614E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14364485537543E-11   0.00000000000000E+00   1.14364485537543E-11
      5.47659867631796E-18  -4.17307481356318E-01  -4.17273651646721E-01   0.00000000000000E+00  -3.43876309706666E-13
     -1.33422713953265E-22  -1.07044372136431E-10  -1.07388248446271E-10  -4.17616673254725E-18
      8.52231424687085E-07
      0.00000000000000E+00  -9.96515398701665E-14   0.00000000000000E+00   1.29861967846107E-16   1.04084663946405E-22
      9.96433549879102E-11   9.96434848499822E-11  -1.29919119164382E-18  -5.23653985031514E-03  -5.23653985032618E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10392363111406E-11   0.00000000000000E+00   1.10392363111406E-11
      5.49867714894024E-18  -4.30373204742356E-01  -4.30338337400762E-01   0.00000000000000E+00  -3.51423805311183E-13
     -1.34913113463611E-22  -1.10331297355677E-10  -1.10682721161123E-10  -4.19948595729642E-18
      8.54231424687085E-07
      0.00000000000000E+00  -1.03417174095675E-13   0.00000000000000E+00   1.31190662097433E-16   1.07092397973555E-22
      1.03372730395498E-10   1.03372861586267E-10  -1.29794407205017E-18  -5.26934705399856E-03  -5.26934705400919E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06322883858822E-11   0.00000000000000E+00   1.06322883858822E-11
      5.51994172571201E-18  -4.43175381988589E-01  -4.43139468223563E-01   0.00000000000000E+00  -3.59382943501264E-13
     -1.36413652136524E-22  -1.13645767028511E-10  -1.14005149972149E-10  -4.22199765366183E-18
      8.56231424687085E-07
      0.00000000000000E+00  -1.07182808321184E-13   0.00000000000000E+00   1.34227145551190E-16   1.09759199250099E-22
      1.07173868043065E-10   1.07174002270320E-10  -1.29666795818242E-18  -5.33264497894154E-03  -5.33264497895175E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02090743661985E-11   0.00000000000000E+00   1.02090743661985E-11
      5.54035987444441E-18  -4.55718657706882E-01  -4.55681680051791E-01   0.00000000000000E+00  -3.67494431009622E-13
     -1.37922935843171E-22  -1.17015582205371E-10  -1.17383076636519E-10  -4.24369191626198E-18
      8.58231424687085E-07
      0.00000000000000E+00  -1.11132132021107E-13   0.00000000000000E+00   1.41089952127981E-16   1.12214606536215E-22
      1.11122249400742E-10   1.11122390490807E-10  -1.29531817106626E-18  -5.44597089966060E-03  -5.44597089967035E-03
      0.00000000000000E+00   0.00000000000000E+00   9.75261618180426E-12   0.00000000000000E+00   9.75261618180426E-12
      5.55986510680801E-18  -4.68007895979563E-01  -4.67969818538957E-01   0.00000000000000E+00  -3.75231292462408E-13
     -1.39437170677611E-22  -1.20499775380009E-10  -1.20875006672611E-10  -4.26454693574175E-18
      8.60231424687085E-07
      0.00000000000000E+00  -1.15356989932654E-13   0.00000000000000E+00   1.56057896029738E-16   1.14633032664417E-22
      1.15397485771081E-10   1.15397641829091E-10  -1.29379604738307E-18  -5.65321511973517E-03  -5.65321511974439E-03
      0.00000000000000E+00   0.00000000000000E+00   9.21914723049033E-12   0.00000000000000E+00   9.21914723049033E-12
      5.57830340126899E-18  -4.80047751720397E-01  -4.80008495806377E-01   0.00000000000000E+00  -3.81435286941521E-13
     -1.40947936399448E-22  -1.24235353772499E-10  -1.24616789059581E-10  -4.28450735388593E-18
      8.62231424687085E-07
      0.00000000000000E+00  -1.20500295216275E-13   0.00000000000000E+00   1.93149962259079E-16   1.17363490439513E-22
      1.20481632570908E-10   1.20481825720988E-10  -1.29185188318080E-18  -6.06669537546415E-03  -6.06669537547263E-03
      0.00000000000000E+00   0.00000000000000E+00   8.48346504410873E-12   0.00000000000000E+00   8.48346504410873E-12
      5.59527033135721E-18  -4.91842152870640E-01  -4.91801527382227E-01   0.00000000000000E+00  -3.83063700183551E-13
     -1.42435466462944E-22  -1.28582227064772E-10  -1.28965290765098E-10  -4.30341844817641E-18
      8.64231424687085E-07
      0.00000000000000E+00  -1.27847874192877E-13   0.00000000000000E+00   3.03915827624025E-16   1.21399033805828E-22
      1.27906849999352E-10   1.27907153915301E-10  -1.28873881378130E-18  -7.02466919069430E-03  -7.02466919070143E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13002080283164E-12   0.00000000000000E+00   7.13002080283164E-12
      5.60953037296288E-18  -5.03392802424817E-01  -5.03350264513799E-01   0.00000000000000E+00  -3.70320305519058E-13
     -1.43844486759790E-22  -1.34666854412468E-10  -1.35037174718131E-10  -4.32079155918158E-18
      8.66231424687085E-07
      0.00000000000000E+00  -1.43461479518157E-13   0.00000000000000E+00   6.61947108841473E-16   1.30257510393323E-22
      1.43464120854283E-10   1.43464782801522E-10  -1.28187082446485E-18  -9.69808336470568E-03  -9.69808336470930E-03
      0.00000000000000E+00   0.00000000000000E+00   3.61830471537457E-12   0.00000000000000E+00   3.61830471537457E-12
      5.61676698239362E-18  -5.14693120085561E-01  -5.14646787948684E-01   0.00000000000000E+00  -3.07101368404519E-13
     -1.44990780179178E-22  -1.46775986148347E-10  -1.47083087516897E-10  -4.33489615792877E-18
      8.68231424687085E-07
      0.00000000000000E+00  -1.87914332326600E-13   0.00000000000000E+00   1.80191799466531E-15   1.54506143593158E-22
      1.87900896415623E-10   1.87902698333772E-10  -1.26358938609242E-18  -1.74761363927000E-02  -1.74761363926937E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.31593357788280E-12   0.00000000000000E+00  -6.31593357788280E-12
      5.60413511523786E-18  -5.25704651707446E-01  -5.25647451115624E-01   0.00000000000000E+00  -9.79371309739953E-14
     -1.45350877911715E-22  -1.81488827624771E-10  -1.81586764755890E-10  -4.34054572914544E-18
      8.70231424687085E-07
      0.00000000000000E+00  -2.97209569603557E-13   0.00000000000000E+00   3.96982040305184E-15   1.99634823632077E-22
      2.97246740312931E-10   2.97250710133534E-10  -1.22726231270418E-18  -3.28264032830149E-02  -3.28264032829929E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.20380952058391E-11   0.00000000000000E+00  -2.20380952058391E-11
      5.56005892482618E-18  -5.36318539382731E-01  -5.36231846411300E-01   0.00000000000000E+00   2.09284942518965E-13
     -1.44570758099287E-22  -2.75421899870068E-10  -2.75212614927694E-10  -4.33279661212200E-18
      8.72231424687085E-07
      0.00000000000000E+00  -4.96512649343890E-13   0.00000000000000E+00   6.32631487433008E-15   2.43779989413435E-22
      4.96511011227219E-10   4.96517337542337E-10  -1.18005959888822E-18  -5.19979200287158E-02  -5.19979200286831E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.27523677998020E-11   0.00000000000000E+00  -3.27523677998020E-11
      5.49455418922658E-18  -5.46358606942900E-01  -5.46212518487963E-01   0.00000000000000E+00   3.40662623288458E-13
     -1.43277640072498E-22  -4.64105632365679E-10  -4.63764969742534E-10  -4.31449459033836E-18
      8.74231424687085E-07
      0.00000000000000E+00  -8.20449037474836E-13   0.00000000000000E+00   9.29183145595928E-15   2.74389352150199E-22
      8.20470674716076E-10   8.20479966547806E-10  -1.12997749873164E-18  -7.19288415879423E-02  -7.19288415879038E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.84977814104171E-11   0.00000000000000E+00  -3.84977814104171E-11
      5.41755862640574E-18  -5.55584764831102E-01  -5.55338434553218E-01   0.00000000000000E+00   3.41489247923462E-13
     -1.41950148216386E-22  -7.82323674385171E-10  -7.81982185137389E-10  -4.28758112767410E-18
      8.76231424687085E-07
      0.00000000000000E+00  -1.32109469999306E-12   0.00000000000000E+00   1.35159841710827E-14   2.95671281058721E-22
      1.32112655752095E-09   1.32114007350542E-09  -1.08100010078285E-18  -9.17247860804502E-02  -9.17247860804074E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.28199332520109E-11   0.00000000000000E+00  -4.28199332520109E-11
      5.33191875990172E-18  -5.63667645178636E-01  -5.63264962219516E-01   0.00000000000000E+00   3.12705132072038E-13
     -1.40703433446266E-22  -1.27863284538534E-09  -1.27832014025341E-09  -4.25091865911887E-18
      8.78231424687085E-07
      0.00000000000000E+00  -2.06173066083456E-12   0.00000000000000E+00   1.93190071313371E-14   3.12930297510837E-22
      2.06167985609852E-09   2.06169917510597E-09  -1.03487787951943E-18  -1.11220207406387E-01  -1.11220207406340E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74329666438400E-11   0.00000000000000E+00  -4.74329666438400E-11
      5.23705282661404E-18  -5.70165053978419E-01  -5.69530537561204E-01   0.00000000000000E+00   2.85571392254936E-13
     -1.39533319783193E-22  -2.01455177985424E-09  -2.01426620846213E-09  -4.20217494709461E-18
      8.80231424687085E-07
      0.00000000000000E+00  -3.10426027287720E-12   0.00000000000000E+00   2.66668922792481E-14   3.27982024284340E-22
      3.10424195937382E-09   3.10426862626642E-09  -9.92280279114043E-19  -1.30362481636814E-01  -1.30362481636761E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28362715211207E-11   0.00000000000000E+00  -5.28362715211207E-11
      5.13138028357180E-18  -5.74523890330102E-01  -5.73562650136728E-01   0.00000000000000E+00   2.66549564981010E-13
     -1.38408265594155E-22  -3.05169890431014E-09  -3.05143235474530E-09  -4.13910000445775E-18
      8.82231424687085E-07
      0.00000000000000E+00  -4.49928998632232E-12   0.00000000000000E+00   3.52676437969181E-14   3.40780454254721E-22
      4.49922219945218E-09   4.49925746709632E-09  -9.53166362404342E-19  -1.49131029357186E-01  -1.49131029357127E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.89980416821155E-11   0.00000000000000E+00  -5.89980416821155E-11
      5.01338420020757E-18  -5.76103878166575E-01  -5.74705132833800E-01   0.00000000000000E+00   2.62357732127293E-13
     -1.37267259468378E-22  -4.44052178314620E-09  -4.44025942541421E-09  -4.06021783780323E-18
      8.84231424687085E-07
      0.00000000000000E+00  -6.28098604341113E-12   0.00000000000000E+00   4.47136402020077E-14   3.50738997069301E-22
      6.28098305752420E-09   6.28102777116476E-09  -9.17090026747456E-19  -1.67521803170006E-01  -1.67521803169940E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55375148141519E-11   0.00000000000000E+00  -6.55375148141519E-11
      4.88230917057926E-18  -5.74209532800657E-01  -5.72251554064884E-01   0.00000000000000E+00   2.82015780575391E-13
     -1.36008364415855E-22  -6.21577227213105E-09  -6.21549025635061E-09  -3.96521914383181E-18
      8.86231424687085E-07
      0.00000000000000E+00  -8.47203409423389E-12   0.00000000000000E+00   5.47553665281355E-14   3.57248015600596E-22
      8.47193969289900E-09   8.47199444826588E-09  -8.83460401528331E-19  -1.85538275043525E-01  -1.85538275043453E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19481442732887E-11   0.00000000000000E+00  -7.19481442732887E-11
      4.73841288203269E-18  -5.68113879424636E-01  -5.65467714373968E-01   0.00000000000000E+00   3.34155328517064E-13
     -1.34485693328834E-22  -8.40038045932099E-09  -8.40004630399261E-09  -3.85495248050436E-18
      8.88231424687085E-07
      0.00000000000000E+00  -1.10906193967577E-11   0.00000000000000E+00   6.52555935775025E-14   3.59764789326738E-22
      1.10905315290978E-08   1.10905967846917E-08  -8.51705004292540E-19  -2.03187013874761E-01  -2.03187013874683E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.78264391865949E-11   0.00000000000000E+00  -7.78264391865949E-11
      4.58276000365949E-18  -5.57066533756581E-01  -5.53597287204782E-01   0.00000000000000E+00   4.22730473100501E-13
     -1.32523058627749E-22  -1.10131930759781E-08  -1.10127703455051E-08  -3.73105499936695E-18
      8.90231424687086E-07
      0.00000000000000E+00  -1.41555701221101E-11   0.00000000000000E+00   7.62361437559559E-14   3.57720724144100E-22
      1.41554590787581E-08   1.41555353149022E-08  -8.21342808036219E-19  -2.20475624666221E-01  -2.20475624666138E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.30040376498247E-11   0.00000000000000E+00  -8.30040376498247E-11
      4.41675192835985E-18  -5.40293390861586E-01  -5.35860214238943E-01   0.00000000000000E+00   5.42309904711887E-13
     -1.29948075730623E-22  -1.40730735871569E-08  -1.40725312772524E-08  -3.59540912032363E-18
      8.92231424687086E-07
      0.00000000000000E+00  -1.76811222045582E-11   0.00000000000000E+00   8.75916615138160E-14   3.50332680168812E-22
      1.76810438836234E-08   1.76811314752852E-08  -7.92003753891058E-19  -2.37411722782939E-01  -2.37411722782851E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75651392744582E-11   0.00000000000000E+00  -8.75651392744582E-11
      4.24162164981093E-18  -5.17004885873825E-01  -5.11462433951734E-01   0.00000000000000E+00   6.76136181387606E-13
     -1.26641584157777E-22  -1.75942424721920E-08  -1.75935663360108E-08  -3.44961789591987E-18
      8.94231424687086E-07
      0.00000000000000E+00  -2.16637855440882E-11   0.00000000000000E+00   9.88765990980708E-14   3.36444864842705E-22
      2.16636585313050E-08   2.16637574079045E-08  -7.63422585467243E-19  -2.54002482020621E-01  -2.54002482020529E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.17468527616268E-11   0.00000000000000E+00  -9.17468527616268E-11
      4.05812794428768E-18  -4.86429563239403E-01  -4.79633696169168E-01   0.00000000000000E+00   8.00585024401636E-13
     -1.22577390256101E-22  -2.15728111401671E-08  -2.15720105551428E-08  -3.29470535882043E-18
      8.96231424687086E-07
      0.00000000000000E+00  -2.60666385563426E-11   0.00000000000000E+00   1.09274859076828E-13   3.14895096386669E-22
      2.60664812549253E-08   2.60665905297847E-08  -7.35414465317411E-19  -2.70254728998373E-01  -2.70254728998277E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.57184775156990E-11   0.00000000000000E+00  -9.57184775156990E-11
      3.86669098925628E-18  -4.47875864516554E-01  -4.39694085155558E-01   0.00000000000000E+00   8.97269759189801E-13
     -1.17801442549821E-22  -2.59717693220280E-08  -2.59708720522690E-08  -3.13127652393887E-18
      8.98231424687086E-07
      0.00000000000000E+00  -3.08168483647159E-11   0.00000000000000E+00   1.17901297698583E-13   2.86398827772723E-22
      3.08167267729690E-08   3.08168446742670E-08  -7.07831939402791E-19  -2.86175571292042E-01  -2.86175571291942E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93178595207751E-11   0.00000000000000E+00  -9.93178595207751E-11
      3.66805527021473E-18  -4.00800751471078E-01  -3.91123431828291E-01   0.00000000000000E+00   9.64829736824209E-13
     -1.12316974184190E-22  -3.07184916444829E-08  -3.07175268147462E-08  -2.96022333081194E-18
      9.00231424687086E-07
      0.00000000000000E+00  -3.57920777792476E-11   0.00000000000000E+00   1.23519172850648E-13   2.56155015083181E-22
      3.57919470271906E-08   3.57920705463637E-08  -6.80551469051250E-19  -3.01772467136619E-01  -3.01772467136517E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02331430673690E-10   0.00000000000000E+00  -1.02331430673690E-10
      3.46339240886735E-18  -3.44920195909433E-01  -3.33676208483475E-01   0.00000000000000E+00   1.00085434807896E-12
     -1.05973483742892E-22  -3.56907399700381E-08  -3.56897391156901E-08  -2.78284093981610E-18
      9.02231424687086E-07
      0.00000000000000E+00  -4.06537870985908E-11   0.00000000000000E+00   1.20770009728918E-13   2.30371028790704E-22
      4.06536443496120E-08   4.06537651196220E-08  -6.53591989895932E-19  -3.17050449213092E-01  -3.17050449212985E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05949978964943E-10   0.00000000000000E+00  -1.05949978964943E-10
      3.25149245093746E-18  -2.80655840738956E-01  -2.67881084165102E-01   0.00000000000000E+00   9.56467984552306E-13
     -9.84323149224186E-23  -4.05487716086415E-08  -4.05478151406570E-08  -2.59790046104153E-18
      9.04231424687086E-07
      0.00000000000000E+00  -4.45334924877112E-11   0.00000000000000E+00   9.64934419437500E-14   2.01334097337262E-22
      4.45334310227438E-08   4.45335275161859E-08  -6.27263165129366E-19  -3.32008057595035E-01  -3.32008057594922E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13459719682968E-10   0.00000000000000E+00  -1.13459719682968E-10
      3.02457301157153E-18  -2.10100182086841E-01  -1.96105227255801E-01   0.00000000000000E+00   7.81860090357020E-13
     -8.98502228082881E-23  -4.44208496565932E-08  -4.44200677965029E-08  -2.39730984644216E-18
      9.06231424687086E-07
      0.00000000000000E+00  -4.64913467507640E-11   0.00000000000000E+00   6.27532154401648E-14   1.48337165975474E-22
      4.64913098157000E-08   4.64913725689156E-08  -6.01852657359603E-19  -3.46644298957255E-01  -3.46644298957131E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24651865159558E-10   0.00000000000000E+00  -1.24651865159558E-10
      2.77526928125241E-18  -1.37104039550375E-01  -1.22495608248184E-01   0.00000000000000E+00   5.46231027337850E-13
     -8.23886577536671E-23  -4.63672669347833E-08  -4.63667207037561E-08  -2.17341662389281E-18
      9.08231424687086E-07
      0.00000000000000E+00  -4.34343865175487E-11   0.00000000000000E+00  -7.43362401095990E-14   7.75728948869551E-23
      4.34344863687268E-08   4.34344120324868E-08  -5.76558683741349E-19  -3.60980116885138E-01  -3.60980116885010E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28337287312342E-10   0.00000000000000E+00  -1.28337287312342E-10
      2.51859470662773E-18  -7.14744796200595E-02  -5.78302369596908E-02   0.00000000000000E+00   4.52365288539864E-13
     -6.19356521903586E-23  -4.33065271104629E-08  -4.33060747451744E-08  -1.94203602288638E-18
      9.10231424687086E-07
      0.00000000000000E+00  -3.02423595334828E-11   0.00000000000000E+00  -3.26163310916313E-13   3.00933576881549E-23
      3.02427195129134E-08   3.02423933496025E-08  -5.46669240553178E-19  -3.75082719939793E-01  -3.75082719939693E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00668514310329E-10   0.00000000000000E+00  -1.00668514310329E-10
      2.31725767800707E-18  -3.28105247618974E-02  -2.33138765668019E-02   0.00000000000000E+00   4.99162707519651E-13
     -2.77112477109481E-23  -3.01422239979997E-08  -3.01417248352922E-08  -1.77058843745389E-18
      9.12231424687086E-07
      0.00000000000000E+00  -1.90351891652087E-11   0.00000000000000E+00  -2.76533259588710E-13   1.28596664770448E-23
      1.90355432000655E-08   1.90352666668059E-08  -5.13163163570031E-19  -3.88962263077519E-01  -3.88962263077449E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.01161370322744E-11   0.00000000000000E+00  -7.01161370322744E-11
      2.17702540394252E-18  -1.67128732010227E-02  -1.07375788850697E-02   0.00000000000000E+00   3.53268863164711E-13
     -1.28975155605012E-23  -1.89655037986368E-08  -1.89651505297736E-08  -1.66386224037249E-18
      9.14231424687086E-07
      0.00000000000000E+00  -1.39706866661113E-11   0.00000000000000E+00  -1.24656844697389E-13   7.24878437109230E-24
      1.39707709468512E-08   1.39706462900065E-08  -4.79279417355367E-19  -4.02588676527973E-01  -4.02588676527916E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71366891718408E-11   0.00000000000000E+00  -5.71366891718408E-11
      2.06275202559884E-18  -1.07790952479410E-02  -6.39540200470395E-03   0.00000000000000E+00   1.70215943781279E-13
     -7.84856928694963E-24  -1.39136798167784E-08  -1.39135096008347E-08  -1.58347260824347E-18
      9.16231424687086E-07
      0.00000000000000E+00  -1.21348940588073E-11   0.00000000000000E+00  -4.49785044203914E-14   5.17322187432839E-24
      1.21349729825143E-08   1.21349280040098E-08  -4.45951747758778E-19  -4.15948965746985E-01  -4.15948965746931E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33152803507979E-11   0.00000000000000E+00  -5.33152803507979E-11
      1.95612146489724E-18  -8.52439578103228E-03  -4.71787052628449E-03   0.00000000000000E+00   7.95353841885161E-14
     -5.83062358038173E-24  -1.20816922590432E-08  -1.20816127236590E-08  -1.51016971713847E-18
      9.18231424687086E-07
      0.00000000000000E+00  -1.15131051879123E-11   0.00000000000000E+00  -1.50587995867601E-14   4.18842494667241E-24
      1.15130768288981E-08   1.15130617700985E-08  -4.13398450436618E-19  -4.29042018741419E-01  -4.29042018741366E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27103089562152E-11   0.00000000000000E+00  -5.27103089562152E-11
      1.85070084698481E-18  -7.51573013904273E-03  -3.90494183964268E-03   0.00000000000000E+00   4.45060864220321E-14
     -4.80820230825946E-24  -1.14603959672287E-08  -1.14603514611423E-08  -1.43730239654819E-18
      9.20231424687086E-07
      0.00000000000000E+00  -1.12924941291398E-11   0.00000000000000E+00  -5.18508310568692E-15   3.59757443627902E-24
      1.12924645986432E-08   1.12924594135601E-08  -3.81713771715953E-19  -4.41871088538173E-01  -4.41871088538120E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30926121011661E-11   0.00000000000000E+00  -5.30926121011661E-11
      1.74451562278248E-18  -6.95002286410897E-03  -3.40885769171431E-03   0.00000000000000E+00   3.13830916344829E-14
     -4.15513530025102E-24  -1.12393981845506E-08  -1.12393668014589E-08  -1.36280185106653E-18
      9.22231424687086E-07
      0.00000000000000E+00  -1.12001901682463E-11   0.00000000000000E+00  -2.04109419719203E-15   3.18805325506508E-24
      1.12001892399406E-08   1.12001871988464E-08  -3.50961770713688E-19  -4.54440759817672E-01  -4.54440759817618E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37248909094563E-11   0.00000000000000E+00  -5.37248909094563E-11
      1.63706584096357E-18  -6.57081034321424E-03  -3.05891461043744E-03   0.00000000000000E+00   2.57307120739132E-14
     -3.67529071243709E-24  -1.11464880386490E-08  -1.11464623079369E-08  -1.28610407024988E-18
      9.24231424687086E-07
      0.00000000000000E+00  -1.11517879917379E-11   0.00000000000000E+00  -9.76493065738337E-16   2.88230806722641E-24
      1.11518303600251E-08   1.11518293835321E-08  -3.21183096403629E-19  -4.66755896944235E-01  -4.66755896944181E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43647241103522E-11   0.00000000000000E+00  -5.43647241103522E-11
      1.52833639274286E-18  -6.29037394665850E-03  -2.79391420844026E-03   0.00000000000000E+00   2.25730870272448E-14
     -3.29983312296457E-24  -1.10974872325087E-08  -1.10974646594217E-08  -1.20715329633924E-18
      9.26231424687086E-07
      0.00000000000000E+00  -1.11214792284594E-11   0.00000000000000E+00  -5.50054285481789E-16   2.64449475851790E-24
      1.11214350936490E-08   1.11214345435947E-08  -2.92396189572877E-19  -4.78821194419938E-01  -4.78821194419883E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49261525350005E-11   0.00000000000000E+00  -5.49261525350005E-11
      1.41848408767286E-18  -6.07271651892486E-03  -2.58600867047451E-03   0.00000000000000E+00   2.03520175791065E-14
     -2.99761449043637E-24  -1.10665287430773E-08  -1.10665083910597E-08  -1.12608789809999E-18
      9.28231424687086E-07
      0.00000000000000E+00  -1.11002630941645E-11   0.00000000000000E+00  -3.37583102137120E-16   2.45443532046896E-24
      1.11002429846853E-08   1.11002426471022E-08  -2.64601595242670E-19  -4.90640694829737E-01  -4.90640694829681E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53738582309672E-11   0.00000000000000E+00  -5.53738582309672E-11
      1.30773637121093E-18  -5.89921925625066E-03  -2.41932804945000E-03   0.00000000000000E+00   1.85826517173389E-14
     -2.75032036080144E-24  -1.10448873715229E-08  -1.10448687888712E-08  -1.04313477596826E-18
      9.30231424687086E-07
      0.00000000000000E+00  -1.10846494888392E-11   0.00000000000000E+00  -2.12650561600814E-16   2.29935685986650E-24
      1.10846408362693E-08   1.10846406236187E-08  -2.37789291411586E-19  -5.02216474190789E-01  -5.02216474190733E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56865979666420E-11   0.00000000000000E+00  -5.56865979666420E-11
      1.19636317527764E-18  -5.75838784348785E-03  -2.28350968232663E-03   0.00000000000000E+00   1.70953365334301E-14
     -2.54542797096813E-24  -1.10289711209886E-08  -1.10289540256521E-08  -9.58573883866058E-19
      9.32231424687086E-07
      0.00000000000000E+00  -1.10727096730022E-11   0.00000000000000E+00  -1.33589446153066E-16   2.17068530145319E-24
      1.10727192146869E-08   1.10727190810974E-08  -2.11954395057535E-19  -5.13543428966830E-01  -5.13543428966774E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58261833464103E-11   0.00000000000000E+00  -5.58261833464103E-11
      1.08471080858482E-18  -5.64243206209888E-03  -2.17135287774846E-03   0.00000000000000E+00   1.58073918520095E-14
     -2.37388008785270E-24  -1.10169087051429E-08  -1.10168928977510E-08  -8.72756413527288E-19
      9.34231424687086E-07
      0.00000000000000E+00  -1.10631578203326E-11   0.00000000000000E+00  -8.62624953225125E-17   2.06259065521744E-24
      1.10631371572932E-08   1.10631370710307E-08  -1.87146220694333E-19  -5.24588333278261E-01  -5.24588333278206E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56498885361623E-11   0.00000000000000E+00  -5.56498885361623E-11
      9.73411031512499E-19  -5.54593222236811E-03  -2.07781549155349E-03   0.00000000000000E+00   1.46419510214922E-14
     -2.22920687199393E-24  -1.10075018244456E-08  -1.10074871824946E-08  -7.86264810818165E-19
      9.36231424687087E-07
      0.00000000000000E+00  -1.10546162597723E-11   0.00000000000000E+00  -7.08327940506829E-17   1.97126979102575E-24
      1.10546473932225E-08   1.10546473223897E-08  -1.63553619503308E-19  -5.35250232527256E-01  -5.35250232527201E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47999026050332E-11   0.00000000000000E+00  -5.47999026050332E-11
      8.63811226302433E-19  -5.46522138302665E-03  -1.99951090100703E-03   0.00000000000000E+00   1.34944682821881E-14
     -2.10711551585663E-24  -1.09998609142529E-08  -1.09998474197847E-08  -7.00257606799124E-19
      9.38231424687087E-07
      0.00000000000000E+00  -1.10462583886865E-11   0.00000000000000E+00  -8.05497307554982E-17   1.89430087046063E-24
      1.10462507456358E-08   1.10462506650861E-08  -1.41500375505968E-19  -5.45359137307168E-01  -5.45359137307115E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28862170512078E-11   0.00000000000000E+00  -5.28862170512078E-11
      7.58038792200017E-19  -5.39782757306616E-03  -1.93415907094599E-03   0.00000000000000E+00   1.22792504482923E-14
     -2.00470619309731E-24  -1.09933767272853E-08  -1.09933644480349E-08  -6.16538416694051E-19
      9.40231424687087E-07
      0.00000000000000E+00  -1.10371657597029E-11   0.00000000000000E+00  -1.10909832546048E-16   1.83014356799202E-24
      1.10371772786291E-08   1.10371771677192E-08  -1.21426061486942E-19  -5.54682393467966E-01  -5.54682393467916E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95356462403983E-11   0.00000000000000E+00  -4.95356462403983E-11
      6.58967499719221E-19  -5.34207752488627E-03  -1.88021154502367E-03   0.00000000000000E+00   1.09263018791486E-14
     -1.92003048638192E-24  -1.09876524477807E-08  -1.09876415214788E-08  -5.37541438232279E-19
      9.42231424687087E-07
      0.00000000000000E+00  -1.10266036149240E-11   0.00000000000000E+00  -1.63882189197342E-16   1.77799092334293E-24
      1.10266054260656E-08   1.10266052621834E-08  -1.03934123647465E-19  -5.62901225268840E-01  -5.62901225268796E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.42426615629957E-11   0.00000000000000E+00  -4.42426615629957E-11
      5.70482176593230E-19  -5.29697761412359E-03  -1.83677433630969E-03   0.00000000000000E+00   9.35155177440298E-15
     -1.85210511809807E-24  -1.09823719521721E-08  -1.09823626006204E-08  -4.66548052945765E-19
      9.44231424687087E-07
      0.00000000000000E+00  -1.10135616622406E-11   0.00000000000000E+00  -2.44783975521729E-16   1.73776393975800E-24
      1.10135652857427E-08   1.10135650409587E-08  -8.98450606216339E-20  -5.69585404629900E-01  -5.69585404629864E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.63621051556449E-11   0.00000000000000E+00  -3.63621051556449E-11
      4.97757966281940E-19  -5.26219334745816E-03  -1.80361530996597E-03   0.00000000000000E+00   7.44366819511215E-15
     -1.80096067273536E-24  -1.09772103794712E-08  -1.09772029358030E-08  -4.07912905660305E-19
      9.46231424687087E-07
      0.00000000000000E+00  -1.09970296095432E-11   0.00000000000000E+00  -3.54792066650074E-16   1.71010608749642E-24
      1.09970288383503E-08   1.09970284835582E-08  -8.02032117842206E-20  -5.74192424023918E-01  -5.74192424023893E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52562333109444E-11   0.00000000000000E+00  -2.52562333109444E-11
      4.47245499660051E-19  -5.23803237744439E-03  -1.78116510464281E-03   0.00000000000000E+00   5.08592803001205E-15
     -1.76764871753100E-24  -1.09717773361753E-08  -1.09717722502472E-08  -3.67042287875831E-19
      9.48231424687087E-07
      0.00000000000000E+00  -1.09760890094599E-11   0.00000000000000E+00  -4.94151209785010E-16   1.69645598105010E-24
      1.09761286110645E-08   1.09761281169133E-08  -7.62475429836264E-20  -5.76089494765468E-01  -5.76089494765458E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04507908383969E-11   0.00000000000000E+00  -1.04507908383969E-11
      4.26343917983257E-19  -5.22555010454910E-03  -1.77060303975960E-03   0.00000000000000E+00   2.17077683057462E-15
     -1.75440762113440E-24  -1.09656794968517E-08  -1.09656773260749E-08  -3.50096374999630E-19
      9.50231424687087E-07
      0.00000000000000E+00  -1.09501887935674E-11   0.00000000000000E+00  -6.57043356541391E-16   1.69928142381913E-24
      1.09501629606169E-08   1.09501623035736E-08  -7.93780134414914E-20  -5.74585465381183E-01  -5.74585465381192E-01
      0.00000000000000E+00   0.00000000000000E+00   8.26694449830497E-12   0.00000000000000E+00   8.26694449830497E-12
      4.42877806979867E-19  -5.22675656397015E-03  -1.77409322909915E-03   0.00000000000000E+00  -1.41693882395944E-15
     -1.76515489909060E-24  -1.09584278311331E-08  -1.09584292480719E-08  -3.63499793538375E-19
      9.52231424687087E-07
      0.00000000000000E+00  -1.09184105144936E-11   0.00000000000000E+00  -8.46479123375812E-16   1.72267281456672E-24
      1.09184148497832E-08   1.09184140033040E-08  -9.11555501882547E-20  -5.68955973499221E-01  -5.68955973499252E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08312244696261E-11   0.00000000000000E+00   3.08312244696261E-11
      5.04540255919119E-19  -5.24516249737792E-03  -1.79539309344158E-03   0.00000000000000E+00  -5.82109754299752E-15
     -1.80668693687354E-24  -1.09492394066761E-08  -1.09492452277737E-08  -4.13384705730865E-19
      9.54231424687087E-07
      0.00000000000000E+00  -1.08797438801292E-11   0.00000000000000E+00  -1.76668327697361E-15   1.77362486125666E-24
      1.08797518075579E-08   1.08797500408746E-08  -1.13360004130301E-19  -5.58453030716933E-01  -5.58453030716990E-01
      0.00000000000000E+00   0.00000000000000E+00   5.69060432895128E-11   0.00000000000000E+00   5.69060432895128E-11
      6.18352342498144E-19  -5.28708396395325E-03  -1.84128143845336E-03   0.00000000000000E+00  -1.05818538049786E-14
     -1.89139055665207E-24  -1.09366455023103E-08  -1.09366560841641E-08  -5.04992338367845E-19
      9.56231424687087E-07
      0.00000000000000E+00  -1.08318009273069E-11   0.00000000000000E+00  -1.38155676744016E-15   1.86471271161836E-24
      1.08318049497239E-08   1.08318035681671E-08  -1.48106177606038E-19  -5.42304889121131E-01  -5.42304889121217E-01
      0.00000000000000E+00   0.00000000000000E+00   8.58061432804735E-11   0.00000000000000E+00   8.58061432804735E-11
      7.89964629059091E-19  -5.36468364340993E-03  -1.92488325276327E-03   0.00000000000000E+00  -1.81743114902377E-14
     -2.04364088093146E-24  -1.09175915371361E-08  -1.09176097114476E-08  -6.41858451453054E-19
      9.58231424687087E-07
      0.00000000000000E+00  -1.07689791270569E-11   0.00000000000000E+00  -5.35574230551320E-14   2.01982910651514E-24
      1.07689182380961E-08   1.07688646806730E-08  -1.97993889048996E-19  -5.19722552989022E-01  -5.19722552989138E-01
      0.00000000000000E+00   0.00000000000000E+00   1.16230414733680E-10   0.00000000000000E+00   1.16230414733680E-10
      1.02242545852645E-18  -5.50348153646676E-03  -2.07391082071376E-03   0.00000000000000E+00   2.44617802037842E-14
     -2.31683513370919E-24  -1.08851195571869E-08  -1.08850950954067E-08  -8.24431569477456E-19
      9.60231424687087E-07
      0.00000000000000E+00  -1.06756648740541E-11   0.00000000000000E+00  -3.27371748101429E-15   2.28659642187230E-24
      1.06757062667109E-08   1.06757029929934E-08  -2.66211641299971E-19  -4.89930224517670E-01  -4.89930224517816E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45794387820874E-10   0.00000000000000E+00   1.45794387820874E-10
      1.31401423416820E-18  -5.76321902823922E-03  -2.35370495859980E-03   0.00000000000000E+00  -3.92341942552092E-14
     -2.84738488855468E-24  -1.08214581466200E-08  -1.08214973808143E-08  -1.04780259286823E-18
      9.62231424687087E-07
      0.00000000000000E+00  -1.05034559917900E-11   0.00000000000000E+00  -4.89417810590816E-15   2.75748499786757E-24
      1.05034399173706E-08   1.05034350231925E-08  -3.56287618365769E-19  -4.52224886324473E-01  -4.52224886324644E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70670311328882E-10   0.00000000000000E+00   1.70670311328882E-10
      1.65535485682596E-18  -6.30515529654243E-03  -2.94208437737100E-03   0.00000000000000E+00  -5.80803579546360E-14
     -4.06636049942412E-24  -1.06740472541634E-08  -1.06741053345214E-08  -1.29906723846020E-18
      9.64231424687087E-07
      0.00000000000000E+00  -1.00737144663959E-11   0.00000000000000E+00  -1.39764905181379E-13   3.52628054898905E-24
      1.00737329824593E-08   1.00735932175542E-08  -4.70482447821351E-19  -4.06045038153203E-01  -4.06045038153390E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86833215310628E-10   0.00000000000000E+00   1.86833215310628E-10
      2.02902128744722E-18  -7.64378760572455E-03  -4.41102017697640E-03   0.00000000000000E+00   4.23370170609666E-14
     -7.69503801263472E-24  -1.02604687698819E-08  -1.02604264328648E-08  -1.55853883962587E-18
      9.66231424687086E-07
      0.00000000000000E+00  -8.72782168735685E-12   0.00000000000000E+00  -3.46514762893002E-14   3.73377835209553E-24
      8.72784046158953E-09   8.72780581011324E-09  -6.05035439066719E-19  -3.51068865845019E-01  -3.51068865845216E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97240496944968E-10   0.00000000000000E+00   1.97240496944968E-10
      2.42350228133716E-18  -1.15647667532502E-02  -8.75278452351117E-03   0.00000000000000E+00  -1.25750903113846E-13
     -2.08461214790274E-23  -8.92492055615508E-09  -8.92504630705821E-09  -1.81846684227044E-18
      9.68231424687086E-07
      0.00000000000000E+00  -5.30908503428108E-12   0.00000000000000E+00  -8.64413369444681E-14  -3.53525854495837E-24
      5.30913190558117E-09   5.30904546424422E-09  -7.47211215777455E-19  -2.87606516905930E-01  -2.87606516906150E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19205998489265E-10   0.00000000000000E+00   2.19205998489265E-10
      2.86191427831569E-18  -2.20440196194913E-02  -2.03022631741723E-02   0.00000000000000E+00  -1.85694944862080E-13
     -5.40656731191998E-23  -5.52806576778858E-09  -5.52825146273349E-09  -2.11470306253824E-18
      9.70231424687086E-07
      0.00000000000000E+00  -1.74027408060822E-12   0.00000000000000E+00  -9.09420213074626E-14  -2.34089483959996E-23
      1.74032946093250E-09   1.74023851891117E-09  -8.90789947717143E-19  -2.17540023734096E-01  -2.17540023734338E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42161802299334E-10   0.00000000000000E+00   2.42161802299334E-10
      3.34623788291436E-18  -3.92412992830324E-02  -3.86167199538871E-02   0.00000000000000E+00  -3.35993806278854E-13
     -8.05554319830059E-23  -1.98206432740414E-09  -1.98240032121050E-09  -2.45544793519721E-18
      9.72231424687086E-07
      0.00000000000000E+00  -3.17139877577590E-13   0.00000000000000E+00  -3.89807457891592E-14  -3.89676812547531E-23
      3.17159929365555E-10   3.17120948619727E-10  -1.03802904734866E-18  -1.44558686194592E-01  -1.44558686194833E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41202925726903E-10   0.00000000000000E+00   2.41202925726903E-10
      3.82864373436816E-18  -5.88769401305029E-02  -5.87010347267355E-02   0.00000000000000E+00  -5.74785894820426E-13
     -8.95965166447186E-23  -5.57749088451720E-10  -5.58323874346630E-10  -2.79061468701950E-18
      9.74231424687086E-07
      0.00000000000000E+00   1.83689474415053E-15   0.00000000000000E+00  -1.23533624432176E-14  -4.45592062629395E-23
     -1.85298313256387E-12  -1.86533649505164E-12  -1.17508338532789E-18  -7.71869810933757E-02  -7.71869810935872E-02
      0.00000000000000E+00   0.00000000000000E+00   2.11490784307343E-10   0.00000000000000E+00   2.11490784307343E-10
      4.25162530298285E-18  -7.88016012571351E-02  -7.87355568296925E-02   0.00000000000000E+00  -7.77888753966197E-13
     -9.66723660729854E-23  -2.08847559058229E-10  -2.09625447812292E-10  -3.07654191765496E-18
      9.76231424687086E-07
      0.00000000000000E+00   2.48899237832398E-14   0.00000000000000E+00  -3.50075346880368E-15  -4.58403094311175E-23
     -2.48875075453930E-11  -2.48910082989076E-11  -1.26109476116738E-18  -3.55034458241508E-02  -3.55034458242958E-02
      0.00000000000000E+00   0.00000000000000E+00   1.44978680004218E-10   0.00000000000000E+00   1.44978680004218E-10
      4.54158266299128E-18  -9.85026876601912E-02  -9.84648530542563E-02   0.00000000000000E+00  -6.67525541675957E-13
     -1.01913864253517E-22  -1.19420146163532E-10  -1.20087671705310E-10  -3.28048790182390E-18
      9.78231424687086E-07
      0.00000000000000E+00   4.31670264875376E-15   0.00000000000000E+00  -4.34663414866328E-16  -4.59940655537139E-23
     -4.34482390543753E-12  -4.34525856889839E-12  -1.29999329305924E-18  -1.77352707723805E-02  -1.77352707724682E-02
      0.00000000000000E+00   0.00000000000000E+00   8.77119922826931E-11   0.00000000000000E+00   8.77119922826931E-11
      4.71700664755667E-18  -1.17879946754728E-01  -1.17853681580567E-01   0.00000000000000E+00  -4.27947870537908E-13
     -1.04822438509293E-22  -8.29387858431525E-11  -8.33667337137952E-11  -3.41701335449744E-18
      9.80231424687086E-07
      0.00000000000000E+00  -1.24908842602236E-14   0.00000000000000E+00   4.00937625083181E-16  -4.55509897551715E-23
      1.24449205251145E-11   1.24453214626940E-11  -1.31538128919661E-18  -1.11532545751355E-02  -1.11532545751920E-02
      0.00000000000000E+00   0.00000000000000E+00   5.65671252198954E-11   0.00000000000000E+00   5.65671252198954E-11
      4.83014089799646E-18  -1.36894247433246E-01  -1.36872504832991E-01   0.00000000000000E+00  -3.06685407607520E-13
     -1.06746969396100E-22  -6.87057612748746E-11  -6.90124466825889E-11  -3.51475960879985E-18
      9.82231424687086E-07
      0.00000000000000E+00  -2.38796316739570E-14   0.00000000000000E+00   4.97875601590506E-16  -4.43964403217554E-23
      2.38459032417989E-11   2.38464011173560E-11  -1.32079002252030E-18  -8.67624766069319E-03  -8.67624766073385E-03
      0.00000000000000E+00   0.00000000000000E+00   4.06503653624184E-11   0.00000000000000E+00   4.06503653624184E-11
      4.91144162872130E-18  -1.55532127591159E-01  -1.55511807795648E-01   0.00000000000000E+00  -2.73103485464492E-13
     -1.08379220978331E-22  -6.42236629942016E-11  -6.44967664797745E-11  -3.59065160620100E-18
      9.84231424687086E-07
      0.00000000000000E+00  -3.20538132854268E-14   0.00000000000000E+00   4.21516156827823E-16  -4.21890532054191E-23
      3.20522306211530E-11   3.20526521372677E-11  -1.32204649233721E-18  -7.59185162274607E-03  -7.59185162277792E-03
      0.00000000000000E+00   0.00000000000000E+00   3.18500584004449E-11   0.00000000000000E+00   3.18500584004449E-11
      4.97514174552219E-18  -1.73792878577230E-01  -1.73772746046763E-01   0.00000000000000E+00  -2.72441831559152E-13
     -1.09947222731439E-22  -6.36302687060441E-11  -6.39027105377132E-11  -3.65309525318498E-18
      9.86231424687086E-07
      0.00000000000000E+00  -3.83911001527462E-14   0.00000000000000E+00   3.29097997016135E-16  -3.85120879108960E-23
      3.84288149335747E-11   3.84291440315332E-11  -1.32153769807643E-18  -6.99724734605039E-03  -6.99724734607684E-03
      0.00000000000000E+00   0.00000000000000E+00   2.64490899461316E-11   0.00000000000000E+00   2.64490899461316E-11
      5.02803992541445E-18  -1.91681384782441E-01  -1.91660945017527E-01   0.00000000000000E+00  -2.79882378357943E-13
     -1.11506444030178E-22  -6.45983515991953E-11  -6.48782339776648E-11  -3.70650222733803E-18
      9.88231424687086E-07
      0.00000000000000E+00  -4.37180949107827E-14   0.00000000000000E+00   2.59397523578062E-16  -3.29425078756384E-23
      4.37172617948007E-11   4.37175211922913E-11  -1.32027433830085E-18  -6.60436405588119E-03  -6.60436405590406E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28629035248528E-11   0.00000000000000E+00   2.28629035248528E-11
      5.07376573246416E-18  -2.09204736552636E-01  -2.09183760624166E-01   0.00000000000000E+00  -2.87431606650778E-13
     -1.13062506915521E-22  -6.62929931103800E-11  -6.65804247171439E-11  -3.75349139416331E-18
      9.90231424687086E-07
      0.00000000000000E+00  -4.83103317711591E-14   0.00000000000000E+00   2.12883321575652E-16  -2.51321973215592E-23
      4.83460017148620E-11   4.83462145981584E-11  -1.31870872848057E-18  -6.31589649825792E-03  -6.31589649827828E-03
      0.00000000000000E+00   0.00000000000000E+00   2.03627315640810E-11   0.00000000000000E+00   2.03627315640810E-11
      5.11449119559232E-18  -2.26370625321149E-01  -2.26348978924489E-01   0.00000000000000E+00  -2.93252483295638E-13
     -1.14610498838948E-22  -6.84156936788292E-11  -6.87089461622395E-11  -3.79578246711175E-18
      9.92231424687086E-07
      0.00000000000000E+00  -5.25351896827053E-14   0.00000000000000E+00   1.83177615718629E-16  -1.49270605654576E-23
      5.25739084196350E-11   5.25740915972358E-11  -1.31705019761860E-18  -6.09281696900036E-03  -6.09281696901892E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85623679974056E-11   0.00000000000000E+00   1.85623679974056E-11
      5.15161593158713E-18  -2.43186539863041E-01  -2.43164128813094E-01   0.00000000000000E+00  -2.97361495581895E-13
     -1.16145366411970E-22  -7.08390980989423E-11  -7.11364595946403E-11  -3.83456573396852E-18
      9.94231424687086E-07
      0.00000000000000E+00  -5.65763581198365E-14   0.00000000000000E+00   1.64363175666845E-16  -2.49116938281564E-24
      5.65563671395667E-11   5.65565315027399E-11  -1.31539435112305E-18  -5.91539178460807E-03  -5.91539178462530E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72294027241560E-11   0.00000000000000E+00   1.72294027241560E-11
      5.18607473703544E-18  -2.59659491332115E-01  -2.59636245712862E-01   0.00000000000000E+00  -3.00221205854139E-13
     -1.17664040855543E-22  -7.34857130209246E-11  -7.37859342268964E-11  -3.87068038591239E-18
      9.96231424687086E-07
      0.00000000000000E+00  -6.03419923453451E-14   0.00000000000000E+00   1.52302073648915E-16   1.13765877146313E-23
      6.03854007471692E-11   6.03855530492542E-11  -1.31378145387707E-18  -5.77160939444224E-03  -5.77160939445845E-03
      0.00000000000000E+00   0.00000000000000E+00   1.62130839622217E-11   0.00000000000000E+00   1.62130839622217E-11
      5.21850090495989E-18  -2.75796319977968E-01  -2.75772188376943E-01   0.00000000000000E+00  -3.02338659829797E-13
     -1.19165589663720E-22  -7.62962983515275E-11  -7.65986370114765E-11  -3.90471945108281E-18
      9.98231424687085E-07
      0.00000000000000E+00  -6.41076265708537E-14   0.00000000000000E+00   1.44426413630647E-16   2.54608889866835E-23
      6.41174306649586E-11   6.41175750913977E-11  -1.31222493412526E-18  -5.65338021216867E-03  -5.65338021218408E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54123932818764E-11   0.00000000000000E+00   1.54123932818764E-11
      5.24932569152364E-18  -2.91604343883682E-01  -2.91579288938650E-01   0.00000000000000E+00  -3.04165618707546E-13
     -1.20650695492533E-22  -7.92258027544454E-11  -7.95299683732736E-11  -3.93710075739837E-18
      1.00000000000000E-06
      0.00000000000000E+00  -6.74140371103246E-14   0.00000000000000E+00   1.39870171381984E-16   3.76890516271316E-23
      6.73758808207808E-11   6.73760206909899E-11  -1.31089279885826E-18  -5.56526172357891E-03  -5.56526172359373E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48208321713978E-11   0.00000000000000E+00   1.48208321713978E-11
      5.27553744941882E-18  -3.05331141587786E-01  -3.05305246601890E-01   0.00000000000000E+00  -3.06359602214606E-13
     -1.21953788076889E-22  -8.18904932600517E-11  -8.21968528623882E-11  -3.96464465056056E-18
}
